/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.uploader;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import replicatorg.app.Base;
import replicatorg.drivers.Version;
import replicatorg.uploader.FirmwareRetriever;
import replicatorg.uploader.ui.UploaderDialog;

public class FirmwareUploader {
    private Frame parent;
    private static FirmwareUploader uploader = null;
    static Document firmwareDoc = null;
    public static final String DEFAULT_UPDATES_URL = "http://s3.amazonaws.com/sailfish-firmware.polar3d.com/release/firmware.xml";

    private FirmwareUploader(Frame parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startUploader(Frame parent) {
        Class<FirmwareUploader> clazz = FirmwareUploader.class;
        synchronized (FirmwareUploader.class) {
            if (uploader != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            uploader = new FirmwareUploader(parent);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            uploader.run();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        UploaderDialog selector = new UploaderDialog(this.parent, this);
        selector.setVisible(true);
        Class<FirmwareUploader> clazz = FirmwareUploader.class;
        synchronized (FirmwareUploader.class) {
            uploader = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void checkFirmware() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                FirmwareRetriever retriever = new FirmwareRetriever(FirmwareUploader.getFirmwareFile(), FirmwareUploader.getFirmwareURL());
                FirmwareRetriever.UpdateStatus status = retriever.checkForUpdates();
                Base.logger.fine("Firmware retriever status: " + status.name());
            }
        }, "Firmware Update Checker");
        t.start();
    }

    protected static URL getFirmwareURL() {
        try {
            String url = Base.preferences.get("replicatorg.updates.url", DEFAULT_UPDATES_URL);
            URL parsedUrl = new URL(url);
            if (parsedUrl.getProtocol().equals("https")) {
                parsedUrl = new URL("http", parsedUrl.getHost(), parsedUrl.getPort(), parsedUrl.getFile());
                Base.logger.fine("Forcing non-SSL firmware url: " + parsedUrl.toExternalForm());
            }
            return parsedUrl;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static File getFirmwareFile() {
        File alternate;
        File f = Base.getUserFile("firmware.xml");
        if (!f.exists() && (alternate = Base.getApplicationFile("firmware.xml.dist")).exists()) {
            return alternate;
        }
        return f;
    }

    public static Document getFirmwareDoc() {
        if (firmwareDoc == null) {
            firmwareDoc = FirmwareUploader.loadFirmwareDoc();
        }
        return firmwareDoc;
    }

    public static void invalidateFirmware() {
        firmwareDoc = null;
        File f = Base.getUserFile("firmware.xml");
        if (f.exists()) {
            f.delete();
        }
    }

    public static boolean checkLatestVersion(final String boardName, Version version) {
        final Version latest = FirmwareUploader.getLatestVersion(boardName);
        if (latest == null) {
            return false;
        }
        if (latest.compareTo(version) > 0) {
            Base.logger.info("latest " + latest.toString() + " old " + version.toString());
            final String key = "replicatorG.ignoreFirmware." + boardName + "." + version.toString();
            if (Base.preferences.getBoolean(key, false)) {
                return false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JCheckBox checkbox = new JCheckBox("Do not show this message for this version again");
                    String message = "A newer version (" + latest.toString() + ") of the " + boardName + " firmware is now available.\n" + "Use the \"Upload Firmware...\" item in the \"Machine\" menu to upload it to your machine.";
                    Object[] params = new Object[]{message, checkbox};
                    JOptionPane.showMessageDialog(null, params, "New Firmware Available", 1);
                    boolean dontShow = checkbox.isSelected();
                    Base.preferences.putBoolean(key, dontShow);
                }
            });
            return true;
        }
        return false;
    }

    public static Version getLatestVersion(String boardName) {
        Document firmwareDoc = FirmwareUploader.getFirmwareDoc();
        if (firmwareDoc == null) {
            return null;
        }
        NodeList nl = firmwareDoc.getElementsByTagName("board");
        Version version = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            String name = nl.item(i).getAttributes().getNamedItem("name").getNodeValue();
            if (!name.equalsIgnoreCase(boardName)) continue;
            NodeList children = nl.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node n = children.item(j);
                if (!"firmware".equalsIgnoreCase(n.getNodeName())) continue;
                int major = Integer.parseInt(n.getAttributes().getNamedItem("major").getNodeValue());
                int minor = Integer.parseInt(n.getAttributes().getNamedItem("minor").getNodeValue());
                Version candidate = new Version(major, minor);
                if (version == null) {
                    version = candidate;
                    continue;
                }
                if (candidate.compareTo(version) <= 0) continue;
                version = candidate;
            }
            break;
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadFirmwareDoc() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Class<FirmwareRetriever> clazz = FirmwareRetriever.class;
            synchronized (FirmwareRetriever.class) {
                try {
                    File f = FirmwareUploader.getFirmwareFile();
                    if (!f.exists()) {
                        Base.showWarning("Firmware.xml Not Found", "The firmware description file 'firmware.xml' was not found.\nYou may see this message if you're running ReplicatorG for the\nfirst time and are not connected to the internet, or if you are\nrunning ReplicatorG on a read-only filesystem.", null);
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        return null;
                    }
                    try {
                        doc = db.parse(f);
                    }
                    catch (SAXException e) {
                        Base.showWarning("Parse error", "Error parsing firmware.xml. \nYou may see this message if you're running ReplicatorG for the\nfirst time and are not connected to the internet, or if you are\nrunning ReplicatorG on a read-only filesystem.", e);
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        return null;
                    }
                }
                catch (IOException e) {
                    Base.showWarning(null, "Could not read firmware.xml.\nYou may see this message if you're running ReplicatorG for the\nfirst time and are not connected to the internet, or if you are\nrunning ReplicatorG on a read-only filesystem.", e);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return null;
                }
                // ** MonitorExit[var3_4] (shouldn't be in output)
            }
        }
        catch (ParserConfigurationException e) {
            Base.showWarning("Unkown error", "Unknown error parsing firmware.xml.", e);
            return null;
        }
        {
            return doc;
        }
    }
}

