from math import sin,cos,sqrt

"""3D Vector"""
class Vector:
    def __init__(self, x, y, z = 0):
        self.x = x
        self.y = y
        self.z = z
    def __add__(self, p):
        return Vector(self.x + p.x,
                     self.y + p.y,
                     self.z + p.z)
    def __sub__(self, p):
        return Vector(self.x - p.x,
                     self.y - p.y,
                     self.z - p.z)
    def rotate(self, a):
        return Vector(self.x*cos(a) - self.y*sin(a),
                      self.y*cos(a) + self.x*sin(a),
                      self.z)
    def __div__(self, div):
        return Vector(self.x / div, self.y / div, self.z / div)
    def __mul__(self, f):
        return Vector(self.x * f, self.y * f, self.z * f)
    def cross(self,p):
        return Vector(self.y*p.z-self.z*p.y,
                     self.z*p.x-self.x*p.z,
                     self.x*p.y-self.y*p.x)
    def norm(self):
        return sqrt(self.x*self.x+self.y*self.y+self.z*self.z)
    def normalize(self):
        n = self.norm()
        if n==0:
            return self
        else:
            return self/self.norm()
    def __repr__(self):
        return 'x={} y={} z={}'.format(self.x, self.y, self.z)
