# Source code from
# http://www.gamedev.net/topic/551375-earcutting-algorithm/
# post #5 by mattd.

def ear(p):
    for i in range(len(p)):
        t = [p[(i - 1) % len(p)], p[i], p[(i + 1) % len(p)]]
        if convexPt(t) and noConcavePtInTri(p, i, t):
            return (i, t)

def ears(p):
    p = list(p)
    es = []

    while len(p) >= 3:
        e = ear(p)
        if not e:
            break

        es.append(e[1])
        p.pop(e[0])

    return es

def convexPt(t):
    return area(t) < 0

def noConcavePtInTri(p, ii, t):
    for i in range(len(p)):
        if min((i - ii) % len(p), (ii - i) % len(p)) <= 1:
            continue

        tt = [p[(i - 1) % len(p)], p[i], p[(i + 1) % len(p)]]
        if convexPt(tt):
            continue

        areas = [area([t[0], t[1], p[i]]),
                 area([t[1], t[2], p[i]]),
                 area([t[2], t[0], p[i]])]

        if all(map(lambda x: x <= 0, areas)) or all(map(lambda x: x >= 0, areas)):
            return False

    return True

def area(t):
    return (
        t[0][0] * (t[2][1] - t[1][1]) +
        t[1][0] * (t[0][1] - t[2][1]) +
        t[2][0] * (t[1][1] - t[0][1])
    ) / 2
