/******************** DESCRIPTION ********************//*

Outer_Ring_Customizer_03    14/09/2022

This Scad file is for quick and easy creation of custom "Outter_Rings" for my cryptex design "Combination Safe 00" http://www.thingiverse.com/thing:586169

 I've made this file as simple as possible to use, so you don’t need to be familiar with OpenSCAD to use it, just follow the instructions below

This is the third version of Outer_Ring_Customizer. I have tried to make it as user friendly as possible my making all the setting, plus a few new ones, accessible via the Customizer window.*/ 
                                 
/********* HOW TO USE OUTER RING CUSTOMIZER **********//*

1)  If you're reading this you've already open the Scad file. Well done :)

2)  Open the "Window" menu (above) and select "Customizer".

3)  Inside the "Customizer" window that you have just opened, you will see a number of drop-down menus, with headings like "Input Text"

4a) If you would like to change the numbers on the ring to something different simply open the "Input Text" drop-down menu and replace the number in each text box with whatever you want.

4b) To change the style of the text use options inside the "Text Settings" menu. Inside the "Other Settings" menu you'll find the option to move or rotate the text/image around.  

5)  Alternatively, you can import image files to use in place of numbers and letters. I have included a number of image file you can use however if you wish to use your own, read the section called "ABOUT USING IMPORTED IMAGE FILES" (below).

6)  "Text Settings" and "Other Settings" set the default values used for all ten faces. However, you can override these values by using the "Custom Settings" menus to give each face its own custom style. 
    The "Custom Settings" menus are always active but when the sliders are dragged as far left as possible, they will use the default vales. 

7)  When you've finished your design press the "Render" button F6. Rendering can take a while especially if your importing images. Once the render is complete, save your custom Outter_Ring as a STl file by pressing the "Export as STL" button F7 and choose a name and location for the new .stl file.

8)  You're all done! 
 */
/********* ABOUT USING IMPORTED IMAGE FILES **********//*

Imported images are converted into depth values and embossed or debossed onto the ring. Black pixels have zero depth. White pixels have either positive or negative depth, depending on what value you gave the "Depth" setting.
    
    The image file manipulations listed below can be done with a very basic image editor, such as Microsoft Paint (which will already be installed on your PC)

1)  Images should be a [6:5] ratio (e.g., width=120pixels, hight=100pixels).  This will stop them being squashed or stretched when imported into OpenSCAD. 

2)  I wouldn’t recommend using images much bigger than 120 x 100  as it will have a significant impact on preview & render times.

3)  The background colour of your image should be black so that it's flush with the surface of the ring. If your design is black on a white background, "invert" the colours.

4)  The images need to saved as .png files. OpenSCAD cannot read .JPG or any other image format.

5)  The images being to be used must be saved in the same folder as this scad file in order for the scad file to find them.

6)  To add an image to the ring simply open the "Input Images" menu and type the name of the image you wish to use into one of the text boxes*/

/**************** PUBLICATION NOTES ******************//*

Outer_Ring_Customizer_03 by SavageRodent
Original at: https://www.thingiverse.com/thing:586169
Last updated: 14/09/2022
Published under: the Creative Commons CC - BY 3.0 licence
Licence details here: https://creativecommons.org/licenses/by/3.0/*/


/*[Input Text]*/
//Type the numbers, letters or symbols you want on each of the ring's ten faces.
Text_0 = "0";
Text_1 = "1";
Text_2 = "2";
Text_3 = "3";
Text_4 = "4";
Text_5 = "5";
Text_6 = "6";
Text_7 = "7";
Text_8 = "8";
Text_9 = "9";

/*[Input Images]*/
//Type the name of the image file you want on each face. Images will take priority over text. Image format must be .png rather than .jpg. Images must be saved in the same folder as this scad file. Images should be a [6:5] ratio and shouldn’t be much bigger than 120px x 100px. Images should be white on a black background.
Image_0 = "";
Image_1 = "";
Image_2 = "";
Image_3 = "";
Image_4 = "";
Image_5 = "";
Image_6 = "";
Image_7 = "";
Image_8 = "";
Image_9 = "";

/*[Text Settings]*/  
Font    = "arile";           
Bold    = true;         
Italic  = false;         
Size    = 9;        //[0:.1:15]
  
//Size of space between characters on the same face.       
Space_Between_Charicters = 1;   //[.5:.01:2]         

//Direction of the text flow. Requires two or more charicter on the same face.
Direction_of_Text_Flow = "horizontal";    //[horizontal, vertical]

/*[Other Settings]*/
//relative to the text/image axis rather than its current rotation.
Move_Horizontally  = 0;    //[-1.1:.01:1]        
//relative to the text/image axis rather than its current rotation.
Move_Vertically    = 0;    //[-1.1:.01:1]
Apply_Move_to   = "Text";   //[Text, Images, Text & Images]
Rotate             = 90;    //[0:360]
Apply_Rotate_to = "Text";   //[Text, Images, Text & Images]
//Negative values will be enbossed. Posative values will debossed. 
Depth              = -.8;   //[-1:.1:1] 
Label_Face_Number_in_Prview    = false; 

//abreveared varibles for use in code
appRot = Apply_Rotate_to=="Text" ? 0 : Apply_Rotate_to=="Images" ? 1 : 2;
appMov = Apply_Move_to  =="Text" ? 0 : Apply_Move_to  =="Images" ? 1 : 2;

//>>>>>>>>>>>>>>>>>> CUSTOM SETTINGS <<<<<<<<<<<<<<<<<<


 /*[Custom Settings for Face 0]*/
Font_                       = "default";    
Bold_                       = "default";    //[default, on, off]
Italic_                     = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size_                       = 0;            //[0:.1:15]
Space_Between_Charicters_   = .51;          //[.51:.01:2]       
Direction_of_Text_Flow_  = "default";       //[default, horizontal, vertical]
Move_Horizontally_          = -1.1;         //[-1.1:.01:1]        
Move_Vertically_            = -1.1;         //[-1.1:.01:1]
Rotate_                     = -1;           //[-1:360] 
Depth_                      = -1.1;         //[-1.1:.1:1]

 /*[Custom Settings for Face 1]*/
Font__                       = "default";    
Bold__                       = "default";    //[default, on, off]
Italic__                     = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size__                       = 0;            //[0:.1:15]
Space_Between_Charicters__   = .51;           //[.51:.01:2]       
Direction_of_Text_Flow__  = "default";       //[default, horizontal, vertical]
Move_Horizontally__         = -1.1;         //[-1.1:.01:1]        
Move_Vertically__           = -1.1;         //[-1.1:.01:1]
Rotate__                     = -1;           //[-1:360] 
Depth__                      = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 2]*/
Font___                       = "default";    
Bold___                       = "default";    //[default, on, off]
Italic___                     = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size___                       = 0;            //[0:.1:15]
Space_Between_Charicters___   = .51;           //[.51:.01:2]       
Direction_of_Text_Flow___  = "default";       //[default, horizontal, vertical]
Move_Horizontally___         = -1.1;         //[-1.1:.01:1]        
Move_Vertically___           = -1.1;         //[-1.1:.01:1]
Rotate___                     = -1;           //[-1:360] 
Depth___                      = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 3]*/
Font____                       = "default";    
Bold____                       = "default";    //[default, on, off]
Italic____                     = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size____                       = 0;            //[0:.1:15]
Space_Between_Charicters____   = .51;           //[.51:.01:2]       
Direction_of_Text_Flow____  = "default";       //[default, horizontal, vertical]
Move_Horizontally____         = -1.1;         //[-1.1:.01:1]        
Move_Vertically____           = -1.1;         //[-1.1:.01:1]
Rotate____                     = -1;           //[-1:360] 
Depth____                      = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 4]*/
Font_____                        = "default";    
Bold_____                        = "default";    //[default, on, off]
Italic_____                      = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size_____                        = 0;            //[0:.1:15]
Space_Between_Charicters_____    = .51;           //[.51:.01:2]       
Direction_of_Text_Flow_____   = "default";       //[default, horizontal, vertical]
Move_Horizontally_____          = -1.1;         //[-1.1:.01:1]        
Move_Vertically_____            = -1.1;         //[-1.1:.01:1]
Rotate_____                      = -1;           //[-1:360] 
Depth_____                       = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 5]*/
Font______                         = "default";    
Bold______                         = "default";    //[default, on, off]
Italic______                       = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size______                         = 0;            //[0:.1:15]
Space_Between_Charicters______     = .51;           //[.51:.01:2]       
Direction_of_Text_Flow______    = "default";       //[default, horizontal, vertical]
Move_Horizontally______           = -1.1;         //[-1.1:.01:1]        
Move_Vertically______             = -1.1;         //[-1.1:.01:1]
Rotate______                       = -1;           //[-1:360] 
Depth______                        = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 6]*/
Font_______                          = "default";    
Bold_______                          = "default";    //[default, on, off]
Italic_______                        = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size_______                          = 0;            //[0:.1:15]
Space_Between_Charicters_______      = .51;           //[.51:.01:2]       
Direction_of_Text_Flow_______     = "default";       //[default, horizontal, vertical]
Move_Horizontally_______            = -1.1;         //[-1.1:.01:1]        
Move_Vertically_______              = -1.1;         //[-1.1:.01:1]
Rotate_______                        = -1;           //[-1:360] 
Depth_______                         = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 7]*/
Font________                           = "default";    
Bold________                           = "default";    //[default, on, off]
Italic________                         = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size________                           = 0;            //[0:.1:15]
Space_Between_Charicters________       = .51;           //[.51:.01:2]       
Direction_of_Text_Flow________      = "default";       //[default, horizontal, vertical]
Move_Horizontally________             = -1.1;         //[-1.1:.01:1]        
Move_Vertically________               = -1.1;         //[-1.1:.01:1]
Rotate________                         = -1;           //[-1:360] 
Depth________                          = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 8]*/
Font_________                            = "default";    
Bold_________                            = "default";    //[default, on, off]
Italic_________                          = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size_________                            = 0;            //[0:.1:15]
Space_Between_Charicters_________        = .51;           //[.51:.01:2]       
Direction_of_Text_Flow_________       = "default";       //[default, horizontal, vertical]
Move_Horizontally_________              = -1.1;         //[-1.1:.01:1]        
Move_Vertically_________                = -1.1;         //[-1.1:.01:1]
Rotate_________                          = -1;           //[-1:360] 
Depth_________                           = -1.1;           //[-1.1:.1:1]

 /*[Custom Settings for Face 9]*/
Font__________                             = "default";    
Bold__________                             = "default";    //[default, on, off]
Italic__________                           = "default";    //[default, on, off]
//Sliders draged to the far left will use thir default settings
Size__________                             = 0;            //[0:.1:15]
Space_Between_Charicters__________         = .51;           //[.51:.01:2]       
Direction_of_Text_Flow__________        = "default";       //[default, horizontal, vertical]
Move_Horizontally__________               = -1.1;         //[-1.1:.01:1]        
Move_Vertically__________                 = -1.1;         //[-1.1:.01:1]
Rotate__________                           = -1;           //[-1:360] 
Depth__________                            = -1.1;           //[-1.1:.1:1]

/*Functions to assign ether default or custom settings*/{
function cha(face)= len(imported_images[face])>0 ? 1 : 0;// 0=text 1=image

function fon(in)= (in==undef ||in==""||in=="default") ? (Font==undef ? "arile":Font) : in;

function bol(in)= in=="default" ? (Bold==true ? 1:0) : in=="on" ? 1:0;

function ita(in)= in=="default" ? (Italic==true ? 1:0) : in=="on" ? 1:0;

function siz(in)= in==0 ? Size : in;

function alh(in)= in==-1.1 ? 6*Move_Horizontally : 6*in;

function alv(in)= in==-1.1 ? 6*Move_Vertically   : 6*in;

function rot(in,chaTyp)= in>-1 ? in : (appRot==2 || appRot==chaTyp ? Rotate : 0);

function dep(in)= in==-1.1 ? Depth : in;

function spc(in)= in== .51 ? Space_Between_Charicters : in;

function dir(in)= (in=="default" ? Direction_of_Text_Flow : in)=="horizontal"? "left to right" : "top to bottom";
}

/*Variables containing all values for a given peramitor type*/{ 
imported_images=[   Image_0,//0
                    Image_1,//1
                    Image_2,//2
                    Image_3,//3
                    Image_4,//4
                    Image_5,//5
                    Image_6,//6
                    Image_7,//7
                    Image_8,//8
                    Image_9];//9

txt=[               Text_0,//0
                    Text_1,//1
                    Text_2,//2
                    Text_3,//3
                    Text_4,//4
                    Text_5,//5
                    Text_6,//6
                    Text_7,//7
                    Text_8,//8
                    Text_9];//9

cha=[   cha(0),//0
        cha(1),//1
        cha(2),//2
        cha(3),//3
        cha(4),//4
        cha(5),//5
        cha(6),//6
        cha(7),//7
        cha(8),//8
        cha(9)];//9

fon=[   fon(Font_),//0
        fon(Font__),//1
        fon(Font___),//2
        fon(Font____),//3
        fon(Font_____),//4
        fon(Font______),//5
        fon(Font_______),//6
        fon(Font________),//7
        fon(Font_________),//8
        fon(Font__________)];//9

bol=[   bol(Bold_),//0
        bol(Bold__),//1
        bol(Bold___),//2
        bol(Bold____),//3
        bol(Bold_____),//4
        bol(Bold______),//5
        bol(Bold_______),//6
        bol(Bold________),//7
        bol(Bold_________),//8
        bol(Bold__________)];//9

ita=[   ita(Italic_),//0
        ita(Italic__),//1
        ita(Italic___),//2
        ita(Italic____),//3
        ita(Italic_____),//4
        ita(Italic______),//5
        ita(Italic_______),//6
        ita(Italic________),//7
        ita(Italic_________),//8
        ita(Italic__________)];//9

siz=[   siz(Size_),//0
        siz(Size__),//1
        siz(Size___),//2
        siz(Size____),//3
        siz(Size_____),//4
        siz(Size______),//5
        siz(Size_______),//6
        siz(Size________),//7
        siz(Size_________),//8
        siz(Size__________)];//9

smo=[];   //removed smooth as it seemed unnessasery

alh=[   alh(Move_Horizontally_),//0
        alh(Move_Horizontally__),//1
        alh(Move_Horizontally___),//2
        alh(Move_Horizontally____),//3
        alh(Move_Horizontally_____),//4
        alh(Move_Horizontally______),//5
        alh(Move_Horizontally_______),//6
        alh(Move_Horizontally________),//7
        alh(Move_Horizontally_________),//8
        alh(Move_Horizontally__________)];//9

alv=[   alv(Move_Vertically_),//0
        alv(Move_Vertically__),//1
        alv(Move_Vertically___),//2
        alv(Move_Vertically____),//3
        alv(Move_Vertically_____),//4
        alv(Move_Vertically______),//5
        alv(Move_Vertically_______),//6
        alv(Move_Vertically________),//7
        alv(Move_Vertically_________),//8
        alv(Move_Vertically__________)];//9

rot=[   rot(Rotate_,cha[0]),//0
        rot(Rotate__,cha[1]),//1
        rot(Rotate___,cha[2]),//2
        rot(Rotate____,cha[3]),//3
        rot(Rotate_____,cha[4]),//4
        rot(Rotate______,cha[5]),//5
        rot(Rotate_______,cha[6]),//6
        rot(Rotate________,cha[7]),//7
        rot(Rotate_________,cha[8]),//8
        rot(Rotate__________,cha[9])];//9

dep=[   dep(Depth_),//0
        dep(Depth__),//1
        dep(Depth___),//2
        dep(Depth____),//3
        dep(Depth_____),//4
        dep(Depth______),//5
        dep(Depth_______),//6
        dep(Depth________),//7
        dep(Depth_________),//8
        dep(Depth__________)];//9

spc=[   spc(Space_Between_Charicters_),//0
        spc(Space_Between_Charicters__),//1
        spc(Space_Between_Charicters___),//2
        spc(Space_Between_Charicters____),//3
        spc(Space_Between_Charicters_____),//4
        spc(Space_Between_Charicters______),//5
        spc(Space_Between_Charicters_______),//6
        spc(Space_Between_Charicters________),//7
        spc(Space_Between_Charicters_________),//8
        spc(Space_Between_Charicters__________)];//9

dir=[   dir(Direction_of_Text_Flow_),//0
        dir(Direction_of_Text_Flow__),//1
        dir(Direction_of_Text_Flow___),//2
        dir(Direction_of_Text_Flow____),//3
        dir(Direction_of_Text_Flow_____),//4
        dir(Direction_of_Text_Flow______),//5
        dir(Direction_of_Text_Flow_______),//6
        dir(Direction_of_Text_Flow________),//7
        dir(Direction_of_Text_Flow_________),//8
        dir(Direction_of_Text_Flow__________)];//9
}


/******************** THE CODE!*********************/{/*
It should't be nessasery to change any of the settings below this point*/


//imported_images_PNG=[for(i=[0:9]) str(imported_images[i], ".PNG")]; // adds ".PNG" to name so u dont have to

//find number of characters in file name
function name_len(a)= 
len(imported_images[a]);

// Add file extention ".png" to name if user has not done so alredy
imported_images_PNG=[for(i=[0:9])
    //check if file name includes ".png"
    (imported_images[i]=="")
    ||
    (imported_images[i][name_len(i) -4]=="." && 
     imported_images[i][name_len(i) -3]=="p" &&
     imported_images[i][name_len(i) -2]=="n" &&
     imported_images[i][name_len(i) -1]=="g") == true
    ||
    (imported_images[i][name_len(i) -4]=="." && 
     imported_images[i][name_len(i) -3]=="P" &&
     imported_images[i][name_len(i) -2]=="N" &&
     imported_images[i][name_len(i) -1]=="G") == true 
                                    //if file extention is included do this,      
                                    ? imported_images[i] : 
                                    //if file extention is NOT included do this,
                                    str(imported_images[i],".png")];


/*
if(Show_List==true){  //show or do not show list of images in console   
    include<icon_list.scad> //include list of images
    for(i=[1:69]){
        echo(str("  icon ",i," = ",icon[i],"  "));
    }
}
*/

module Ring_Section(){// 1/10 of the ring section
//********** make shape 3D and dupicate to make one section**********
color("gold")
for(mx=[0:1],my=[0:1]) mirror([0,0,mx])mirror([my,0,0])//mirror X & Y
difference() {//subtract cube from 3d shap to create chanfer edge
linear_extrude(height = 5){// extrude Basic 2d Shape +1 as overlap

//********** 2D Shape start **********
union(){  
difference() {//subtract large circal from 2d shape
union() {//combine basic shape to small circal
polygon(points=[[0,20.92],[0,23.50],[6,23.5],[6,23.15],[7.55,23.15],[7.1,20.92]]);//create Basic 2d Shape
translate(v = [6, 23, 0]) {// position fillit circal
circle(d=1,$fn=40);//add circle to make small fillited edge
}
}
translate(v = [7.64, 23.5, 0]) {// position large circal
circle(d=2.43,$fn=60);//large circle to be cut
}
}//********** 2D Shape end **********
}
}

translate(v = [-2, 20.5, 4]) {// move chanfer tool
rotate(a= [45,0,0]){// rotate chanfer tool
cube(size = [10,2,2]);//create cube as chanfer tool
}
}
}
}

//Ring_Section();

module images_extrude(i,depth){
translate([0,0,-.01])
    resize([12, 10, depth])//make image fit ring section + set depth
        surface(file = imported_images_PNG[i], center = true);
}
module text_extrude(i,depth){
translate([(dir[i]=="top to bottom" ? siz[i]/2 : 0), 0, -.01])
    linear_extrude (depth+.001) // if depth has a negative value make positive else leave
        //rotate([0,0,90])          
            text(txt[i], 
            font        = str(fon[i],": ",//font name
            (bol[i])==1 ? "bold: " : " ", //bold or not
            (ita[i])==1 ? "italic" : " "),//italic or not
            size        = siz[i],  
            valign      = "center", 
            halign      = "center",
            spacing     = spc[i],
            direction   = dir[i]);
}
              

module generate_text_and_images(i,depth){
color("RoyalBlue")
    rotate([0,rot[i],0])//rotation of text relative to ring segment
        translate([0, 23.5,0])//set depth
            translate([ -alh[i], 0, alv[i]])//align text on ring segment 
                rotate([90,0,180]){//make text parallel with face of ring segment
                            mirror((dep[i])<0 ? [0,0,1]:[0,0,0])// if depth is negative flip round
                    if(cha[i]==1){  
                                images_extrude(i,depth);
                    }
                    else
                    text_extrude(i,depth);
                }
}

module combine_ring_and_characters() {// 
for (i=[0:9]) {         //
depth=((dep[i])<0 ? (dep[i]+.01)*-1 : (dep[i]+.01));
rotate([0,0,i *36]){    //postion ring section
if (dep[i]<0){   //generate ring section with enbossed text
difference(){Ring_Section(); generate_text_and_images(i,depth);}
}
    else//generate ring section with debossed text
    if (dep[i]>0){
    Ring_Section();         
    color("SeaGreen")
        if(alh[i]==0 && alv[i]==0 && rot[i]==0){  //if the image object has not moved, dont trim it 
        generate_text_and_images(i,depth);
        }
            else// if the image object has moved, trim the edges
            intersection(){
            cube([11.99,70,9.99],true);//trim shape
            generate_text_and_images(i,depth);
            }}
else               //if txt has no depth just ggenerate the ring section
Ring_Section();
}
}
}

combine_ring_and_characters();

//show face numbers of faces
if($preview==true && Label_Face_Number_in_Prview==true)
    for(i=[0:9]){
    translate([0,0,-5])
        #linear_extrude(.01)
            rotate([0,0,36*i])
                translate([0,29,0])
                    rotate([0,0,180])
                        text(str(i), size=8, valign="center",halign="center", font="Arial:bold");
    }
 /* end of THE CODE */}
