/************** Publication Notes ***************/{/*
Customizable Rack by SavageRodent
Original at: https://www.thingiverse.com/thing:2224399
Last updated: 17/02/2018
Published under: the Creative Commons CC - BY 3.0 licence
Licence details here: https://creativecommons.org/licenses/by/3.0/*/}

/******************** DESCRIPTION ********************/{
/*This Scad file is for quick and easy creation of custom "Outter_Rings" for my cryptex design "Combination Safe 00" http://www.thingiverse.com/thing:586169

 I've made this file as simple as possible to use, so you don’t need to be familiar with OpenSCAD to use it. Just follow the directions in the "ALL SETTINGS" section and ignore the rest of the code.
 
 To preview any changes you make press F5.
 When you've finished your design press F6 to render it, once the render is complete, save your custom Outter_Ring as a STl file by press the "Export as STL" button, on the tool bar (above). */}

/****************** ALL SETTINGS ******************/{
{/*Useful tips: 
1) You can minimize and maximize bracketed section of code by clicking the +/- butons on the left hadnd side. You might find it helpful to use this to hide sections of text/code your finshed with or dont intend to use. 
2) I have tried to format the page layout so as to make it easy to read. You might need to make the "Editor" window (this text window) wider so as not to get unwanted text wrapping that will confuse the layout (see screenshots) ( */}

/****************** INSERT TEXT *******************/{

//  These are the characters that will apear on the ring. Replace each of the ten letters (A-J) within the quotation marks with numbers, letters or sybols of your choice.

txt = [ //
"A",    //0  
"B",    //1
"C",    //2
"D",    //3
"E",    //4
"F",    //5
"G",    //6
"H",    //7
"I",    //8
"J"];   //9

/* end of INSERT TEXT */}

/***************** IMPORT IMAGES ******************/{
/* Important Notes! */{
/*
1) The image file manipulations mentioned below can be done with a very basic image editor, such as Microsoft Paint (which will alredy be installed on your PC)

2) The images need to saved as .PNG not .JPG or any other format.

3) Images should be a [6:5] ratio (eg wideth=120pixels, hight=100pixels).  This will stop them being squashed or strechend when imported into openscad. I would'nt recomend using images much bigger than 120 x 100  as it will impact  preview & render times.

4) Imported images are converted into depth values and embossed or debossed onto the ring. Black = 0 depth. White = +x or -x depth, depending on what value you gave the "depth" varible.
 
5) The images being used must be saved in the same folder as the scade file using them.
 
end of Important Notes */}


//Import images:
//Replace each of the names inside "imported_images" (below) with the name of the .PNG image you wish to use. You can use your own images or select from the list.

show_list=1;       // [ 0=no, 1=yes ] shows list of ready made images in the consol. You need to do a preview (press F5) to generate the list.

imported_images=[
"hand print",   // 0    
"baby 2",       // 1
"key",          // 2
"bio hazard",   // 3
"jump",         // 4
"speaker",      // 5
"thingiverse",  // 6
"palm tree",    // 7
"atom",         // 8
"dragonfly"];   // 9  

/* end of IMPORT IMAGE*/}
/* DEFAULT character settings. 
 These valus will be used for ALL characters unless replased in the custom character settings (below).*/

cha = 0;         // default character:  use font or image [0=font, 1=image]
fon = "arile";   // default font:       name of a font   
bol = 1;         // default bold:       make font bold?    [0=no, 1-yes]
ita = 0;         // default italic:     make font italic?  [0=no, 1-yes]
siz = 9;         // default size:       size of text / characters
alh = 0;         // default align_h:    move character horazontaly
alv = 0;         // default align_v:    move character verticly
rot = 0;         // default rotate:     rotate character 
dep = -.8;       // default depth:      negative values will enbossed characters. posative values will debossed. 
smo = 40;        // default smothness:  adds more detail making cuves smoother 
spc = 1;         // default spaceing:   size of spacing between characters one same face
dir = 0;         // default direction:  [0=left-to-right, 1=right-to-left, 3=top-to-bottom 4=bottom-to-top]



// CUSTOM character settings. 
// This section enables you to give custom settings to indavidule characters. eg have a mixture of text and images or text characters each with a different font. The variable "all_set" (below) is a matrix holding all the settings for all the characters. The coloms ("c" numbers) relate to setting eg font, size etc (see feference). The rows ("r" numbers) relate to one of the ten characters eg r0=A, r1=B etc. At the moment all the values are using the "DEFAULT character settings" (that you set above). To set a custom value for any setting simply replace or supliment the default value with one of your chice.

/* settings reference
c0 = character:         use font or image [0=font, 1=image]            
c1 = text character:    numbers, letters or sybols that will apear on the ring
c2 = font:              name of a font
c3 = bold:              make font bold?    [0=no, 1-yes]
c4 = italic:            make font italic?  [0=no, 1-yes]
c5 = size:              size of text / characters
c6 = smothness:         adds more detail making cuves smoother 
c7 = align_h:           move character horazontaly
c8 = align_v:           move character verticly
c9 = rotate:            rotate character
c10 = depth:            amount to which characters are enbossed or debossed.
c11 = spaceing:         size of spacing between characters one same face
c12 = direction:        [0=left-to-right, 1=right-to-left, 3=top-to-bottom 4=bottom-to-top]*/

all_set=[ 
//c0,     c1,  c2,  c3,  c4,  c5,  c6,  c7,  c8,  c9, c10, c11, c12],  
[cha, txt[0], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r0
[cha, txt[1], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r1
[cha, txt[2], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r2
[cha, txt[3], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r3
[cha, txt[4], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r4
[cha, txt[5], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r5
[cha, txt[6], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r6
[cha, txt[7], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r7
[cha, txt[8], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  // r8
[cha, txt[9], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir]]; // r9




/* end of ALL SETTINGS */}
/******************** THE CODE!*********************/{/*
It should't be nessasery to change any of the settings below this point*/


imported_images_PNG=[for(i=[0:9]) str(imported_images[i], ".PNG")]; // adds ".PNG" to name so u dont have to

include<icon_list.scad> //include list of images

if(show_list==1){  //show or do not show list of images in console   
for(i=[1:69]){
echo(str("  icon ",i," = ",icon[i],"  "));
}
}


module Ring_Section(){// 1/10 of the ring section
//********** make shape 3D and dupicate to make one section**********
color("gold")
for(mx=[0:1],my=[0:1]) mirror([0,0,mx])mirror([my,0,0])//mirror X & Y
difference() {//subtract cube from 3d shap to create chanfer edge
linear_extrude(height = 5){// extrude Basic 2d Shape +1 as overlap

//********** 2D Shape start **********
union(){  
difference() {//subtract large circal from 2d shape
union() {//combine basic shape to small circal
polygon(points=[[0,20.92],[0,23.50],[6,23.5],[6,23.15],[7.55,23.15],[7.1,20.92]]);//create Basic 2d Shape
translate(v = [6, 23, 0]) {// position fillit circal
circle(d=1,$fn=40);//add circle to make small fillited edge
}
}
translate(v = [7.64, 23.5, 0]) {// position large circal
circle(d=2.43,$fn=60);//large circle to be cut
}
}//********** 2D Shape end **********
}
}

translate(v = [-2, 20.5, 4]) {// move chanfer tool
rotate(a= [45,0,0]){// rotate chanfer tool
cube(size = [10,2,2]);//create cube as chanfer tool
}
}
}
}

//Ring_Section();

/*0,       1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12],  
cha, [txt[0], fon, bol, ita, siz, smo, alh, alv, rot, dep, spc, dir],  */

module images_extrude(i,depth){
//translate([0,23.49,0])
//mirror([0,1,0])
 //rotate([-90,0,0])
  resize([12, 10, depth])//make image fit ring section + set depth
  surface(file = imported_images_PNG[i], center = true);
}

module text_extrude(i,depth){
linear_extrude (depth+.01) {// if depth has a negative value make positive else leave
text(txt[i], 
font        = str(all_set[i][2],": ",//font name
(all_set[i][3])==1 ? "bold: " : " ", //bold or not
(all_set[i][4])==1 ? "italic" : " "),//italic or not
size        = all_set[i][5],  
valign      = "center", 
halign      = "center",
$fn         = all_set[i][6],
spacing     = all_set[i][11],
direction   = all_set[i][12]
);
}
}

                
module generate_text_and_images(i,depth){
color("RoyalBlue")
rotate([0,all_set[i][9],0]){//rotation of text relative to ring segment
translate((all_set[i][10]<0) ?  [0, 23.5-depth,0] : [0, 23.5,0]){//set depth
translate([ -all_set[i][7], 0, all_set[i][8]]){//align text on ring segment 
rotate([90,0,180]){//make text parallel with face of ring segment   
if(all_set[i][0]==1){  
translate((all_set[i][10])<0 ? [0,0,1] : [0,0,-.01]){//
mirror((all_set[i][10])<0 ? [0,0,1]:[0,0,0]){// if depth is negative flip round
images_extrude(i,depth);}
}
}
else
text_extrude(i,depth);
}
}
}
}
}




//enboss_depth=23.5-all_set[i][8];

module combine_ring_and_characters() {// 
for (i=[0:9]) {         //
depth=((all_set[i][10])<0 ? (all_set[i][10]+.01)*-1 : (all_set[i][10]+.01));
rotate([0,0,i *36]){    //postion ring section
if (all_set[i][10]<0){   //generate ring section with enbossed text
difference(){Ring_Section(); generate_text_and_images(i,depth);}
}
    else//generate ring section with debossed text
    if (all_set[i][10]>0){
    Ring_Section();         
    color("SeaGreen")
        if(all_set[i][7]==0 && all_set[i][8]==0 && all_set[i][9]==0){  //if the image object has not moved, dont trim it 
        generate_text_and_images(i,depth);
        }
            else// if the image object has moved, trim the edges
            intersection(){
            cube([11.99,70,9.99],true);//trim shape
            generate_text_and_images(i,depth);
            }}
else               //if txt has no depth just ggenerate the ring section
Ring_Section();
}
}
}

combine_ring_and_characters();


 /* end of THE CODE */}
