//Spool diameter.
spoolDiam=240; 

//Spool center hole diameter.
SpoolCenterHoleDiam=51;

//Frame thickness
frameThickness=8.4;

krepaHeight=120;

//Frame upper part height.
frameHeight=60;

//Thickness of the holder
holderThickness=10; 

//Diameter of the pin, or the hole. 8,5mm for 8mm bolt
pinWidth=8.5;

//-----------
angle=66;
spoolCenterX=cos(angle)*((spoolDiam/2)+(SpoolCenterHoleDiam/2))+frameThickness; 
spoolCenterY=sin(angle)*((spoolDiam/2)+(SpoolCenterHoleDiam/2))+frameHeight;    

translate([0,0,0]) %spoolShape();
holder1();
translate([60,143,0]) rounding(pinWidth,diamW);


module spoolShape(){
    difference(){
            translate([spoolCenterX-6,spoolCenterY-SpoolCenterHoleDiam/2-35,0])cylinder(1,spoolDiam/2,spoolDiam/2);
            translate([spoolCenterX-6,spoolCenterY-SpoolCenterHoleDiam/2-35,-1])cylinder(3,SpoolCenterHoleDiam/2,SpoolCenterHoleDiam/2);
    }
}


module holder1(){ 
    difference(){
    union(){
    difference(){
       translate([0,-0.01,0]) linear_extrude(height=holderThickness, convexity=10)polygon(points=[[0,-5], [10+frameThickness+9,0],[10+frameThickness+15+42,krepaHeight], [10+frameThickness+16+42,krepaHeight+15], [10+frameThickness+16+43-25,krepaHeight+15], [0,5]      ]);
      hull(){
                 translate([62,122,-1])cylinder(h=holderThickness+1,d=pinWidth,$fn=32);
                 translate([62,127+20,-1])cylinder(h=holderThickness+2,d=pinWidth,$fn=32);}    
    
        
    }

difference(){
translate([0,-((frameHeight-28)+17),0]) cube([10+frameThickness+15,(frameHeight-25)+17,holderThickness]);
translate([10,-((frameHeight-28)+17.1),-1]) cube([frameThickness,frameHeight-20,holderThickness+2]);  
    translate([15,-35,5]) rotate([0,90,0]) cylinder(h=50,d=3.1,$fn=32);
   translate([18,-35,5]) rotate([0,90,0]) cylinder(h=3,d=7.0,$fn=6);
    }}

  for (i=[1:7:35]){
translate([14+i,15+i*0.6+i+i,0]) rotate([0,0,0]) block();} 
 


}

translate([23.2,0,0]) cube([10,15,holderThickness]);

}


module block(){
translate([0,0,-2]) rotate([0,0,-23]) cube([9,9,holderThickness+4]);}

module a_triangle(tan_angle, a_len, depth)
{
    linear_extrude(height=depth)
    {
        polygon(points=[[0,0],[a_len,0],[0,tan(tan_angle) * a_len]], paths=[[0,1,2]]);
    }
}
