use <Getriebe.scad>

//original gear measures 9mm height and is horizontally symmetrical, 
//  but we need to print this flat on one side.
gearHeight=8;
teeth = 51;

outerRingCutHeight=3.25;
outerRingDiameter=28;
// adjustment for ring to be a multple of 0.4 for printing
innerRingDiameter=20.5 + 0.2;
innerRingCutHeight=1;

// measurement of splined shaft 14.5mm
//14.5 too tight
//14.5 + 0.6 too loose
centerHole = 14.5 + 0.4;

$fn = 96;

difference(){
    stirnrad (0.666665982, teeth, gearHeight, centerHole, eingriffswinkel=20, schraegungswinkel=0, optimiert=false);

    translate([0,0,gearHeight-innerRingCutHeight/2])
        cylinder (d=innerRingDiameter, h=innerRingCutHeight, center=true);

    translate([0,0,gearHeight-outerRingCutHeight/2])
        difference(){
            cylinder(d=outerRingDiameter, h=outerRingCutHeight, center=true);
            cylinder(d=innerRingDiameter, h=outerRingCutHeight, center=true);
        }
}
