// Custom Cutters for Polymer Clay, Cookies, etc.
// Set filename to import an svg file with the desired outline.

// Size of overall shape should be determined in Inkscape or whichever vector art app you use.
// If you resize in a slicer, the wall dimensions will change

// Built-in tapering at cutting edge for polymer clay.
// Can remove taper by setting taper=false

/////ADJUSTABLE PARAMETERS/////
//ALL SIZES IN MILLIMETERS

filename = "./star.svg";

height = 15; //total height of cutter
wall_thickness = 1; //thickness of main wall of cutter
cutting_width = .3; //wall width at the pointy end
taper_height = 3; //height from top where tapering starts
base_height = 2; //height of base where you press down
base_width = 5; //width of base where you press down

taper = true; //set to false to remove

//////////LEAVE THIS PART//////////
angle = atan2(wall_thickness-cutting_width,taper_height);

module chamfer_extrude(height = 2, angle = 10, center = false) {
    translate([ 0, 
                0, 
                (center == false) ? (height - 0.001) :
                                    (height - 0.002) / 2 ]) {
        minkowski() {
            // convert 2D path to very thin 3D extrusion
            linear_extrude(height = 0.001) {
                children();
            }
            // generate $fn-sided pyramid with apex at origin,
            // rotated "point-up" along the y-axis
            rotate(270) {
                rotate_extrude() {
                    polygon([
                        [ 0,                    0.001 - height  ],
                        [ height * tan(angle),  0.001 - height  ],
                        [ 0,                    0               ]
                    ]);
                }
            }
        }
    }
}

module cutter(angle) {
  union() {
    //outside shell
    difference() {
      union() {
        translate([0,0,height-taper_height])
        chamfer_extrude(height=taper_height, angle=angle)
          offset(r=cutting_width)
            import(file = filename);
        linear_extrude(height = height-taper_height)
          offset(r=wall_thickness)
            import(file = filename);
      };
      linear_extrude(height = height)
        import(file = filename);
    };
    difference() {
      linear_extrude(height = base_height)
        offset(r=base_width)
          import(file = filename);
      linear_extrude(height = base_height)
        import(file = filename);
    };
  };
}
if (taper == true) cutter(angle=angle); else cutter(angle=.1);