/*[Stackable square holder table 1]*/
//inner tube width(mm)
tube_size_1=12.0;
wall_thickness=2.0;
cover_thickness=0.0;
//matrix dimension
num=11;

table_thickness=15.0;
table_height=50.0;//>radius1+table_thickness


//pins
ipin=1; //1:on other:off
length=5.0;
gap=0.2;


/* [Hidden] */
eps= 0.01;
$fn=180;
tube_size=tube_size_1+2*wall_thickness;
//matrix row
num_row=num;
num_col=num;
//arc
L=num*tube_size;
H=table_thickness;
radius1=((num_row-2)*(tube_size_1+wall_thickness)-wall_thickness)*0.5;
radius=radius1;

module cube1(xu,yu,xd,yd,z){
hull(){
translate([0.5*(xd-xu),0.5*(yd-yu),z-0.001])
cube([xu,yu,0.001]);
    
cube([xd,yd,0.001]);    
}
}


module tube(height){
difference(){
cube([tube_size,tube_size,height]);
translate([wall_thickness,wall_thickness,cover_thickness-eps])
cube([tube_size-2*wall_thickness,tube_size-2*wall_thickness,height+2*eps]);
}
}

module pin(height){
translate([0,0,table_height-wall_thickness-eps])   
difference(){    
difference(){    
union(){    
translate([wall_thickness+gap,wall_thickness+gap,0])
cube([tube_size-2*wall_thickness-2*gap,tube_size-2*wall_thickness-2*gap,length+wall_thickness+eps]);
translate([0,0,-wall_thickness])    
cube([tube_size,tube_size,2*wall_thickness]);
}
translate([wall_thickness+gap,wall_thickness+gap,0])
translate([wall_thickness-gap,wall_thickness-gap,-eps])
cube([tube_size-4*wall_thickness,tube_size-4*wall_thickness,length+wall_thickness+3*eps]);
}

translate([wall_thickness,wall_thickness,-wall_thickness-eps])
cube1(tube_size-4*wall_thickness,tube_size-4*wall_thickness,tube_size-2*wall_thickness,tube_size-2*wall_thickness,wall_thickness+2*eps);

}
}






difference(){

union(){
spacing=tube_size-wall_thickness;
for(j=[1:num_row]){
for(i=[1:num_col]){
height1=table_thickness;
height2=table_height;
  
  
if(j==1){    
translate([(i-1)*spacing,(j-1)*spacing,0])
tube(height2);
}
else if(j==num_row){
translate([(i-1)*spacing,(j-1)*spacing,0])
tube(height2);
}
else if(i==1){
translate([(i-1)*spacing,(j-1)*spacing,0])
tube(height2);
}  
else if(i==num_col){
translate([(i-1)*spacing,(j-1)*spacing,0])
tube(height2);
}    
else {
translate([(i-1)*spacing,(j-1)*spacing,0])
tube(height1);
}
if(ipin==1){

if(j==1 && i==1){
translate([(i-1)*spacing,(j-1)*spacing,0])  
 pin(); 
}  
 else if(j==1 && i==num_col){   
translate([(i-1)*spacing,(j-1)*spacing,0])  
 pin();}
 else if(i==1 && j==num_row){  
translate([(i-1)*spacing,(j-1)*spacing,0])  
 pin();}
 else if(j==num_row && i==num_col){
 translate([(i-1)*spacing,(j-1)*spacing,0])  
 pin();  }
     
}
}
}
}

difference(){
union(){
hull(){
translate([(num_col*(tube_size_1+wall_thickness)+wall_thickness)/2,-eps,table_height])
    
rotate([-90,0,0])
cylinder(num_row*(tube_size_1+2*wall_thickness),radius,radius);
    
translate([(num_col*(tube_size_1+wall_thickness)+wall_thickness)/2,-eps,table_thickness+radius])rotate([-90,0,0])
cylinder(num_row*(tube_size_1+2*wall_thickness),radius,radius);}    
hull(){    
translate([-eps,(num_row*(tube_size_1+wall_thickness)+wall_thickness)/2,table_height])
rotate([0,90,0])
cylinder(num_col*(tube_size_1+2*wall_thickness),radius,radius);
translate([-eps,(num_row*(tube_size_1+wall_thickness)+wall_thickness)/2,table_thickness+radius])
rotate([0,90,0])
cylinder(num_col*(tube_size_1+2*wall_thickness),radius,radius);    
}    
}
translate([-wall_thickness,-wall_thickness,0])
cube([L,L,H]);
}
}


