// Spodná časť boxu s plastovými stĺpikmi
innerX = 100;
innerY = 150;
innerZ = 25;

wall = 3;
floor = 3;
clearance = 0.2;

outerX = innerX + 2*wall;
outerY = innerY + 2*wall;
outerZ_base = floor + innerZ + wall; // výška spodnej časti

screw_d = 3;      // priemer otvoru pre M3
boss_d = 7;       // priemer plastového stĺpika
boss_h = innerZ;  // výška stĺpika (po horný okraj dutiny)

module base() {
    difference() {
        // vonkajší obal spodnej časti
        cube([outerX, outerY, outerZ_base], center=false);

        // dutina
        translate([wall, wall, floor])
            cube([innerX, innerY, innerZ + wall + 0.01], center=false);
    }

    // stĺpiky v rohoch
    for (x=[wall+5, outerX-wall-5])
        for (y=[wall+5, outerY-wall-5])
            translate([x, y, floor])
                difference() {
                    cylinder(d=boss_d, h=boss_h, $fn=40);
                    cylinder(d=screw_d, h=boss_h+1, $fn=40);
                }
}

base();
