// Vrchná časť boxu s countersink otvormi a tromi vystúpenými nápismi

innerX = 100;
innerY = 150;
innerZ = 25;

wall = 3;
lidTop = 1.5;
lidOverlap = 1.5;
clearance = 0.2;

outerX = innerX + 2*wall;
outerY = innerY + 2*wall;
outerZ_lid = lidTop + wall;

fitX = innerX + clearance;
fitY = innerY + clearance;
fitZ = lidOverlap;

screw_d = 3;
head_d = 6;
head_h = 1;

module lid() {
    union() {
        // základný tvar veka s otvormi
        difference() {
            cube([outerX, outerY, outerZ_lid], center=false);

            // vnútorný výrez
            translate([wall, wall, wall])
                cube([innerX, innerY, lidTop + 0.01], center=false);

            // skrutkové otvory + zápustky
            for (x=[wall+5, outerX-wall-5])
                for (y=[wall+5, outerY-wall-5]) {
                    translate([x, y, -1])
                        cylinder(d=screw_d, h=outerZ_lid+2, $fn=40);

                    translate([x, y, outerZ_lid-head_h])
                        cylinder(d=head_d, h=head_h+0.5, $fn=40);
                }
        }

        // drážka pre zapadnutie spodného dielu
        translate([wall - clearance/2, wall - clearance/2, -fitZ])
            cube([fitX, fitY, fitZ], center=false);

        // --- Vystúpené nápisy (emboss) ---
        // Horný text
        translate([outerX/2-15, outerY/2, outerZ_lid-1.5])   // tesne pod povrch
            rotate([0,0,90])
                linear_extrude(height=1)
                    text("Battery for Yeasu FT-818nd", size=8, halign="center", valign="center");

        // Stredný text
        translate([outerX/2+10, outerY/2, outerZ_lid-1.5])
            rotate([0,0,90])
                linear_extrude(height=1)
                    text("4xLi-Ion Cell Westinghouse 21700, 16.8V", size=5, halign="center", valign="center");

        // Dolný text
        translate([outerX/2+30, outerY/2, outerZ_lid-1.5])
            rotate([0,0,90])
                linear_extrude(height=1)
                    text("Made by OM1CC", size=5, halign="center", valign="center");
    }
}

lid();
