gap = 0.3;
g = gap/2;
thickness = 1.5;
small_bottle_r = 13.2;
small_bottle_ir = 11.4;
small_bottle_h = 9.3;
small_bottle_wedge_h = 5.5;
small_bottle_wedge_t = 2.0;

pump_bottle_r = 15;
pump_bottle_ir = 12.75;
pump_bottle_h = 14;
threads_h = 1.2;
//space between bottles
neck_h = 5;

module adapter(){
    difference()
    {
        outer_body();
        inner_body();
    }
    
    retention_bumps();
}

//outer body of adapter
module outer_body(){
    fn = $preview?64:128;
    t = thickness;
    sb_r = small_bottle_r;
    sb_h = small_bottle_h;
    sb_ir = small_bottle_ir;
    pb_ir = pump_bottle_ir;
    pb_r = pump_bottle_r;
    pb_h = pump_bottle_h;
    t_h = threads_h;
    n_h = neck_h;
    
    path = [
        [0, 0],
        [sb_r+t, 0],
        [sb_r+t, sb_h],
        [pb_r+t_h+t, sb_h+n_h],
        [pb_r+t_h+t, sb_h+n_h+pb_h],
        [0, sb_h+n_h+pb_h],
    ];
    
    rotate_extrude(angle=360, $fn=fn)
        polygon(path);
    
    //alignment tab, also adds wall thickness
    sbw_h = small_bottle_wedge_h;
    sbw_t = small_bottle_wedge_t;
    
    intersection()
    {
        cylinder(r=pb_r+t, h=sb_h+n_h, $fn=fn);
        
        translate([pb_r+t, -5, 0])
        rotate([0, 0, 90])
            cube([10, 2*(pb_r+t), sb_h+n_h]);
    }
}

//inner body of adapter
module inner_body(){
    fn = $preview?64:128;
    sb_r = small_bottle_r;
    sb_h = small_bottle_h;
    sb_ir = small_bottle_ir;
    pb_ir = pump_bottle_ir;
    pb_r = pump_bottle_r;
    pb_h = pump_bottle_h;
    t_h = threads_h;
    n_h = neck_h;
    path = [
        [0, -1],
        //hollow for small bottle
        [sb_r+g, -1],
        [sb_r+g, sb_h],
        //neck between bottles
        [sb_ir, sb_h+n_h/2],
        //add small drip lip
        [sb_ir, sb_h+n_h+2],
        [pb_ir-g, sb_h+n_h],
        //hollow for pump bottle
        [pb_r+g, sb_h+n_h],
        [pb_r+g, sb_h+n_h+2.5],
        [pb_r+t_h+g, sb_h+n_h+2.5],
        [pb_r+t_h+g, sb_h+n_h+pb_h+1],
        [0, sb_h+n_h+pb_h+1],
    ];
    
    //translate([50, 0, 0])
    rotate_extrude(angle=360, $fn=fn)
        polygon(path);
    
    //add wedges to small bottle hollow
    sbw_h = small_bottle_wedge_h;
    sbw_t = small_bottle_wedge_t;
    path_wedge = [
        [0.75*sbw_h, -1],
        [1.5, sbw_h],
        [-1.5, sbw_h],
        [-0.75*sbw_h, -1],
    ];
    
    intersection()
    {
        translate([0, 0, -1])
        cylinder(r=sb_r+sbw_t, h=sbw_h+1, $fn=fn);
        
        translate([-sb_r-sbw_t, 0, 0])
        rotate([90, 0, 90])
        linear_extrude(2*(sb_r+sbw_t))
            polygon(path_wedge);
    }
}

module retention_bumps(){
    sb_r = small_bottle_r;
    sb_h = small_bottle_h;
    r = 1.0;
    fn = $preview?16:32;
    
    translate([0, sb_r+r/2, sb_h-6.5-r/2])
        sphere(r=r, $fn=fn);
    translate([0, -sb_r-r/2, sb_h-6.5-r/2])
        sphere(r=r, $fn=fn);
}


adapter();