number_of_sections=7;//[1:7]

inside_diameter = 26;//[16:80]

section_height_1=39;//[19:100]
section_height_2=36;//[19:100]
section_height_3=33;//[19:100]
section_height_4=30;//[19:100]
section_height_5=27;//[19:100]
section_height_6=24;//[19:100]
section_height_7=21;//[19:100]

o_ring_groove = "no";//[yes,no]

n=[
section_height_2,
section_height_3,
section_height_4,
section_height_5,
section_height_6,
section_height_7];

rotate([0,0,-30])
translate([2*inside_diameter+10, 0]) 
cap(inside_diameter);

base(section_height_1, inside_diameter,o_ring_groove);

if (o_ring_groove == "yes")
  rotate([0,0,30])
    translate([2*inside_diameter+10, 0])
      o_ring(inside_diameter);

if(number_of_sections>1){
for(f=[2:number_of_sections])
rotate([0,0,(f-1)*60])
translate([inside_diameter+10,0])
  middle(n[f-2], inside_diameter, o_ring_groove);
}

module base(bh, id, og) {
  ir = id / 2;
  $fn = 72;
  difference() {
    union() {
      for(s = [0:5])
        rotate([0, 0, s * 30])
          translate([-ir - 4, -1.5, 0])
            cube([id + 8, 3, bh + -7]);

      rotate_extrude()

        polygon(points = [
          [0, 0], 
          [ir + 3.2, 0], 
          [ir + 3.2, bh - 13], 
          [ir + 4.2, bh - 10], 
          [ir + 4.2, bh - 7], 
          [0, bh - 7]
        ]);

      translate([0, 0, bh - 8])
        linear_extrude(height = 10, twist = -180 * 10)
          translate([0.5, 0])
            circle(r = ir + 1.5);
    }

    rotate_extrude()
      translate([ir + 4.2, 0])
        circle(r = 2.8, $fn = 4);

    translate([0, 0, 2])
      cylinder(r = ir, h = bh + 0.1);

    translate([0, 0, bh + 1.5])
      rotate_extrude()
        translate([ir + 1, 0])
          square([2, 1]);

    translate([0, 0, bh + 1.5])
      rotate_extrude()
        translate([ir + 2, 0])
          circle(r = 1, $fn = 4);
    if (og == "yes")
      translate([0,0,bh-7])
        rotate_extrude()
          translate([ir+2,0])
            circle(r=1);
  }
}

module cap(id) {
  $fn = 72;

  ir = id / 2;
  difference() {
    union() {
      for(s = [0:5])
        rotate([0, 0, s * 30])
          translate([-ir - 4, -1.5, 0])
            cube([id + 8, 3, 9]);

      rotate_extrude()

        polygon(points = [
          [0, 0], 
          [ir + 3.2, 0], 
          [ir + 3.2, 6], 
          [ir + 4.2, 9], 
          [ir + 4.2, 12], 
          [0, 12]
        ]);
    }
    translate([0, 0, 2])
      linear_extrude(height = 10.2, twist = -180 * 10.2)
        translate([0.5, 0])
          circle(r = ir + 1.8);

    rotate_extrude()
      translate([ir + 4.2, 0])
        circle(r = 2.8, $fn = 4);

    translate([0, 0, 10.7])
      cylinder(r1 = ir, r2 = ir + 2.4, h = 1.4);

  }
}

module middle(mh, id, og) {
  $fn = 72;
  ir = id / 2;
  difference() {
    union() {
      rotate_extrude()
        polygon(points = [
          [0, 0], 
          [ir + 4.2, 0], 
          [ir + 4.2, 3], 
          [ir + 3.2, 6], 
          [ir + 3.2, mh - 3], 
          [ir + 4.2, mh], 
          [ir + 4.2, mh + 3], 
          [0, mh + 3]
        ]);

      for(s = [0:5])
        rotate([0, 0, s * 30])
          translate([-ir - 4, -1.5, 0])
            cube([id + 8, 3, mh + 2]);

      translate([0, 0, mh + 2])
        linear_extrude(height = 10, twist = -180 * 10)
          translate([0.5, 0])
            circle(r = ir + 1.5);

    }
    translate([0, 0, -0.2])
      linear_extrude(height = 10.2, twist = -180 * 10.2)
        translate([0.5, 0])
          circle(r = ir + 1.8);

    translate([0, 0, 12])
      cylinder(r = ir, h = mh + 0.2);

    translate([0, 0, mh + 11.5])
      rotate_extrude()
        translate([ir + 1, 0])
          square([2, 1]);

    translate([0, 0, mh + 11.5])
      rotate_extrude()
        translate([ir + 2, 0])
          circle(r = 1, $fn = 4);

    translate([0, 0, -0.1])
      cylinder(r1 = ir + 2.4, r2 = ir, h = 1.4);
      
    if (og == "yes")     
      translate([0,0,mh+3])
        rotate_extrude()
          translate([ir+2,0])
            circle(r=1);
  }
}

module o_ring(id){
  $fn=60;
  ir = id / 2;
  difference(){
    translate([0,0,sin(45)])
      rotate_extrude()
        translate([ir+2,0])
          circle(r=1);
            
    translate([0,0,-1])          
      cylinder(r= ir +4,h=1);         
}
}