#include <Keyboard.h>

// These constants won't change:
const int ledPin = 13;  // pin that the LED is attached to
const int Btn1 = 2;  // pin that the LED is attached to
const int Btn2 = 3;  // pin that the LED is attached to

bool btn1_flag = true;
bool btn2_flag = true;

void setup() {
  pinMode(ledPin, OUTPUT);   // initialize the LED pin as an output:
  pinMode(Btn1, INPUT_PULLUP);  //
  pinMode(3, INPUT_PULLUP);  //

  Keyboard.begin();
}

void loop() {

  bool btn_press = digitalRead(Btn1);
  if(!btn_press && btn1_flag){
    delay(10);
    if(!digitalRead(Btn1)){
      btn1_flag = false;
      Keyboard.press('q');
    }
  } else if(btn_press != btn1_flag){
    btn1_flag = true;
    Keyboard.release('q');    
  }

  btn_press = digitalRead(Btn2);
  if(!btn_press && btn2_flag){
    delay(10);
    if(!digitalRead(Btn2)){
      btn2_flag = false;
      Keyboard.press('e');
    }
  } else if(btn_press != btn2_flag){
    btn2_flag = true;
    Keyboard.release('e');    
  }

  digitalWrite(ledPin, btn2_flag && btn1_flag);
}