module hexGrid(
    xSize = 5,
    ySize = 5,
    lineWidth = 1,
    lineDepth = 1,
    lineLength = 6.6 
) {
    union() {
        for (y = [0:ceil(sqrt(3) * ySize)]) {
            for (x = [0:(floor(xSize) * 2 + 2)]) {
                
                if (x % 4 == 0) {
                    translate([
                        1.5 * (y % 2) * (lineLength - lineWidth / sqrt(3)) +
                            3 * (lineLength - lineWidth / sqrt(3)) * floor(x / 4),
                        y * (lineLength - lineWidth / sqrt(3)) * sqrt(3) / 2 + lineWidth / 2,
                        0
                    ])
                    rotate([0, 0, -30])
                    cube([lineWidth, lineLength, lineDepth]);
                }
                else if ((x % 4 == 1) && (y % 2 == 0)) {
                    translate([
                        3 * (lineLength - lineWidth / sqrt(3)) * floor(x / 4) + lineLength / 2,
                        y * (lineLength - lineWidth / sqrt(3)) * sqrt(3) / 2 +
                            (lineLength * sqrt(3) + lineWidth) / 2,
                        0
                    ])
                    rotate([0, 0, -90])
                    cube([lineWidth, lineLength, lineDepth]);
                }
                else if (x % 4 == 2) {
                    translate([
                        -1.5 * (y % 2) * (lineLength - lineWidth / sqrt(3)) +
                            3 * (lineLength - lineWidth / sqrt(3)) * floor(x / 4) +
                            lineLength * 3 / 2,
                        y * (lineLength - lineWidth / sqrt(3)) * sqrt(3) / 2 +
                            (lineLength * sqrt(3) + lineWidth) / 2,
                        0
                    ])
                    rotate([0, 0, -150])
                    cube([lineWidth, lineLength, lineDepth]);
                }
                else if ((x % 4 == 3) && (y % 2 == 0)) {
                    translate([
                        3 * (lineLength - lineWidth / sqrt(3)) * floor(x / 4) +
                            lineLength * 2 - lineWidth * sqrt(3) / 2,
                        y * (lineLength - lineWidth / sqrt(3)) * sqrt(3) / 2 + lineWidth,
                        0
                    ])
                    rotate([0, 0, -90])
                    cube([lineWidth, lineLength, lineDepth]);
                }
            }
        }
    }
}
