/*

 openscad code to make simple hanging ornaments

  from the thingiverse description

This is a second attempt to make an attractive ornament by reducing the number of
triangles in an stl file.  See thing:7204113 - Simple Bird Ornaments.

It is a remix of thing 5714745 "Leveret - Young Arctic Hare" a highly detailed
version of an artic hare.  The STL file for the leveret contains over 170,000 triangles.
It was simplified to an STL file with 84 triangles. 44 vertices, and 126 edges,
"rabbit_ascii.stl". The ornament was pierced by a tapered hollow cylinder which can hold
a thin wire to serve as a hanger, "rabbit_holed.stl".  "rabbit_edged.stl" is a
similar version where the edges of the triangles are decorated with cylinders.

"leveret_holed.stl" is a copy of the original file which includes a tapered hollow
cylinder so that it can be hung as an ornament for comparison.

 The calls below create the 4 stl files submitted to thingiverse - Note that leveret.stl
 was downloaded from thing 57147345 and needs to be in the same directory
 with the scad code when running module leveret_hole.


   remove the // and execute the calls one at a time to
   create the stl files


   Two other modules which might be of interest -


    wire_frame(edges,points,rb,fc);
    spheres(points,rb,fc);

   use the sets of vertices and edges included at the end of the code
   to run them



 PCM  November 2025

*/







*/

//  polyhedron(cords,triangles);       // makes rabbit_ascii.stl
//  hole();                            // makes rabbit_holed.stl
//  edge_hole();                       // makes rabbit_edged.stl
//  leveret_hole();                    // makes leveret_holed.stl

module wire_frame(edges,points,rb,fc)
{

/* edges -  list of bonds - to make cylinders for
   points - list of coordinates - that edges points to
   rb = radius of cylinders - fc - $fn for cylinders
*/

for (i = [0:len(edges)-1])
{
pp = points[edges[i][0]];
qq = points[edges[i][1]];
tx = (qq[0] + pp[0])/2;
ty = (qq[1] + pp[1])/2;
tz = (qq[2] + pp[2])/2;
ax = qq[0] - pp[0] ;
ay = qq[1] - pp[1];
az = qq[2] - pp[2];
translate(v=[tx,ty,tz])
rotate(a = [-acos(az/sqrt(ax*ax+ay*ay+az*az)), 0, -atan2(ax, ay)])
cylinder(r=rb,h=sqrt(ax*ax+ay*ay+az*az),center=true,$fn=fc);
}
}

module spheres(points,rb,fc)
{
// rb = radius of spheres - fc - $fn for spheres
 for (i = [0:len(points) - 1])
{
 pp = points[i];
 tx = pp[0];
 ty = pp[1];
 tz = pp[2];
 translate(v=[tx,ty,tz])
 sphere(r=rb,$fn=fc);
 }
}



module hole()
{
 // union()
 difference()
{
polyhedron(cords,triangles);
 // change the x and y translations to position the cylinder
translate([-26,0,-2])
tubes();
 }}



module leveret_hole()
{
 // union()
 difference()
{
import("leveret.stl");
 // change the x and y translations to position the cylinder
translate([-10,5,-2])
tubes();
 }}



module edge_hole()
{
 // union()
 difference()
{
 union()
{
polyhedron(cords,triangles);
// wire_frame(bonds_no_base,cords,1,8);
// wire_frame(bonds,cords,1,8);
   wire_frame(bonds,cords,0.8,8);
}
union()
{
 // change the x and y translations to position the cylinder
// translate([17,15,-2])
translate([-26,0,-2])
tubes();
translate([-5,0,-1])
cube([110,65,2],center=true);
 }}}



module tubes()
{
    union()
    {
 color("red")
cylinder(r=1,h=75,$fn=12);
color("yellow")
cylinder(r=1.33,h=40,$fn=12);
color("green")
cylinder(r=1.66,h=35,$fn=12);
color("blue")
cylinder(r=2,h=30,$fn=12);
    }
}



  cords = [
 [ -1.296154,27.905350,0.000000     ],  [ -13.879450,-27.128910,32.521019  ],
 [ -23.419720,29.492880,27.234289   ],  [ -24.653481,-25.833290,-0.000000  ],
 [ -26.308710,0.281277,44.818939    ],  [ -33.039162,-27.909069,12.355730  ],
 [ -35.160690,21.552010,0.000000    ],  [ -38.493198,-16.486271,29.932961  ],
 [ -39.470699,5.894803,35.641369    ],  [ -4.240191,-4.528092,77.734489    ],
 [ -42.213909,18.022631,17.637760   ],  [ -48.158680,-18.220551,14.904370  ],
 [ -5.167338,24.824619,32.035809    ],  [ -51.172649,-11.302050,0.000000   ],
 [ -6.088380,31.283239,81.716042    ],  [ -6.380888,-30.359100,9.868125    ],
 [ -7.854397,26.057199,12.849830    ],  [ 0.783038,-17.456980,40.068329    ],
 [ 12.632530,-13.774270,0.000000    ],  [ 13.810350,-8.332253,89.325233    ],
 [ 14.098480,20.084410,48.642948    ],  [ 16.745920,5.682468,75.375603     ],
 [ 16.957979,22.824551,58.723862    ],  [ 17.507910,28.541750,0.000000     ],
 [ 21.626881,-13.881430,66.984467   ],  [ 23.114380,-24.443340,28.465660   ],
 [ 25.020100,26.898720,84.000000    ],  [ 25.205570,26.604830,18.355810    ],
 [ 26.431490,12.236430,79.484001    ],  [ 30.645901,-16.532949,42.402988   ],
 [ 32.746960,1.647960,0.000000      ],  [ 33.552368,-5.019481,77.186684    ],
 [ 35.939869,17.622400,39.121719    ],  [ 37.651890,17.410311,0.000000     ],
 [ 41.359261,7.327225,20.859070     ],  [ 42.547699,-3.790307,39.424641    ],
 [ 44.135590,-15.346300,0.000000    ],  [ 45.461369,1.166325,0.000000      ],
 [ 46.302799,17.155930,56.552971    ],  [ 50.284130,4.496498,70.167763     ],
 [ 54.387650,-15.494630,57.488838   ],  [ 61.136059,-1.337981,52.345058    ],
 [ 7.250017,-6.461754,48.310490     ],  [ 8.962006,-24.290831,13.509590    ],
  ];


  triangles = [
 [  27 ,  12 , 23 ],   [  23 ,  33 , 27 ],   [  34 ,  27 , 30 ],
 [  33 ,  30 , 27 ],   [  22 ,  20 , 38 ],   [  38 ,  20 , 32 ],
 [  12 ,  27 , 20 ],   [  20 ,  27 , 32 ],   [  22 ,  26 , 14 ],
 [  26 ,  28 , 14 ],   [  38 ,  26 , 22 ],   [  39 ,  28 , 38 ],
 [  38 ,  28 , 26 ],   [   6 ,   2 , 10 ],   [  12 ,  16 , 23 ],
 [  16 ,   0 , 23 ],   [  16 ,   2 ,  6 ],   [   2 ,  16 , 12 ],
 [  12 ,   4 ,  2 ],   [  10 ,   2 ,  8 ],   [  34 ,  36 , 35 ],
 [  34 ,  30 , 37 ],   [  34 ,  37 , 36 ],   [  40 ,  39 , 41 ],
 [  40 ,  31 , 39 ],   [  29 ,  42 , 24 ],   [  25 ,  43 , 17 ],
 [  17 ,  42 , 29 ],   [  35 ,  25 , 29 ],   [  29 ,  25 , 17 ],
 [  42 ,  20 , 21 ],   [  41 ,  38 , 32 ],   [  41 ,  32 , 35 ],
 [  27 ,  34 , 32 ],   [  34 ,  35 , 32 ],   [  29 ,  40 , 35 ],
 [  35 ,  40 , 41 ],   [  36 ,  25 , 35 ],   [  40 ,  29 , 24 ],
 [  38 ,  41 , 39 ],   [  25 ,  36 , 43 ],   [  28 ,  39 , 31 ],
 [  31 ,  40 , 24 ],   [  20 ,  22 , 21 ],   [  24 ,  42 , 21 ],
 [  31 ,  19 , 21 ],   [  14 ,  21 , 22 ],   [  31 ,  24 , 19 ],
 [  24 ,   9 , 19 ],   [  14 ,  28 , 21 ],   [  21 ,  28 , 31 ],
 [  18 ,  15 , 43 ],   [   8 ,  11 , 10 ],   [   3 ,  11 ,  5 ],
 [  11 ,   3 , 13 ],   [  11 ,   7 ,  5 ],   [   1 ,  15 ,  5 ],
 [   5 ,  15 ,  3 ],   [  42 ,  12 , 20 ],   [   4 ,  12 , 42 ],
 [   1 ,  17 , 43 ],   [   4 ,   8 ,  2 ],   [  17 ,   1 ,  4 ],
 [   1 ,   7 ,  4 ],   [   1 ,   5 ,  7 ],   [  42 ,  17 ,  4 ],
 [  24 ,  21 ,  9 ],   [   9 ,  21 , 19 ],   [   7 ,   8 ,  4 ],
 [   8 ,   7 , 11 ],   [   1 ,  43 , 15 ],   [  30 ,  18 , 36 ],
 [   6 ,  13 ,  3 ],   [   0 ,   3 , 18 ],   [  30 ,  33 , 23 ],
 [  30 ,  23 , 18 ],   [  36 ,  37 , 30 ],   [  18 ,  23 ,  0 ],
 [   3 ,   0 ,  6 ],   [   6 ,   0 , 16 ],   [  43 ,  36 , 18 ],
 [  11 ,  13 , 10 ],   [  10 ,  13 ,  6 ],   [  15 ,  18 ,  3 ],
  ];


  bonds = [
 [   0 ,   3 ],  [   0 ,   6 ],  [   0 ,  16 ],  [   0 ,  18 ],
 [   0 ,  23 ],  [   1 ,   4 ],  [   1 ,   5 ],  [   1 ,   7 ],
 [   1 ,  15 ],  [   1 ,  17 ],  [   1 ,  43 ],  [   2 ,   4 ],
 [   2 ,   6 ],  [   2 ,   8 ],  [   2 ,  10 ],  [   2 ,  12 ],
 [   2 ,  16 ],  [   3 ,   5 ],  [   3 ,   6 ],  [   3 ,  11 ],
 [   3 ,  13 ],  [   3 ,  15 ],  [   3 ,  18 ],  [   4 ,   7 ],
 [   4 ,   8 ],  [   4 ,  12 ],  [   4 ,  17 ],  [   4 ,  42 ],
 [   5 ,   7 ],  [   5 ,  11 ],  [   5 ,  15 ],  [   6 ,  10 ],
 [   6 ,  13 ],  [   6 ,  16 ],  [   7 ,   8 ],  [   7 ,  11 ],
 [   8 ,  10 ],  [   8 ,  11 ],  [   9 ,  19 ],  [   9 ,  21 ],
 [   9 ,  24 ],  [  10 ,  11 ],  [  10 ,  13 ],  [  11 ,  13 ],
 [  12 ,  16 ],  [  12 ,  20 ],  [  12 ,  23 ],  [  12 ,  27 ],
 [  12 ,  42 ],  [  14 ,  21 ],  [  14 ,  22 ],  [  14 ,  26 ],
 [  14 ,  28 ],  [  15 ,  18 ],  [  15 ,  43 ],  [  16 ,  23 ],
 [  17 ,  25 ],  [  17 ,  29 ],  [  17 ,  42 ],  [  17 ,  43 ],
 [  18 ,  23 ],  [  18 ,  30 ],  [  18 ,  36 ],  [  18 ,  43 ],
 [  19 ,  21 ],  [  19 ,  24 ],  [  19 ,  31 ],  [  20 ,  21 ],
 [  20 ,  22 ],  [  20 ,  27 ],  [  20 ,  32 ],  [  20 ,  38 ],
 [  20 ,  42 ],  [  21 ,  22 ],  [  21 ,  24 ],  [  21 ,  28 ],
 [  21 ,  31 ],  [  21 ,  42 ],  [  22 ,  26 ],  [  22 ,  38 ],
 [  23 ,  27 ],  [  23 ,  30 ],  [  23 ,  33 ],  [  24 ,  29 ],
 [  24 ,  31 ],  [  24 ,  40 ],  [  24 ,  42 ],  [  25 ,  29 ],
 [  25 ,  35 ],  [  25 ,  36 ],  [  25 ,  43 ],  [  26 ,  28 ],
 [  26 ,  38 ],  [  27 ,  30 ],  [  27 ,  32 ],  [  27 ,  33 ],
 [  27 ,  34 ],  [  28 ,  31 ],  [  28 ,  38 ],  [  28 ,  39 ],
 [  29 ,  35 ],  [  29 ,  40 ],  [  29 ,  42 ],  [  30 ,  33 ],
 [  30 ,  34 ],  [  30 ,  36 ],  [  30 ,  37 ],  [  31 ,  39 ],
 [  31 ,  40 ],  [  32 ,  34 ],  [  32 ,  35 ],  [  32 ,  38 ],
 [  32 ,  41 ],  [  34 ,  35 ],  [  34 ,  36 ],  [  34 ,  37 ],
 [  35 ,  36 ],  [  35 ,  40 ],  [  35 ,  41 ],  [  36 ,  37 ],
 [  36 ,  43 ],  [  38 ,  39 ],  [  38 ,  41 ],  [  39 ,  40 ],
 [  39 ,  41 ],  [  40 ,  41 ],    ];



  bonds_no_base = [
 [   0 ,  16 ],  [   1 ,   4 ],  [   1 ,   5 ],  [   1 ,   7 ],
 [   1 ,  15 ],  [   1 ,  17 ],  [   1 ,  43 ],  [   2 ,   4 ],
 [   2 ,   6 ],  [   2 ,   8 ],  [   2 ,  10 ],  [   2 ,  12 ],
 [   2 ,  16 ],  [   3 ,   5 ],  [   3 ,  11 ],  [   3 ,  15 ],
 [   4 ,   7 ],  [   4 ,   8 ],  [   4 ,  12 ],  [   4 ,  17 ],
 [   4 ,  42 ],  [   5 ,   7 ],  [   5 ,  11 ],  [   5 ,  15 ],
 [   6 ,  10 ],  [   6 ,  16 ],  [   7 ,   8 ],  [   7 ,  11 ],
 [   8 ,  10 ],  [   8 ,  11 ],  [   9 ,  19 ],  [   9 ,  21 ],
 [   9 ,  24 ],  [  10 ,  11 ],  [  10 ,  13 ],  [  11 ,  13 ],
 [  12 ,  16 ],  [  12 ,  20 ],  [  12 ,  23 ],  [  12 ,  27 ],
 [  12 ,  42 ],  [  14 ,  21 ],  [  14 ,  22 ],  [  14 ,  26 ],
 [  14 ,  28 ],  [  15 ,  18 ],  [  15 ,  43 ],  [  16 ,  23 ],
 [  17 ,  25 ],  [  17 ,  29 ],  [  17 ,  42 ],  [  17 ,  43 ],
 [  18 ,  43 ],  [  19 ,  21 ],  [  19 ,  24 ],  [  19 ,  31 ],
 [  20 ,  21 ],  [  20 ,  22 ],  [  20 ,  27 ],  [  20 ,  32 ],
 [  20 ,  38 ],  [  20 ,  42 ],  [  21 ,  22 ],  [  21 ,  24 ],
 [  21 ,  28 ],  [  21 ,  31 ],  [  21 ,  42 ],  [  22 ,  26 ],
 [  22 ,  38 ],  [  23 ,  27 ],  [  24 ,  29 ],  [  24 ,  31 ],
 [  24 ,  40 ],  [  24 ,  42 ],  [  25 ,  29 ],  [  25 ,  35 ],
 [  25 ,  36 ],  [  25 ,  43 ],  [  26 ,  28 ],  [  26 ,  38 ],
 [  27 ,  30 ],  [  27 ,  32 ],  [  27 ,  33 ],  [  27 ,  34 ],
 [  28 ,  31 ],  [  28 ,  38 ],  [  28 ,  39 ],  [  29 ,  35 ],
 [  29 ,  40 ],  [  29 ,  42 ],  [  30 ,  34 ],  [  31 ,  39 ],
 [  31 ,  40 ],  [  32 ,  34 ],  [  32 ,  35 ],  [  32 ,  38 ],
 [  32 ,  41 ],  [  34 ,  35 ],  [  34 ,  36 ],  [  34 ,  37 ],
 [  35 ,  36 ],  [  35 ,  40 ],  [  35 ,  41 ],  [  36 ,  43 ],
 [  38 ,  39 ],  [  38 ,  41 ],  [  39 ,  40 ],  [  39 ,  41 ],
 [  40 ,  41 ],    ];
