/* =================
 * Tablet Bottom Die
 * =================
 * Version 1.12.2025
 * Place the pill to be pushed out over the center of the bottom die (pill up).  
 */

dd_top			= 1; // Top neeedle basic diameter
dd_base			= 2; // Bottom needle basic diameter
dd_variation	= function(x,y,f) (abs(x)+abs(y))/(xy_size/f); // Needle diameter variation formula
xy_size			= 40; // Overall xy-size
xy_border		= 4;	// Solid boder strip width
z_base			= 2;	// Z-height of the base plate
z_needles		= 10;	// Needle height
min_tablet		= 6;	// Central needle-free zone (aka diameter of the smallest pill)

dmink				= min(z_base,xy_border)-0.001; // minkowski() rounding diameter
$fn				= 36;



// Box
minkowski() {
	translate([0,0,z_needles/2-z_base/2]) difference() {
		// Main contour
		cube([xy_size-dmink,xy_size-dmink,z_needles+z_base-dmink],true);
		// Main cutout
		translate([0,0,z_base])cube([xy_size-2*xy_border+dmink,xy_size-2*xy_border+dmink,z_needles+z_base+dmink],true);
	}
	sphere(d=dmink,$fn=16);
}
// Needles
for (x =    [0:2*dd_base:xy_size/2-dd_base/2-xy_border]) {
	for (y = [0:2*dd_base:xy_size/2-dd_base/2-xy_border]) {
		if (abs(x+dd_base/2)+abs(y+dd_base/2) > min_tablet) {
			for (xx = [-1,+1]) {
				for (yy = [-1,+1]) {
					translate([x*xx,y*yy,0]) cylinder(d1=dd_base+dd_variation(x,y,4),d2=dd_top+dd_variation(x,y,3),h=z_needles);
				}
			}
		}
	}
}
//	#cylinder(d=8,h=z_size); # Visualizing the central needle-free zone
