#ifndef _MOTIONCONTROL_H_
#define _MOTIONCONTROL_H_

#include "../Drive/Hiwonder.h"
#include "FKIK.h"       // 正逆解库
#include <WiFiClient.h>
#include "../Drive/IOs.h"

#define SerNum  8

// 摆线参数
#define XS      90.0    // X原点   40 ~ 140             (50)
#define YS      -130.0  // Y原点   x = 90:-88 ~ -172    (42)
#define XMOVE   40      // X距离
#define H       20      // 抬腿高度

class Robot
{
    public:
        bool RobotStatus = 1;      // 0->履车形态; 1->四足形态

        void begin();       // 初始化

        uint16_t SPos[SerNum]    = {};  // 位置存储
        uint16_t SVin[SerNum]    = {};  // 电压存储
        uint8_t STemp[SerNum]    = {};  // 温度存储

        uint8_t legNum = 1;             // 单腿编号
        
        /* ------------------ 模式控制 ------------------ */
        
        void FK_ResetQuadruped();       // 四足行进模式--正解姿态
        void IK_ResetQuadruped();       // 四足行进模式--逆解状态

        void ResetTrack(bool status);   // 履带行进模式--基础模式 
        void FK_TStatus_HIGH();         // 履带行进模式--高姿态
        void FK_TStatus_HIGHER();       // 履带行进模式--最高姿态

        void FK_LEFT();                 // 姿态左倾
        void FK_RIGHT();                // 姿态右倾

        /* ------------------ 卸载控制 ------------------ */
        void PowerOff();                // 全部卸载
        void LegUnload(uint8_t legNum); // 单腿卸载

        /* ------------------ 单腿控制 ------------------ */
        uint16_t D2V(float angle);
        // 读取
        float RUAngle[2] = {};          // 角度存储
        float LUAngle[2] = {};
        float RBAngle[2] = {};
        float LBAngle[2] = {};
        
        void RU_ReadPOS();
        void LU_ReadPOS();
        void RB_ReadPOS();
        void LB_ReadPOS();

        // 正解
        void FK_LUMove(float posk,float posx,uint16_t Time);    //左前腿
        void FK_RUMove(float posk,float posx,uint16_t Time);    //右前腿
        void FK_LBMove(float posk,float posx,uint16_t Time);    //左后腿
        void FK_RBMove(float posk,float posx,uint16_t Time);    //右后腿

        void FK_LegMove(float Angle[],uint8_t legNum,uint16_t DSD,bool Print);   // 单腿正解

        void FK_LSMove(float posk,uint16_t Time);               //左侧双腿
        void FK_RSMove(float posk,uint16_t Time);               //右侧双腿
        // 逆解
        float IK_RUPoint[2] = {};// 坐标点存储
        float IK_LUPoint[2] = {};
        float IK_RBPoint[2] = {};
        float IK_LBPoint[2] = {};

        void IK_LUMove(float x,float y,uint16_t Time);//左前腿
        void IK_RUMove(float x,float y,uint16_t Time);//右前腿
        void IK_LBMove(float x,float y,uint16_t Time);//左后腿
        void IK_RBMove(float x,float y,uint16_t Time);//右后腿

        void IK_LegMove(float point[],uint8_t LEGNum,uint16_t DSD,bool Print);//单腿逆解

        void LegPointDebug(float point[],uint8_t cmd,byte offset,bool PrintPoint,bool PrintAngle);//单腿调试

        /* --- 摆线 --- */
        float F1_CPoints[20][2] = {};// 前进1摆线
        float F2_CPoints[20][2] = {};// 前进2摆线
        float F3_CPoints[20][2] = {};// 前进3摆线

        float B1_CPoints[20][2] = {};// 后退1摆线
        float B2_CPoints[20][2] = {};// 后退2摆线
        float B3_CPoints[20][2] = {};// 后退3摆线

        void GetCycloidPoints(float CPoints[][2],float xs,float xf,float ys,float yh);// 摆线轨迹获取
        void LegCycloid(float CPoints[][2],uint8_t LEGNum);                           // 足端摆线运动
        /* ------------------ 姿态控制 ------------------ */
        void PosMove(float xMove,float yMove,uint16_t Time);// 姿态直线相对移动
        void PosAction1();                                  // 姿态动作1

        void PosToPoint(float x,float y,uint16_t Time); // 姿态坐标位置
        void PosToPitch(float deg,uint16_t Time);       // 姿态俯仰角
        void PosToRoll (float deg,uint16_t Time);       // 姿态翻滚角
        void PosAction2(uint8_t Num);                   // 姿态动作2
        
        void PosAction3();                   // 姿态动作3
        void PosAction4();                   // 姿态动作4
        /* ------------------ 运动控制 ------------------ */
        bool TrotStatus = 0;      // 0->停止; 1->小跑
        bool WalkStatus = 0;      // 0->停止; 1->小跑

        void Trot();        // Trot小跑步态
        void Walk();        // Walk行走步态
        void Walk_Basic(uint8_t SetpNum,bool dir);        // Walk行走步态


        void VMC(float j0,float j1,float VMCPoint[],float VMCPoint_last[]);// VMC算法框架*(测试)

        /* ------------------ 动作设计 ------------------ */
        void Hello();// 打招呼

        /* ------------------ 信息提取 ------------------ */
        void GetServoInfo(bool Pos,bool Vin,bool Temp);//获取数据:0->位置;1->电压;2->温度
};

#endif
