#include <Arduino.h>
#include "FreeRTOS.h"

//驱动函数
#include "Drive/DCMotorDrive.h"
#include "Drive/ServoDrive.h"
#include "Drive/IMU.h"
#include "Drive/Hiwonder.h"
#include "Drive/IOs.h"

//运动学函数
#include "Dynamics/FKIK.h"
#include "Dynamics/MotionControl.h"

//WIFI库
#include <WiFi.h>
#include <WiFiClient.h>

#define ssid      "ESP_Rabbit"
#define password  "12345678"

// *----------------------- 子函数声明 -----------------------* //
void TCPDebug();
void SerialDebug();
void CmdSwitch(char cmd);
void ALLPOWOFF();
void HolderDebug();
void ShowStatus();
void Yes();
// *------------------------- 类声明 -------------------------* //
Robot         robot;
IMU           mpu;                  //MPU6050             
DCMotorDrive  DCm;                  //直流电机组
ServoDrive    Servos;               //PWM舵机组
WiFiServer    server(80);           //在端口80开启服务端（热点）
WiFiClient    client_Move;

HardwareSerial ServoSer (1);        //Hiwonder舵机
HardwareSerial OpenMVSer(2);        //OpenMV

extern U8G2_SSD1306_128X64_NONAME_2_HW_I2C u8g2;
extern Adafruit_NeoPixel pixels;

/*########################################################### */
bool    Status_Last = 1;      // 指令缓存
String  OLED_Str    = "";     // OLED字符
/*########################################################### */

void setup() {
  pinMode(LEDpin,OUTPUT);
  digitalWrite(LEDpin,0);

  /*----------------------------------------------------------*/
  // 串口初始化
  Serial.   begin(115200);
  ServoSer. begin(115200,SERIAL_8N1,Servo_TXD,  Servo_RXD);
  // OpenMVSer.begin(115200,SERIAL_8N1,OpenMV_TXD, OpenMV_RXD);

  // 基本驱动初始化
  DCm.    begin();
  mpu.    begin();
  robot.  begin();
  Servos. begin();

  InitIOs();

  /*----------------------------------------------------------*/
  // WIFI初始化
  Serial.println(F("** Configure WIFI..."));

  WiFi.mode(WIFI_AP);           //AP模式
  WiFi.softAP(ssid, password);  //WiFi名称+密码
  server.begin();
  
  Serial.print(F("  ----- AP--IPv4: "));Serial.println(WiFi.softAPIP());
  Serial.println(F("[WIFI]\tInit Success!"));

  /*----------------------------------------------------------*/
  Serial.println();
  Serial.println(F("|*****************************|"));
  Serial.println(F("|***> Robot System Start! <***|"));
  Serial.println(F("|*****************************|"));
  Serial.println();
  /*----------------------------------------------------------*/

  BlinkLed(LEDpin,2);  
  digitalWrite(LEDpin,1);
}


void loop() {
  // OLED_Debug();
  SerialDebug();
  TCPDebug();
}

/* ------------------ 指令控制 ------------------ */
/*
*   指令控制代码
*/
void CmdSwitch(char cmd){
    /*
    * 四足模式
    */
  if(robot.RobotStatus){
    switch(cmd){
        case '0':ALLPOWOFF();       break;
        case '4':robot.Trot();      break;
        case '1':robot.Walk();      break;

        // case '6':robot.Walk();      break;
        // case '3':robot.Walk();      break;
        
        case '8':robot.PosAction2(1);break;   // 圆圈
        case '5':robot.PosAction3(); break;   // Pitch控制     
        case '7':robot.PosAction1();break;    // 矩形
        case '9':robot.PosAction4();break;    // Roll控制 

        case 'x': 
          robot.RobotStatus = 0;   
          Serial.println(F("切换履车..."));
          robot.ResetTrack(0);
          break;

        case 'a': robot.FK_ResetQuadruped();  break;
        case 'b': robot.IK_ResetQuadruped();  break;
        case 'c': robot.ResetTrack(0);        break;
        case 'd': robot.ResetTrack(1);        break;

        case 'e': 
          robot.RU_ReadPOS();
          robot.RB_ReadPOS();
          robot.LU_ReadPOS();
          robot.LB_ReadPOS();
        break;

        case 'g':
          HolderDebug();
          break;
        case 'h':
          Yes();
          break;
        }
  }else{
    /*
    * 履车模式
    */
    switch(cmd){
      case '0':ALLPOWOFF();             break;
      case '5': DCm.stop();
                robot.ResetTrack(0);    break;

      case '8':DCm.forword  (1);        break;
      case '2':DCm.backword (1);        break;

      case '7':
        DCm.F_turnLeft (1,0.5);  
        break;   
      case '9':DCm.F_turnRight(1,0.5);  break;
      case '1':DCm.B_turnLeft (1,0.5);  break;
      case '3':DCm.B_turnRight(1,0.5);  break;

      case '4':robot.FK_TStatus_HIGH();   break;
      case '6':robot.FK_TStatus_HIGHER(); break;

      case 'x': 
        robot.RobotStatus = 1;   
        Serial.println(F("切换四足..."));
        robot.IK_ResetQuadruped(); 
        break;

      case 'a': robot.FK_ResetQuadruped();  break;
      case 'b': robot.IK_ResetQuadruped();  break;
      case 'c': robot.ResetTrack(0);        break;
      case 'd': robot.ResetTrack(1);        break;

      case 'e': 
        robot.RU_ReadPOS();
        robot.RB_ReadPOS();
        robot.LU_ReadPOS();
        robot.LB_ReadPOS();
        break;

      case 'f':
        DCm.Test();
        break;

      case 'g':
        HolderDebug();
        break;

      case 'h':
        Yes();
        break;
    }
  }  
}

/*
* 串口调试
*/
void SerialDebug(){
  ShowStatus();
  if(Serial.available()){
  
    uint8_t cmd = Serial.read();
    Serial.print(F("Order:"));
    Serial.println((char)cmd);

    BlinkLed(LEDpin,1);
    CmdSwitch(cmd);
  }
}

/*
* 网络调试
*/
void TCPDebug(){
  WiFiClient client = server.available();   // 监听客户端

  if (client) {                             
    Serial.println(F("New Client..."));      
    BlinkLed(LEDpin,3); 

    client_Move = client;

    while (client.connected()) {            // 如果客户端连接
      ShowStatus();
      
      if (client.available()) {             
        char cmd =  client.read();             

        if (cmd != '\n') {                  
          BlinkLed(LEDpin,1);               // LED闪烁1次

          Serial.print(F("TCP-Order:"));
          Serial.println((char)cmd);

          CmdSwitch(cmd);                   // 接收控制指令
        }
      }
    }

    // TCP连接关闭
    client.stop();
    Serial.println(F("Client Disconnected."));
    robot.RobotStatus = 1;
    digitalWrite(LEDpin,LOW);
  }
}

// 全部关闭
void ALLPOWOFF(){
  robot.PowerOff();
  DCm.stop();

  pixels.fill(pixels.Color(0, 0, 0));
  pixels.show();
  pixels.fill(pixels.Color(0, 0, 0));
  pixels.show();
   
  u8g2.clear();

}

// 云台测试
void HolderDebug(){
  Servos.Write(0,90); 
  Servos.Write(15,45);
  delay(800);
  Servos.Write(0,45); 
  delay(400);
  Servos.Write(0,135);
  delay(800);
  Servos.Write(0,90);Servos.Write(15,0);
}

// 云台点头
void Yes(){
  Servos.Write(0,90); 
  Servos.Write(15,45);
  delay(800);

  for(uint8_t i = 0;i < 3;i++){
    Servos.Write(15,70); 
    delay(100);
    Servos.Write(15,0);
    delay(100);
  }
  Servos.Write(15,45);

  delay(800);
  Servos.Write(0,90);Servos.Write(15,0);
}
/**
 * 状态指示
 */
void ShowStatus(){
  if(Status_Last != robot.RobotStatus){
    if(!robot.RobotStatus){
      OLED_Str = "Track";
      // pixels.setPixelColor(0, pixels.Color(255, 127, 0)); // 橙色 
      pixels.fill(pixels.Color(255, 127, 0)); // 橙色 
    }else{
      OLED_Str = "Quadruped";
      // pixels.setPixelColor(0, pixels.Color(238, 18, 137)); // 深红
      pixels.fill(pixels.Color(238, 18, 137)); // 深红
    }
    pixels.show(); 

    u8g2.firstPage();        // 标志图像循环的开始
    do{
      u8g2.setCursor(128,48);  u8g2.print(OLED_Str);
    }while(u8g2.nextPage());  // 标志图像循环的结束
  }

  Status_Last = robot.RobotStatus;
}