//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++ Author: Frans Nijhuis, 7 November 2025    ++++++++++++++++++++++++++
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//    

Number_of_Grip_Rings = [4];    // [2: 1  :  8]
Triangle_Hat_Height = [13.0];  // [0: 0.5: 13.0]
Half_Hat_Depth = false;

/*[Hidden]*/  

$fn = $preview ? 50 : 150;

module roundedTriangle(width, height, diameter){
    triangleX = (width - diameter)/2;
    hull(){
        translate([ triangleX, 0, 0]) cylinder(h=height, d=diameter, center=true);
        translate([-triangleX, 0, 0]) cylinder(h=height, d=diameter, center=true);
        translate([ 0, Triangle_Hat_Height[0], 0]) cylinder(h=height, d=diameter, center=true);
    }
}

module roudedCube(width, depth, height, diameter){
    halfWidth = (width - diameter)/2;
    halfDepth = (depth - diameter)/2;
    hull(){
        translate([ halfWidth, halfDepth, 0]) cylinder(h=height, d=diameter, center=true);
        translate([-halfWidth, halfDepth, 0]) cylinder(h=height, d=diameter, center=true);
        translate([ halfWidth,-halfDepth, 0]) cylinder(h=height, d=diameter, center=true);
        translate([-halfWidth,-halfDepth, 0]) cylinder(h=height, d=diameter, center=true);
    }
}

module arc(width, height){
    radiusArc = 45;
    arcLengthDegrees = 21;
    rotAngleZ = 90 - arcLengthDegrees/2;
    
    translate([0, -radiusArc + width + 0.415, 0])
        rotate([0, 0, rotAngleZ])
            rotate_extrude(arcLengthDegrees, 0, convexity=2, $fn=200)
                translate([radiusArc, 0, 0])
                    square([width, height], center=true);
}

module gripRings(lockHeight, lockDepth){
    circleDiameter = 2;
    thorusRadius = (lockDepth - circleDiameter)/2; 
    startZ = - (lockHeight - circleDiameter)/2;  
    stepZ = (lockHeight - circleDiameter) / (Number_of_Grip_Rings[0] - 1);

    for (i = [0: 1: Number_of_Grip_Rings[0] - 1]){
        translate([0, 0, startZ + i * stepZ]) 
            rotate_extrude(360, 0, convexity = 2)
                translate([thorusRadius, 0, 0])
                    circle(d = circleDiameter);
    }
}

module composition(){
    lockWidth  = 18.0;
    lockDepth  =  7.5;
    lockHeight =  9.5;
    lockFillet =  1.5;
    difference(){
        union(){
            roudedCube(lockWidth, lockDepth, lockHeight, lockFillet);               // Outside
            //    arc(1.5, lockHeight);
            
            translate([ lockWidth/2, 0, 0]) cylinder(h=lockHeight, d = lockDepth - 2, center=true);
            translate([-lockWidth/2, 0, 0]) cylinder(h=lockHeight, d = lockDepth - 2, center=true);
            
            translate([ lockWidth/2, 0, 0]) gripRings(lockHeight, lockDepth);
            translate([-lockWidth/2, 0, 0]) gripRings(lockHeight, lockDepth);
            
            hatHeight = Half_Hat_Depth ? lockHeight/2 : lockHeight;
            hatZ = Half_Hat_Depth ? -hatHeight/2 : 0;
            if (Triangle_Hat_Height[0] > 0) translate([0, lockDepth/2 - 0.75, hatZ ]) roundedTriangle(lockWidth, hatHeight, 2*lockFillet);
            
        }
        translate([0, -0.5, 0]) roudedCube(lockWidth - 3.75 , 4.5, lockHeight + 1, lockFillet);    // Removed inside
        translate([0, -3, 0])        cube([lockWidth - 6.5    , 4,   lockHeight + 1], center=true);  // Opening 'underside'.
    }
    arc(2.725, lockHeight);
}

composition();
