// ---- Bodemplaat ----
basis_lengte = 60;    
basis_breedte = 50;   
basis_hoogte = 2;
cube([basis_lengte, basis_breedte, basis_hoogte]);

// ---- Blokje rechts met sleuf ----
blok_lengte = 38;
blok_breedte = 10.2;
blok_hoogte = 2.9;

sleuf_breedte = 5;
sleuf_lengte = 25;
sleuf_diepte = blok_hoogte; // volledig tot bodemplaat

x_blok = basis_lengte - blok_breedte;  
y_blok = (basis_breedte - blok_lengte)/2; 
z_blok = basis_hoogte; // bovenop bodemplaat

translate([x_blok, y_blok, z_blok])
    difference() {
        cube([blok_breedte, blok_lengte, blok_hoogte]);
        translate([(blok_breedte - sleuf_breedte)/2, (blok_lengte - sleuf_lengte)/2, 0])
            cube([sleuf_breedte, sleuf_lengte, sleuf_diepte]);
    }

// ---- Nokje met rond gat (extra 2 mm diep) ----
rond_diameter = 12;
rond_hoogte = 2.9;

x_rond_hart = 8;             
y_rond_hart = basis_breedte / 2; 
z_rond = basis_hoogte + rond_hoogte/2; // onderkant op bodemplaat + hoogte

translate([x_rond_hart, y_rond_hart, z_rond])
    difference() {
        cylinder(d = rond_diameter, h = rond_hoogte, $fn=100, center=true);
        // Gat Ø6 mm, diepte = 2,9 + 2 = 4,9 mm
        translate([0,0,rond_hoogte/2 - 4.9])
            cylinder(d = 6, h = 4.9, $fn=50, center=false);
    }
