// ---- Bodemplaat wederhelft ----
basis_lengte = 60 - 2;  // 2 mm korter rechts
basis_breedte = 50;   
basis_hoogte = 2;
cube([basis_lengte, basis_breedte, basis_hoogte]);

// ---- Blokje dat in de sleuf past ----
blok_lengte_sleuf = 25; // past in sleuf
blok_breedte_sleuf = 4.8; // iets kleiner dan 5 mm sleuf
blok_hoogte_sleuf = 2.8; // iets lager dan sleuf

// Positie van blokje: linkerkant = 52,7 mm (van links)
x_blok_sleuf = 52.7; 
y_blok_sleuf = (basis_breedte - blok_lengte_sleuf)/2;
z_blok_sleuf = basis_hoogte; // bovenop bodemplaat

translate([x_blok_sleuf, y_blok_sleuf, z_blok_sleuf])
    cube([blok_breedte_sleuf, blok_lengte_sleuf, blok_hoogte_sleuf]);

// ---- Rondje dat in gat van nokje past ----
rond_diameter_sleuf = 6; // past in gat van nokje
rond_hoogte_sleuf = 2.8; // iets lager dan gat

x_rond_sleuf = 8; // hart gelijk aan nokje
y_rond_sleuf = basis_breedte / 2;
z_rond_sleuf = basis_hoogte; // bovenop bodemplaat

translate([x_rond_sleuf, y_rond_sleuf, z_rond_sleuf])
    cylinder(d = rond_diameter_sleuf, h = rond_hoogte_sleuf, $fn=50, center=false);
