font = "Liberation Mono:style=Bold";
Version="V3";

$fn=64;

// Base
L=250;
B=150;
H=3;

// Base Befestigungsloch
BBN=H+0.1;
BSpace=H*2;
BLN=L-BSpace;

module rounded_bottom_box(w, l, h, r) 
{
	inner_length = l - 2 * r;
	inner_width = w - 2 * r;
	inner_height = h - r;
	
	hull() {
		translate([-inner_width / 2, -inner_length/2, r]) cylinder(r=r, h=inner_height);
		translate([inner_width / 2, -inner_length/2, r]) cylinder(r=r, h=inner_height);
		translate([inner_width / 2, inner_length/2, r]) cylinder(r=r, h=inner_height);
		translate([-inner_width / 2, inner_length/2, r]) cylinder(r=r, h=inner_height);
		
		translate([-inner_width / 2, -inner_length/2, r]) sphere(r=r);
		translate([inner_width / 2, -inner_length/2, r]) sphere(r=r);
		translate([inner_width / 2, inner_length/2, r]) sphere(r=r);
		translate([-inner_width / 2, inner_length/2, r]) sphere(r=r);
	}
}

module HalbKreis(Dx, Hx)
{
    difference()
    {
        cylinder(d=Dx,h=Hx);
        translate([-Dx,0,-0.1]) cube([Dx*2,Dx*2,Hx*2]);
    }   
}

BLH=10;
Screw=2.8;
DYScrew=2.2;
BLSpace=2;
BLLen=L-BLSpace;


module BLeiste()
{
    difference()
    {
        translate([BLSpace/2,0,0]) cube([BLLen,H,BLH]);
        for(i=[Screw:Screw*1.2:L-BSpace])  
            translate([Screw+i,-0.1,BLH/2+DYScrew]) rotate([-90,0,0]) cylinder(d=Screw,h=H+0.2);
    }
}

module BasePlate()
{
    difference()
    {
        // Base plate
        rounded_bottom_box(L, B, H, 1);
        // Nuts
        translate([-L/2+BSpace/2,B/2-10-BBN,-0.1]) cube([BLN,BBN,H+0.2]);
        translate([-L/2+BSpace/2,-B/2+10,-0.1]) cube([BLN,BBN,H+0.2]);
        // Version
        translate([-10, -3, H-0.4]) scale([1,1,1]) linear_extrude(1) text(Version, font = font, size = 10);
        
    }
    // Befestigungsleiste
    translate([-L/2,-B/2+10-BBN-0.1,0]) BLeiste();
    translate([-L/2,+B/2-10+BBN-H-0.1,0]) BLeiste();    
    // Beine
    BH=50;
    translate([-L/2+H/2,0,0])  rounded_bottom_box(H+1, B, BH, 1);
    translate([L/2-H/2,0,0])  rounded_bottom_box(H, B, BH, 1);
    // Fuss
    translate([L/2-H/2,B/2,BH]) rotate([90,0,0]) cylinder(d=H*2,h=B);
    translate([-L/2+H/2,B/2,BH]) rotate([90,0,0]) cylinder(d=H*2,h=B);
    // Verstärkung
    translate([-L/2+H/2,B/4,H]) rotate([0,90,0]) scale([1,4,1]) cylinder(d=H*2,h=L-H);
    translate([-L/2+H/2,-B/4,H]) rotate([0,90,0]) scale([1,4,1]) cylinder(d=H*2,h=L-H);
}

module SplitPlateBef()
{
    difference()
    {
        translate([0,-0.1,0]) cube([H,BLH+0.1,BLH]);
        translate([-0.1,BLH/2+DYScrew,BLH/2]) rotate([0,90,0]) cylinder(d=Screw,h=H+0.2);
    }
}

module SplitPlate(SK)
{
    difference()
    {
        // Split Base Plate
        scale([1,SK,1]) translate([0,0,0]) HalbKreis(B,2);
        // Version
        translate([10, -3, H-0.4]) scale([1,1,1]) rotate([0,0,180]) linear_extrude(1) text(Version, font = font, size = 10);
    }
    HDelta=3;
//    translate([-B/2+BSpace,0,HDelta]) SplitPlateBef();
//    translate([+B/2-BSpace-BBN,0,HDelta]) SplitPlateBef();
    translate([-B/2+10,0,HDelta]) SplitPlateBef();
    translate([+B/2-10-BBN,0,HDelta]) SplitPlateBef();
    // KippKante
    KKB=2;
    KKH=10;
    translate([-B/2,-KKB,0]) cube([B,KKB,KKH+HDelta]);

}

// What = 0 BasePLate
// What = 1 Splitplate Big
// What = 2 Splitplate Small

What=1;

if (What==0) BasePlate();
if (What==1)
{
    SplitPlate(1);
//    translate([0,80,0]) SplitPlate(1);
}
if (What==2)
{
    SplitPlate(0.7);
//    translate([0,55,0]) SplitPlate(0.7);
//    translate([0,55+55,0]) SplitPlate(0.7);
//    translate([0,55+55+55,0]) SplitPlate(0.7);
}

