$fn=64;

B=25.2;
L=65; // Aldi
L2=76; // EMSER

Wall=2;

Di=40;
D=L*2+Di+Wall*2;

D2=L2*2+Di+Wall*2;

Db=3.5;

module Unten()
{
    difference()
    {
        union()
        {
            // Untere Scheibe
            cylinder(d=D, h=Wall);
        
            // Obere Scheibe
    //        translate([0,0,Wall+B]) cylinder(d=D, h=Wall);

            // Mitte 
            cylinder(d=Di, h=Wall*2+B);
        }
        // Bohrung Mitte
        translate([0,0,-0.1]) cylinder(d=Db, h=Wall*2+B+0.2);
        // Befestigungs Bohrung
        D1=1;
        D2=2.8;
        for(R=[0:360/3:360])
            rotate([0,0,R]) translate([12,0,Wall*2+0.1]) cylinder(d1=D1,d2=D2,B);
    }


    F=360/(60+1);
    ICut=18;
    for(R=[0:F:360])
        rotate([0,0,R]) translate([Di/2+ICut,-Wall/4,0]) cube([D/2-Di/2-10-ICut, Wall/2, B+Wall*2]);
}

module Oben()
{
    Toll=0.2;
    Deep=0.5;
    difference()
    {
        // Untere Scheibe
        cylinder(d=D, h=Wall);
        // Bohrung Mitte
        translate([0,0,-0.1]) cylinder(d=Db, h=Wall*2+B+0.2);
        // Mitte Vertiefung
        translate([0,0,Wall-Deep]) cylinder(d=Di+Toll, h=Wall);
        // Waende  Vertiefung
        F=360/(60+1);
        ICut=18;
        for(R=[0:F:360])
            rotate([0,0,R]) translate([Di/2+ICut-Toll/2,-Wall/4-Toll/2,Wall-Deep]) cube([D/2-Di/2-10-ICut+Toll, Wall/2+Toll, Wall]);
        // Befestigungs Bohrung
        for(R=[0:360/3:360])
            rotate([0,0,R]) translate([12,0,-0.1]) cylinder(d=Db,Wall*2);
    }
}

module Closure1A()
{
    $fn=128;
    DR=2;
    rotate_extrude(convexity = 10, angle=10) translate([-D2/2-6.3,0,0])
    {
        square([6.5,2]);
        translate([0,4]) square([4,2]);
        translate([0,0]) square([2,6]);
    }
    translate([-D2/2-6.3,0,0]) cube([6.5,2,6]);
    
}

module Closure1()
{
/*
    for(RR=[-1.75:90:359])
        translate([0,0,B/2+Wall+HE-6]) rotate([0,0,RR])Closure1A();
*/      
    translate([0,0,HH-6]) rotate([0,0,0-1.75])Closure1A();  
    translate([0,0,HH-6]) rotate([0,0,180-1.75])Closure1A();  
    translate([0,0,HH-6]) rotate([0,0,270-1.75])Closure1A();  
}

HE=3;
HH=B/2+Wall*2+HE;   // Halbe breite aussen

module Closure2A()
{
    $fn=128;
    DR=2;
    rotate_extrude(convexity = 10, angle=9.5) translate([-D2/2-6,0,0])
    {
        translate([4.2,0]) square([1.8,2+2+HH]);
        translate([2+1.5,0.6+2+HH]) square([2,1.4]);
        translate([1.5+2,1.3+2+HH]) circle(d=1.4);
    }
    
}

module Closure2()
{
    translate([0,0,0]) rotate([0,0,0-1.75])Closure2A();  
    translate([0,0,0]) rotate([0,0,180-1.75])Closure2A();  
    translate([0,0,0]) rotate([0,0,270-1.75])Closure2A();  
}

module Stender()
{
    BX=10;
    difference()
    {
        // Aussen Scheibe
        cylinder(d=D2, h=HH);
        // Aushölen
        translate([0,0,Wall])cylinder(d=D2-Wall*2, h=HH);
        // Innen Frei
        translate([0,0,-0.1])cylinder(d=D2-Wall*2-20, h=HH);
        // Recheck raus
        Open=20;
        translate([+BX/2+Open,+BX/2+15+Open,Wall]) cube([D2/2, D2/2, B]);
    }
    // Halter für klappe
    translate([0,0,Wall]) rotate_extrude(convexity = 10, angle=360) translate([D2/2-Wall*3,0,0]) square([Wall-0.2,Wall]);

    // Bremse
    difference()
    {
        union()
        {
            translate([0,-BX/2-D2/4,0]) cylinder(d=21+Wall*2,h=Wall+1.5+0.5);
            translate([0,-BX/2+D2/4,0]) cylinder(d=21+Wall*2,h=Wall+1.5+0.5);
        }
        translate([0,-BX/2-D2/4,Wall+1.5]) cylinder(d=21+Wall,h=0.5+0.1);
        translate([0,-BX/2+D2/4,Wall+1.5]) cylinder(d=21+Wall,h=0.5+0.1);
        
    }
    
    // Halter Senkrecht
    translate([-BX/2,-(D2-Wall*2)/2,0]) cube([BX,(D2-Wall*2),Wall]);
    // Halter Wagerecht
    translate([-(D2-Wall*2)/2,-BX/2,0]) cube([(D2-Wall*2),BX,Wall]);
    // Rundung Mitte 
    cylinder(d=15, h=Wall+HE);
    // Loch
    translate([0,0,-0.1]) cylinder(d=Db-0.5, h=HH-0.3);
       
    // Fuss Halter
    difference()
    {
        translate([-20,-D2/2-11,0]) cube([40,Wall*3+Db*2,B/2+Wall*2+HE]);
        translate([-15,-D2/2-6,-0.1]) cylinder(d=Db, h=B/2+Wall*2+HE+0.2);
        translate([15,-D2/2-6,-0.1]) cylinder(d=Db, h=B/2+Wall*2+HE+0.2);
    }

}

module Fuss()
{
    Wall2=1.5;
    Toll=0.2;
    XX=40;
    YY=40;
    HH=13;
    difference()
    {
        // Befestigungs Box
        translate([-XX/2-Wall2,-YY/2-Wall2,0]) cube([XX+Wall2*2,YY+Wall2*2,HH+Wall2]);
        translate([-XX/2-Toll/2,-YY/2-Toll/2,Wall2]) cube([XX+Toll,YY+Toll,HH+Wall2]);
        // Bohrungen
        translate([-15,21+Wall2,Wall2+5.4]) rotate([90,0,0]) cylinder(d=Db, h=XX*2);
        translate([15,21+Wall2,Wall2+5.4]) rotate([90,0,0]) cylinder(d=Db, h=XX*2);
        
    }
    // Fuss
    scale([1,0.8,1]) scale([1,1,1]) cylinder(d=100, h=Wall2);
}

module Schieber()
{
    $fn=256;
    // Aussen Scheibe
    rotate_extrude(convexity = 10, angle=93) translate([D2/2-Wall*2,0,0]) square([Wall-0.2,HH*2-Wall*2]);
    // Griff
    DXY=8;
    rotate([0,0,4])
    difference()
    {
        translate([95,0,HH-Wall]) rotate([90,0,0]) scale([1.5,(HH*2-Wall*2)/10,1]) cylinder(d=10,h=Wall);
        translate([95-Wall/2-DXY,-DXY,0]) cube([DXY,DXY+0.1,HH*2-Wall*2]);
    }
}

//Oben();
//Unten();
/*
Stender();  
Closure1();
*/

/*
mirror([1,0,0])
{
    Stender();
    Closure2();
}
*/

//Fuss();

Schieber();
