include <BOSL2/std.scad>
include <BOSL2/threading.scad>
/* [Bolt params] */
first_bolt_vertical_offset = -28;
first_bolt_horizontal_offset = 0;
add_second_bolt =true;
second_bolt_vertical_offset = 12.5;
second_bolt_horizontal_offset = 0;

/* [Twin slot mounting params] */
//Probably don't need to change these
//Gap between end of upper slot and start of lower slot
slot_gap=15;
//Total height of each slot
slot_gap_height=15;
//How much do the twin slots slide in.
slot_height=8;
//Total Depth of part
mount_depth=14;
//Width of gap between slots
horizontal_slot_gap=8.5;
//thickness of each slot
slot_thickness = 1.75;

module customiser_limit(){}
total_thickness = horizontal_slot_gap + 2*slot_thickness;
mount_height = slot_gap + 2*slot_gap_height;

difference(){
    //Basic shape
    cube([mount_height,mount_depth,total_thickness],center=true);
    //Cut out slot width from middle
    translate([0,-1.01,0])
        cube([mount_height+1,mount_depth-2,horizontal_slot_gap],center=true);
    //Cut out gap between slots
    translate([0,-1.01,0])
        cube([slot_gap,mount_depth-2,total_thickness+1],center=true);
    //Cut out slot inserts
    translate([mount_height/2-slot_height/2+0.01,0,0])
        cube([slot_height,3,total_thickness+1],center=true);
    translate([-slot_gap/2-slot_height/2+0.01,0,0])
        cube([slot_height,3,total_thickness+1],center=true);

}


module bolt(x=0,z=0){
    translate([x,13,z])
    rotate([90,0,0])
    threaded_rod(d=5, l=15, pitch=1.25, $fa=1, $fs=1);
};
//Bolt itself
bolt(first_bolt_vertical_offset,first_bolt_horizontal_offset);

vertical_support_offset= max(first_bolt_vertical_offset,-(mount_height/2 +4.49));
//Bolt additional support
translate([vertical_support_offset,5,0])
    cube([9,4,total_thickness],center=true);

if (add_second_bolt) {
    bolt(second_bolt_vertical_offset,second_bolt_horizontal_offset);
    translate([second_bolt_vertical_offset,5,0])
        cube([9,4,total_thickness],center=true);
};
    
