
// Paul Murray, 2025

// exterior dimensions
d = 70;
l = 90;
h = 25;


// features
fins = 6;
cornerrad = 6;
fincube = 3;

// interior dimensions
wl = l - fincube;
wd = d - fincube;
wh = h - fincube;

finl = wl/fins;


module mainblock() {

translate([cornerrad,0,0])
cube([l-cornerrad*2,d,h]);
translate([0,cornerrad,0])
cube([l,d-cornerrad*2,h]);

for(y = [cornerrad:d-cornerrad*2:d-cornerrad]) 
    for(x = [cornerrad:l-cornerrad*2:l-cornerrad]) 
translate([x,y,0])
    cylinder(h=h, r=cornerrad);

}


// main block with cutouts

difference() {
mainblock();

translate([ (l-wl)/2,
-0.2,
h-wh + 0.2])
{

rotate(90, [1,0,0])
rotate(90, [0,1,0])

linear_extrude(wl)
polygon([

[0,0],
[wd,wh],
[0,wh]

]);

}

}

// fins

intersection() {
    mainblock();

translate([ (l-wl)/2,
-0.2,
h-wh + 0.2])
for(t=[0:1:fins]) translate([t*finl-finl/2,0,0])
hull() 
{
translate([finl/2 - fincube/2,wd-fincube,wh-fincube])
cube(fincube);
translate([finl/2 - fincube/2,0,wh-fincube])
cube(fincube);
translate([fincube/2,0,0])
cube(fincube);
translate([finl-fincube*1.5,0,0])
cube(fincube);
}


}
