// Indexplate for EMCO Unimat 3
// up to 32 division
// 09.11.2025 Peter Kern

da      =     65.0;   //  outer diameter
di      =     14.1;   //  inner diameter
dd      =      4.0;   //  thickness (Original 2.8)

did     =     58.0;   //  bolt circle diameter
id      =      4.0;   //  diameter indexhole
ih      =      3.8;   //  depth (Original 2.1)

$fn     =       64;

// enter number of steps
steps   =       16;   // divider

x=360/steps;
echo(x);

degree = 
        [0,x*1,x*2,x*3,x*4,x*5,x*6,x*7,x*8,x*9,x*10,x*11,x*12,x*13,x*14,x*15,x*16,
        x*17,x*18,x*19,x*20,x*21,x*22,x*23,x*24,x*25,x*26,x*27,x*28,x*29,x*30,x*31,x*32];

difference()
  {
  // Platte
  translate([0,0,0]) cylinder(h=dd, d=da, $fn=128);
  // Hole für Axle
  translate([0,0,-1]) cylinder(h=dd+2, d=di);
  
  // Indexholes
  translate([0,0,0]) 
    for ( y = [+0:1:steps]) rotate([0,0,y*x]) translate([0,did/2,1]) cylinder(h=ih, d1=1, d2=id);

  // Indexmarkings
  translate([0,0,0]) 
    for ( z = [+0:1:steps]) rotate([0,0,z*x]) translate([-0.5,did/2+2,-0.2]) cube([1,2,1]);

  // Lettering for each step
    for ( z = [+0:1:steps-1]) 
      {
      print_text = str((floor(degree[z]*100))/100);
      rotate([0,0,z*x]) translate([-1.5,did/2-5,0.8]) rotate([180,0,90]) linear_extrude(1) text(print_text, 
        font="Osifont", size=3, halign="center");
      }

  // Lettering number of steps on indexplate
  difference()
    {    
    translate([0,12,0]) cube([10.8,5.8,0.8],center=true);
    translate([0,12,0]) cube([10.0,5.0,0.8],center=true);
    }  
  translate([0,10.6,0.8]) rotate([180,0,180]) 
    linear_extrude(1) text(str(steps), font="Osifont", size=3, halign="center", $fn=64);  

  }    
  
  
