post_diameter = 32;
sleeve_thickness = 3;
fin_thickness = 3;
fin_length = 30;
fin_height = 50;
flange_width = 15;
flange_thickness = 3;
total_height = 75;
flange_holes = true;
flange_hole_offset = 0;
flange_hole_radius = 2;
sleeve_holes = false;
sleeve_hole_offset = 0;
sleeve_hole_radius = 2;
tolerance = 1;

post_radius = post_diameter / 2;
sleeve_radius = post_radius + sleeve_thickness;
fin_radius = sleeve_radius + fin_length;
fin_offset = fin_thickness / 2;
flange_length = fin_radius + flange_width / 2;
cutout_size = 2 + max(fin_length, fin_height);
cutout_offset = (cutout_size + fin_thickness) / 2;
cutout_offset_y = cutout_size / 2 - 1;

//create the sleeve by cutting a cylinder matching the post_diameter out of a larger cylinder
difference() {
    $fn = 100;
    union() {
        // create the main sleeve cylinder
        cylinder(total_height,sleeve_radius,sleeve_radius,false);
        
        //add the flanges, with or without screw holes
        
        if (flange_holes) difference() {
            union() {
                translate([-flange_width / 2, -flange_length, 0])
                    cube([flange_width, 2 * flange_length, flange_thickness], false);
                translate([-flange_length, -flange_width/2, 0])
                    cube([2 * flange_length, flange_width, flange_thickness], false);          
            }
            union() {
                translate([0, -(fin_radius + flange_hole_offset), -tolerance])
                    cylinder(h = (flange_thickness + 2 * tolerance), r = flange_hole_radius, center = false);
                translate([0, (fin_radius + flange_hole_offset), -tolerance])
                    cylinder(h = (flange_thickness + 2 * tolerance), r = flange_hole_radius, center = false);
                translate([-(fin_radius + flange_hole_offset), 0, -tolerance])
                    cylinder(h = (flange_thickness + 2 * tolerance), r = flange_hole_radius, center = false);
                translate([(fin_radius + flange_hole_offset), 0, -tolerance])
                    cylinder(h = (flange_thickness + 2 * tolerance), r = flange_hole_radius, center = false);
            }
        } 
        else union() {
            translate([-flange_width / 2, -flange_length, 0])
                cube([flange_width, 2 * flange_length, flange_thickness], false);
            translate([-flange_length, -flange_width/2, 0])
                cube([2 * flange_length, flange_width, flange_thickness], false);
        }
        
        // create the fins from a pyramid with cubes removed
        difference() {
            $fn = 8;
            rotate([0,0,22.5])
                cylinder(fin_height,fin_radius,sleeve_radius,false);
            union() {
                $fn = 100;
                translate([cutout_offset,cutout_offset,cutout_offset_y])
                    cube([cutout_size,cutout_size,cutout_size], true);
                translate([-cutout_offset,cutout_offset,cutout_offset_y])
                    cube([cutout_size,cutout_size,cutout_size], true);
                translate([-cutout_offset,-cutout_offset,cutout_offset_y])
                    cube([cutout_size,cutout_size,cutout_size], true);
                translate([cutout_offset,-cutout_offset,cutout_offset_y])
                    cube([cutout_size,cutout_size,cutout_size], true);
            }        
        }
    }
    // cut the internal cylinder out of the sleeve
    union() {
        translate([0,0,-0.5])
            cylinder(total_height+1,post_radius,post_radius,false);
        // also cut out screw holes, if required
        if (sleeve_holes) union() {
            translate([0, 0, total_height - flange_width / 2 - sleeve_hole_offset])
                rotate([90, 0, 0])
                    cylinder(h = (2 * sleeve_radius + 2 * tolerance), r = sleeve_hole_radius, center = true);
            translate([0, 0, total_height - flange_width / 2 - sleeve_hole_offset])
                rotate([0, 90, 0])
                    cylinder(h = (2 * sleeve_radius + 2 * tolerance), r = sleeve_hole_radius, center = true);

            }
    }
}

