// Wall thickness
wall = 3;
// Interior length main corpus
a = 92;
// Interior width main corpus
b = 92;
// Interior height main corpus
c = 61;
// Interior length arm
d = 40;
// Interior width arm
e = 24;
// Interior height arm
f = 61;
// Width of breakout
g = 20;
// Height of breakout
h = 50;
// Radius inner corner
irad = 3;
// Radius outer corner
orad = 4;

/* Hidden */
eps = 0.001;
$fn = 200;


module roundedcube(x, y, z, rad) {
    translate([-x/2, -y/2, 0]) {
        linear_extrude(height = z) {
            hull() {
                translate([rad, rad, 0]) circle(r = rad);
                translate([x - rad, rad, 0]) circle(r = rad);
                translate([x - rad, y - rad, 0]) circle(r = rad);
                translate([rad, y - rad, 0]) circle(r = rad);
            }
        }
    }
}

module edge(h, rad) {
    difference() {
        cube([rad, rad, h]);
        translate([rad, rad, -eps]) {
            cylinder(h+2*eps, rad, rad);
        }
    }
}

module inner() {
    ext = irad;
    translate([0, 0, -eps]) {
        union() {
            roundedcube(a, b, c+eps, irad);
            translate([(a+d-ext)/2, 0, 0]) {
                roundedcube(d+ext, e, f+eps, irad);
            }
            // Rounded edges
            translate([a/2-eps, e/2-eps, 0]) {
                rotate([0, 0, 0]) {
                    edge(f + eps, orad+2*eps);
                }
            }
            translate([a/2-eps, -e/2+eps, 0]) {
                rotate([0, 0, 270]) {
                    edge(f + eps, orad+2*eps);
                }
            }
            // Breakout
            translate([-(a+wall)/2, 0, h/2-eps]) {
                cube([wall+2*eps, g, h + eps], center=true);
            }
        }
    }
}

module outer() {
    ext = orad;
    union() {
        roundedcube(a+2*wall, b+2*wall, c+wall, orad);
        translate([(a+d-ext)/2, 0, 0]) {
            roundedcube(d+2*wall+ext, e+2*wall, f+wall, orad);
        }
        // Rounded edges
        translate([(a+2*wall)/2, (e+2*wall)/2, 0]) {
            rotate([0, 0, 0]) {
                edge(c + wall, irad);
            }
        }
        translate([(a+2*wall)/2, -(e+2*wall)/2, 0]) {
            rotate([0, 0, 270]) {
                edge(c + wall, irad);
            }
        }
    }
}

module cover() {
    difference() {
        outer();
        inner();
    }
}

cover();
