// clearance dimensions for lid fitment
clcenterpeg = 0; // press fit on center post
clkeyboss = 0.3; // around keyring boss in the corner

// clearance on wheel
clwheel = 0.45; // dia

// view controls
orientforprint = true;
section = false;
zoffset = 10; // used only when orientforprint = false
$fn = 100;

// ////////////////////////////////////////////////////

// section as needed
if (section){
	difference(){
		draw();
		translate([0,-25,0])
			cube([50,50,50],center=true);
	}
}
else{
	draw();
}

// draw everything
module draw(){
	if (orientforprint) {
		// put the exposed face down
		translate([-40,0,2])
			rotate([0,180,-90])
			lid();
		// put the number face down
		translate([40,0,3])
			rotate([0,180,0])
			wheel();
		// put the exposed face down
		rotate([0,0,-90])
			base();
	}
	else{
		// for visualization
		translate([0,0,2*zoffset+5.5])
			rotate([0,0,-90])
			lid();
		translate([0,0,zoffset+2.25])
			wheel();
		rotate([0,0,-90])
			base();
	}
}


module wheel(){
	// n _must_ be an integer multiple of the number of digits on the wheel
	// 20 or 30 works fine for 50% DC; changing DC requires tweaking offset angle
	// but the original 25 means only every other number will line up with the window.
	pcr = 16.7; // pitch circle radius
	n = 20; // number of cycles
	p = [1,1]*1; // order of each half cycle [outer inner]
	s = [1,1]*0.5; // magnitude of each half cycle [outer inner]
	dc = 0.5; // duty cycle
	nph = 20; // points per cycle
	wheelh = 3;
	
	// unfuck the wheel
	// why does everyone throw parts in an STL with random location and rotation?
	// the bottom of the wheel isn't even flat or positioned on z=0 for some reason, and it's not a clearance offset either.  
	// the top is flat and positioned at z=3.  
	// the bottom z-position values are uniformly-distributed random numbers between 6.7E-15 and 1.5E-14.
	// it's curious even for float rounding error.  
	difference(){
		union(){
			intersection(){
				rotate([0,0,-21.0095]) // fix the random rotation
					translate([0,0,3]) // shift back up
					scale([1,1,1.001]) // stretch it a bit so that the bottom gets cut off
					translate([20.0415,44.9895,-3]) // center and orient on top face
					import("original_model_4867466/gc_wheel.stl",convexity = 5); // ugh
				cylinder(r = 16,h = 10,center=false); // chop off the wrong knurling and the irregular bottom
			}
			cylinder(d = 9,h = 3,center=false); // fill the oversize center hole
		}
		cylinder(d = 8+clwheel,h = 10,center=true); // cut a new hole with specified clearance
	}
	
	// replace the knurling part
	difference(){
		translate([0,0,wheelh/2])
			rotate([0,0,360/n/4])
			splilinder(wheelh,pcr,n,p,s,dc,nph);
		cylinder(r = 15.9,h = 10,center=true);
	}
}


module lid(){
	difference(){
		// the bottom face of the lid isn't flat either. it's off by 0.001, 
		// and there's triangulation artifacts from CSG. trim it.
		translate([0,0,2]) // shift back up
			scale([1,1,1.01]) // stretch it a bit so that the bottom gets cut off
			translate([-21.0002,-48.0188,-2]) // center and orient on top face
			import("original_model_4867466/gc_lid.stl",convexity = 5); // ugh
		// trim the bottom artifacts off
		translate([0,0,-50])
			cube([100,100,100],center=true); 
		// provide clearance on keyring boss
		translate([-18,17,0])
			cylinder(d = 10+clkeyboss,h = 10,center=true);
		// provide clearance on center peg
		cylinder(d = 8+clcenterpeg,h = 10,center=true);
		// add a chamfer to the window to make it easier to read
		mg = 1.5;
		hull(){
			translate([0,8.979+7/2,2])
				squilinder([10+2*mg,7+2*mg,0.1],mg);
			translate([-5,8.979,2-mg])
				cube([10,7,0.1]);
		}
	}
}


module base(){
	difference(){
		union(){
			difference(){
				// this is actually flat on the top and bottom, so no shuffling needed
				translate([21.0004,-46.9998,0])
					import("original_model_4867466/gc_base.stl",convexity = 5); // ugh
				// trim off the keychain lug, since we'll have to rebuild it anyway
				translate([-18.9996,12.1024,-1])
					rotate([0,0,51.0388])
					translate([-25,0,0])
					cube([50,50,10]);
			}
			// replace keyring boss
			translate([-18,17,0])
				cylinder(d = 10,h = 7.5,center=false);
		}
		
		// cut bore in keyring boss
		translate([-18,17,0])
			cylinder(d = 6,h = 20,center=true);
		translate([-18,17,5.5])
			cylinder(d1 = 6,d2 = 8,h = 2,center=false);
		translate([-18,17,0])
			cylinder(d1 = 8,d2 = 6,h = 2,center=false);
	}
}











// creates a piecewise power function/sinusoid composition
// around a circular path (sort of like a gear or spline shape)
// pcr: pitch circle radius
// n: number of cycles
// p: order of each half cycle (2-element vector)
// s: magnitude of each half cycle (2-element vector)
// dc: duty cycle (0-1)
// nph: points per half cycle
module splinusoid(pcr, n, p=[1,1], s=[1,1], dc=0.5, nph=$fn) { 
	// calculate some things
	np = 2*nph;

	// generate the radius for one cycle (uniformly-spaced, equal-length half cycles)
	R1 = [for (thh1 = linsegment(0,180,nph)) pcr + s[0]*pow(abs(sin(thh1)),1/p[0]) ];
	R2 = [for (thh2 = linsegment(180,360,nph)) pcr - s[1]*pow(abs(sin(thh2)),1/p[1]) ];
	R = concat(R1,R2);

	// generate a sequence of nonuniformly-spaced angles covering one cycle
	th1 = [for (th = linsegment(0,360/n*dc,nph)) th ];
	th2 = [for (th = linsegment(360/n*dc,360/n,nph)) th ];
	th = concat(th1,th2);
	
	// generate the pointlist and create the pgon
	pointlist = 	[for (k = [0:np*n-1]) 
					getpoint(R[k%np],floor(k/np)*360/n + th[k%np]) ];
	closedpointlist = concat(pointlist,[pointlist[0]]);
	polygon(closedpointlist);

	function getpoint(r,th) = [r*cos(th),r*sin(th)];
}

module splilinder(h, pcr, n, p=[1,1], s=[1,1], dc=0.5, np=360/$fa) { 
	linear_extrude(height = h, center = true, convexity = 10, twist = 0)
		splinusoid(pcr, n, p, s, dc, np);
}

// generate a linear sequence of N values
// starting at A and ending one step size prior to B
// useful for generating adjacent sequence vectors without redundant elements
function linsegment(a,b,n) = 
	[a : (b-a)/n : (a + (b-a)/n*(n-0.5))];

// generate a linear sequence of N values
// starting at A and ending at B
function linspace(a,b,n) = 
	[a : (b-a)/(n-1):  (a + (b-a)/(n-1)*(n-0.5))];

//rounded rectangle extruded on z, like any cylinder
module squilinder(dims,radius,center=false){
	hull(){
		translate([dims[0]/2-radius, dims[1]/2-radius, 0])
			cylinder(r=radius, h=dims[2], center=center);
		translate([-(dims[0]/2-radius), dims[1]/2-radius, 0])
			cylinder(r=radius, h=dims[2], center=center);
		translate([dims[0]/2-radius, -(dims[1]/2-radius), 0])
			cylinder(r=radius, h=dims[2], center=center);
		translate([-(dims[0]/2-radius), -(dims[1]/2-radius), 0])
			cylinder(r=radius, h=dims[2], center=center);
	}
}













































































































































