strap_width=25;

hook_width=strap_width;
hook_height=strap_width*1.6;
hook_depth=14;
screw_diameter=4;

// Rounded edge
module rounded_edge() {
    rotate([0, 90, 0]) {
        difference() {
            cylinder(h=hook_width, r=hook_depth, $fn=128);
            translate([0, -hook_depth, -1]) {
                cube([hook_depth, hook_depth*2, hook_width+2]);
            }
        }
    }
}

module screw() {
    // Screw body
    cylinder(h=hook_depth+2, d=screw_diameter, center = true);
    // Screw head
    translate([0, 0, hook_depth/2 - screw_diameter/2]) {
        cylinder(h=screw_diameter + 0.1, d1=screw_diameter, d2=screw_diameter*2.2, center = true);
    }
}

difference() {
    union() {
        // Main body
        cube([hook_width, hook_height, hook_depth], true);

        // Rounded edges
        translate([-hook_width/2, -hook_height/2, -hook_depth/2]) {
            rounded_edge();
        }
        translate([-hook_width/2, hook_height/2, -hook_depth/2]) {
            rounded_edge();
        }
    }
    // Strap hole
    cube([hook_width+2, strap_width+1, 2], true);
    rotate([0, 90, 0]) {
        translate([0, hook_width/2, 0]) {
            cylinder(h=hook_width+2, d=2, center = true, $fn=64);
        }
        translate([0, -hook_width/2, 0]) {
            cylinder(h=hook_width+2, d=2, center = true, $fn=64);
        }
    }
        
    // Screws holes
    translate([0, -hook_height/2, 0]) {
        screw();
    }
    translate([0, hook_height/2, 0]) {
        screw();
    }
}