/*************************************************************************************
*
* Tools organizer
*
*************************************************************************************
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
* INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
* PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHOR OR COPYRIGHT
* HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
* OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*
* IT IS NOT PERMITTED TO MODIFY THIS COMMENT BLOCK.
*
* (c)2025, Claude "Tryphon" Theroux, Montreal, Quebec, Canada
* http://www.ctheroux.com/
*
*************************************************************************************/

merged_code = true;

// Wall thickness in mm
lct_WallThickness = 2;

// Bucket definitions
// - All dimensions are in mm
// - X is set using the adjacent bucket Upper X value given in the console
// - Y is set using the adjacent bucket Upper Y value given in the console

lct_Buckets = [
    [
        [ "Name", "Chimie" ],
        [ "X", 0 ],
        [ "Y", 0 ],
        [ "InnerWidth", 50 ],
        [ "InnerDepth", 20 ],
        [ "InnerHeight", 80 ]
    ],
    [
        [ "Name", "Tournevis" ],
        [ "X", 0 ],
        [ "Y", 22 ],
        [ "InnerWidth", 50 ],
        [ "InnerDepth", 25 ],
        [ "InnerHeight", 80 ]
    ],
    [
        [ "Name", "Ciseaux" ],
        [ "X", 0 ],
        [ "Y", 49 ],
        [ "InnerWidth", 50 ],
        [ "InnerDepth", 30 ],
        [ "InnerHeight", 80 ]
    ],
    [
        [ "Name", "Couteaux" ],
        [ "X", 0 ],
        [ "Y", 81 ],
        [ "InnerWidth", 50 ],
        [ "InnerDepth", 25 ],
        [ "InnerHeight", 80 ]
    ],
    [
        [ "Name", "Crayons" ],
        [ "X", 0 ],
        [ "Y", 108 ],
        [ "InnerWidth", 50 ],
        [ "InnerDepth", 30 ],
        [ "InnerHeight", 80 ]
    ],
    [
        [ "Name", "Petits outils 1" ],
        [ "X", 0 ],
        [ "Y", 140 ],
        [ "InnerWidth", 50 ],
        [ "InnerDepth", 10 + 1 ],
        [ "InnerHeight", 50 ]
    ],
    
    // -------------
    
    [
        [ "Name", "Spatule" ],
        [ "X", 52 ],
        [ "Y", 0 ],
        [ "InnerWidth", 40 + 2 ],
        [ "InnerDepth", 20 ],
        [ "InnerHeight", 100 ]
    ],
    [
        [ "Name", "Regles" ],
        [ "X", 52 ],
        [ "Y", 22 ],
        [ "InnerWidth", 40 + 2 ],
        [ "InnerDepth", 15 ],
        [ "InnerHeight", 100 ]
    ],
    [
        [ "Name", "Tweezers" ],
        [ "X", 52 ],
        [ "Y", 39 ],
        [ "InnerWidth", 40 + 2 ],
        [ "InnerDepth", 20 ],
        [ "InnerHeight", 80 ]
    ],
    [
        [ "Name", "Multi-tools" ],
        [ "X", 52 ],
        [ "Y", 61 ],
        [ "InnerWidth", 25 ],
        [ "InnerDepth", 90 ],
        [ "InnerHeight", 60 ]
    ],
    
    // -------------
    
    [
        [ "Name", "Calculatrice" ],
        [ "X", 79 ],
        [ "Y", 61 ],
        [ "InnerWidth", 15 ],
        [ "InnerDepth", 80 ],
        [ "InnerHeight", 60 ]
    ],

    [
        [ "Name", "Petits outils 2" ],
        [ "X", 79 ],
        [ "Y", 143 ],
        [ "InnerWidth", 15 ],
        [ "InnerDepth", 8 ],
        [ "InnerHeight", 40 ]
    ],
    
    // -------------
    
    [
        [ "Name", "Loupe" ],
        [ "X", 96 ],
        [ "Y", 0 ],
        [ "InnerWidth", 40 ],
        [ "InnerDepth", 25 ],
        [ "InnerHeight", 60 ]
    ],    
    
    [
        [ "Name", "Flashlight" ],
        [ "X", 96 ],
        [ "Y", 27 ],
        [ "InnerWidth", 20 ],
        [ "InnerDepth", 20 ],
        [ "InnerHeight", 60 ]
    ],    
    
    [
        [ "Name", "Longs outils" ],
        [ "X", 96 ],
        [ "Y", 49 ],
        [ "InnerWidth", 20 ],
        [ "InnerDepth", 70 ],
        [ "InnerHeight", 60 ]
    ],    
    
    [
        [ "Name", "Petits outils 3" ],
        [ "X", 96 ],
        [ "Y", 121 ],
        [ "InnerWidth", 20 ],
        [ "InnerDepth", 30 ],
        [ "InnerHeight", 40 ]
    ],   
    
    // -------------
    
    [
        [ "Name", "Porte-papiers" ],
        [ "X", 118 ],
        [ "Y", 27 ],
        [ "InnerWidth", 18 ],
        [ "InnerDepth", 124 ],
        [ "InnerHeight", 60 ]
    ],     
    
        ];

module __Customizer_Limit__ () {}

/*************************************************************************************
 *
 * Nothing shall be modified below this line
 *
 *************************************************************************************/
 
/*************************************************************************************
 *
 * Library inner parameters
 *
 *************************************************************************************/

// Clearance between a male and a female connector in mm
lct_MaleFemaleConnectorClearance = 0.1;

// Male connector length in mm
lct_MaleConnectorLength = 22;

// Male connector width in mm
lct_MaleConnectorWidth = 12;

// Male connector height in mm
lct_MaleConnectorHeight = 3.5;

// Filament hole diameter in mm
lct_FilamentHoleDiameter = 2.2;


$fn = 60;

function ratio(p_value, p_height) = (p_value - 2 * p_height) / p_value;

// Female connector length in mm
function lct_FemaleConnectorLength(p_length = lct_MaleConnectorLength) = p_length + lct_MaleFemaleConnectorClearance;

// Female connector width in mm
function lct_FemaleConnectorWidth(p_width = lct_MaleConnectorWidth) = p_width + lct_MaleFemaleConnectorClearance;

// Female connector height in mm
function lct_FemaleConnectorHeight(p_height = lct_MaleConnectorHeight) = p_height + lct_MaleFemaleConnectorClearance;

module lct_FilamentAttachmentDump(p_EnableDebug = false, p_length = lct_MaleConnectorLength, p_width = lct_MaleConnectorWidth, p_height = lct_MaleConnectorHeight) {
    if( p_EnableDebug ) {
        echo("vvv LCTFilamentAttachment:lct_FilamentAttachmentDump");
        echo("    lct_FilamentHoleDiameter:", lct_FilamentHoleDiameter);
        echo("    Male connector length:", p_length);
        echo("    Male connector width:", p_width);
        echo("    Male connector height:", p_height);
        echo("    Female connector length with clearance:", p_length + lct_MaleFemaleConnectorClearance);
        echo("    Female connector width with clearance:", p_width + lct_MaleFemaleConnectorClearance);
        echo("    Female connector height with clearance:", p_height + lct_MaleFemaleConnectorClearance);
        echo("    lct_MaleConnectorTopLengthRatio:", ratio(p_length, p_height));
        echo("    lct_MaleConnectorTopWidthRatio:", ratio(p_width, p_height));
        echo("^^^ LCTFilamentAttachment:lct_FilamentAttachmentDump");
    }
}

module lct_MaleConnector(p_length = lct_MaleConnectorLength, p_width = lct_MaleConnectorWidth, p_height = lct_MaleConnectorHeight) {
    difference() {
        linear_extrude(height = p_height, scale = [ ratio(p_length, p_height), ratio(p_width, p_height) ]) square([ p_length, p_width ], true);
    translate([ -p_length / 2, 0, p_height / 2]) rotate([ 0, 90, 0 ]) cylinder(h = p_length, d = lct_FilamentHoleDiameter);
    }
}

module lct_FemaleConnectorKnockout(p_length = lct_MaleConnectorLength + lct_MaleFemaleConnectorClearance, p_width = lct_MaleConnectorWidth + lct_MaleFemaleConnectorClearance, p_height = lct_MaleConnectorHeight + lct_MaleFemaleConnectorClearance) {
    difference() {
        linear_extrude(height = p_height, scale = [ ratio(p_length, p_height), ratio(p_width, p_height) ]) square([ p_length, p_width ], true);
    }
}

/*************************************************************************************
*
* Nothing shall be modified below this line
*
*************************************************************************************/

function lctBSL_GetAttribute(p_Attributes, p_Name) = p_Attributes[search([p_Name], p_Attributes)[0]][1];

module lctBSL_GenerateBucket(p_index, p_bucket_definition) {
    
    name = lctBSL_GetAttribute(p_bucket_definition, "Name");
    innerWidth = lctBSL_GetAttribute(p_bucket_definition, "InnerWidth");
    innerDepth = lctBSL_GetAttribute(p_bucket_definition, "InnerDepth");
    innerHeight = lctBSL_GetAttribute(p_bucket_definition, "InnerHeight");
    
    width = innerWidth + 2 * lct_WallThickness;
    depth = innerDepth + 2 * lct_WallThickness;
    height = innerHeight + lct_WallThickness;

    x = lctBSL_GetAttribute(p_bucket_definition, "X");
    y = lctBSL_GetAttribute(p_bucket_definition, "Y");
    
    echo("Bucket position");
    echo(str("    Bucket No: ", p_index));
    if( ! is_undef(name) ) {
        echo(str("    Name: ", name));
    }
    echo(str("    Lower X: ", x));
    echo(str("    Upper X: ", x + lct_WallThickness + innerWidth));
    echo(str("    Lower Y: ", x));
    echo(str("    Upper Y: ", y + lct_WallThickness + innerDepth));
    
    translate( [ x, y, 0 ] ) difference() {
        cube([ width, depth, height ]);
        translate( [ lct_WallThickness, lct_WallThickness, lct_WallThickness ] ) cube([ innerWidth, innerDepth, innerHeight ]);
    }
} 

module lctBSL_GenerateBuckets(p_buckets, p_index = 0) {
    if( p_index < len(p_buckets) ) {
        x = lctBSL_GetAttribute(p_buckets[p_index], "X");
        y = lctBSL_GetAttribute(p_buckets[p_index], "Y");
        lctBSL_GenerateBucket(p_index, p_buckets[p_index]);
        lctBSL_GenerateBuckets(p_buckets, p_index + 1);
    }
}

function lctBSL_getDepth(p_Buckets, p_Index = 0, p_CurrentMaximum = 0) = p_Index < len(p_Buckets)
                            ? (lctBSL_GetAttribute(p_Buckets[p_Index], "InnerDepth") + lctBSL_GetAttribute(p_Buckets[p_Index], "Y") > p_CurrentMaximum 
                                ? lctBSL_getDepth(p_Buckets, p_Index + 1, lctBSL_GetAttribute(p_Buckets[p_Index], "InnerDepth") + lctBSL_GetAttribute(p_Buckets[p_Index], "Y")) 
                                : lctBSL_getDepth(p_Buckets, p_Index + 1, p_CurrentMaximum)) 
                            : p_CurrentMaximum;

function lctBSL_getWidth(p_Buckets, p_Index = 0, p_CurrentMaximum = 0) = p_Index < len(p_Buckets)
                            ? (lctBSL_GetAttribute(p_Buckets[p_Index], "InnerWidth") + lctBSL_GetAttribute(p_Buckets[p_Index], "X") > p_CurrentMaximum 
                                ? lctBSL_getWidth(p_Buckets, p_Index + 1, lctBSL_GetAttribute(p_Buckets[p_Index], "InnerWidth") + lctBSL_GetAttribute(p_Buckets[p_Index], "X")) 
                                : lctBSL_getWidth(p_Buckets, p_Index + 1, p_CurrentMaximum)) 
                            : p_CurrentMaximum;

union() {
    lctBSL_GenerateBuckets(lct_Buckets);
    
    moduleWidth = lctBSL_getWidth(lct_Buckets) + 2 * lct_WallThickness;
    moduleDepth = lctBSL_getDepth(lct_Buckets) + 2 * lct_WallThickness;
    moduleLeftSideHeight = 60 + lct_WallThickness;
    
    echo(str("*** Module Width: ", moduleWidth));
    echo(str("*** Module Depth: ", moduleDepth));

    // Male connectors
    translate( [ 0, 30, 40 ] ) rotate( [ 90, 90, -90 ] ) lct_MaleConnector();
    translate( [ 0, moduleDepth - 30, 40 ] ) rotate( [ 90, 90, -90 ] ) lct_MaleConnector();
   
    // Female connectors
    translate( [ moduleWidth, 0, 0 ] ) difference() {
        cube([ lct_FemaleConnectorHeight(),  moduleDepth, moduleLeftSideHeight ]); 
     
        translate( [ lct_FemaleConnectorHeight(), 30, 40] ) rotate( [ 90, 90, -90 ] ) lct_FemaleConnectorKnockout();
        translate( [ lct_FemaleConnectorHeight(), moduleDepth - 30, 40] ) rotate( [ 90, 90, -90 ] ) lct_FemaleConnectorKnockout();
        
        translate( [ lct_FemaleConnectorHeight() / 2, 30, 0 ] ) cylinder(h = moduleLeftSideHeight, d = lct_FilamentHoleDiameter);
        translate( [ lct_FemaleConnectorHeight() / 2, moduleDepth - 30, 0 ] ) cylinder(h = moduleLeftSideHeight, d = lct_FilamentHoleDiameter);
    }
}