radius = 325;
length = 300;

holder_thickness = 3;
pen_radius = 4.5;

holder_height = 30;
holder_bottom_thickness = 1;

hole_radius = pen_radius;
hole_diameter = 2*hole_radius;
holder_radius = hole_radius+holder_thickness;
holder_diameter = 2*holder_radius;
holder_distance = holder_diameter - holder_thickness;

function degree_from_radian(radian) = 180*radian/PI;
function degree_from_size(s) = degree_from_radian(s/radius);

module to_polar(r,phi) { rotate([0,0,phi]) translate([r,0,0]) children(); }
module up(d) { translate([0,0,d]) children(); }

pen_count = floor((length-holder_thickness)/holder_distance);
echo(pen_count=pen_count);

pens = [for(i = [0:pen_count-1]) i];
first_angle = degree_from_size(holder_radius);
angles = [for(i=pens) first_angle+i*degree_from_size(holder_distance)];

intermediate_pens = [for(i = [0:pen_count-2]) i];
first_intermediate_angle = degree_from_size(holder_radius+holder_distance/2);   
intermediate_angles = [for(i=intermediate_pens) first_intermediate_angle+i*degree_from_size(holder_distance)];
delta_r = holder_distance*sin(60);

module shape()
{
  for(angle = angles) 
    to_polar(radius, angle) 
      cylinder(h=holder_height, r = holder_radius);
  for(angle = intermediate_angles) 
    to_polar(radius+delta_r, angle) 
      cylinder(h=2*holder_height, r = holder_radius);
  for(angle = angles) 
    to_polar(radius+2*delta_r, angle) 
      cylinder(h=3*holder_height, r = holder_radius);
}

module holes()
{
  for(angle = angles) 
    to_polar(radius, angle)
      up(holder_bottom_thickness)
        cylinder(h=holder_height, r = hole_radius);
  for(angle = intermediate_angles) 
    to_polar(radius+delta_r, angle)
      up(holder_bottom_thickness+holder_height)
        cylinder(h=holder_height, r = hole_radius);
  for(angle = angles) 
    to_polar(radius+2*delta_r, angle)
      up(holder_bottom_thickness+2*holder_height)
        cylinder(h=holder_height, r = hole_radius);
}

difference()
{
  shape();
  holes();
}
