radius = 325;
length = 300;

holder_thickness = 3;
pen_radius = 4.5;

holder_height = 30;
holder_bottom_thickness = 1;

hole_radius = pen_radius;
hole_diameter = 2*hole_radius;
holder_radius = hole_radius+holder_thickness;
holder_diameter = 2*holder_radius;
holder_distance = holder_diameter - holder_thickness;

function degree_from_radian(radian) = 180*radian/PI;
function degree_from_size(s) = degree_from_radian(s/radius);

module to_polar(r,phi) { rotate([0,0,phi]) translate([r,0,0]) children(); }
module up(d) { translate([0,0,d]) children(); }

module arc(radius, width, height, startAngle, endAngle)
{
  rotate([0,0,startAngle])
    rotate_extrude(angle=endAngle-startAngle, $fn=360)
      translate([radius-width/2,0]) square([width, height]);
}

module hole(radius, angle, height)
{
  to_polar(radius, angle)
    up(holder_bottom_thickness+height)
      cylinder(h=holder_height, r = hole_radius);

}

module holder(radius, angle, height)
{
  to_polar(radius, angle) 
    cylinder(h=height, r = holder_radius);
}

pen_count = floor((length-holder_thickness)/holder_distance);
echo(pen_count=pen_count);

pens = [for(i = [0:pen_count-1]) i];
first_angle = degree_from_size(holder_radius);
delta_angle = degree_from_size(holder_distance);
angles = [for(i=pens) first_angle+i*delta_angle];
last_angle = first_angle + (pen_count-1)*delta_angle;
delta_r = holder_distance;
min_angle=0;
max_angle=degree_from_size((pen_count-1)*holder_distance+holder_diameter);

intermediate_pens = [for(i = [0:pen_count-2]) i];
first_intermediate_angle = degree_from_size(holder_radius+holder_distance/2);   
intermediate_angles = [for(i=intermediate_pens) first_intermediate_angle+i*delta_angle];
delta_r_interleaved = holder_distance*sin(60);
last_intermediate_angle = first_intermediate_angle + (pen_count-2)*delta_angle;
intermediate_min_angle = first_intermediate_angle-degree_from_size(holder_radius);
intermediate_max_angle = last_intermediate_angle+degree_from_size(holder_radius);

module cylinders_shape()
{
  for(angle = angles) 
    holder(radius, angle, holder_height);
  for(angle = intermediate_angles) 
    holder(radius+delta_r_interleaved, angle, 2*holder_height);
  for(angle = angles) 
    holder(radius+2*delta_r_interleaved, angle, 3*holder_height);
}

module cylinders_holes()
{
  for(angle = angles) 
    hole(radius, angle, 0);
  for(angle = intermediate_angles) 
    hole(radius+delta_r_interleaved, angle, holder_height);
  for(angle = angles) 
    hole(radius+2*delta_r_interleaved, angle, 2*holder_height);
}

module lots_of_cylinders()
{
  difference()
  {
    cylinders_shape();
    cylinders_holes();
  }
}

//lots_of_cylinders();

module custom_row(radius, height, start, end)
{
  first_angle = start + degree_from_radian(holder_radius/radius);
  last_angle = end -  degree_from_radian(holder_radius/radius);
  
  arc(radius, holder_diameter, height, first_angle, last_angle);
  holder(radius, first_angle, height);
  holder(radius, last_angle, height);
}

module row(radius, height)
{
  custom_row(radius, height, min_angle, max_angle);
}

module flat_shape()
{
  row(radius, holder_height);
  arc(radius+delta_r, 2*delta_r, holder_height, min_angle, max_angle);
  row(radius+delta_r, 2*holder_height);
  arc(radius+1.5*delta_r, delta_r, 2*holder_height, min_angle, max_angle);
  row(radius+2*delta_r, 3*holder_height);
}

module flat()
{
  difference()
  {
    flat_shape();
    for(angle = angles) 
    {
      hole(radius, angle, 0);
      hole(radius+delta_r, angle, holder_height);
      hole(radius+2*delta_r, angle, 2*holder_height);
    }
  }
}

module flat2_shape()
{
  row(radius, holder_height);
  arc(radius+delta_r, 2*delta_r, holder_height, min_angle, max_angle);
  custom_row(radius+delta_r, 2*holder_height, intermediate_min_angle, intermediate_max_angle);
  arc(radius+1.5*delta_r, delta_r, 2*holder_height, intermediate_min_angle, intermediate_max_angle);
  row(radius+2*delta_r, 3*holder_height);
}

module flat2()
{
  difference()
  {
    flat2_shape();
    for(angle = angles) 
    {
      hole(radius, angle, 0);
      hole(radius+2*delta_r, angle, 2*holder_height);
    }
    for(angle = intermediate_angles)
      hole(radius+delta_r, angle, holder_height);
  }
}

//flat();
//flat2();
lots_of_cylinders();
