// Hole and wire dimensions (customizable)
hole_diameter = 40;         // Diameter of the mounting hole
wire_diameter = 8;          // Diameter of the wire pass-through channel
panel_thickness = 4;        // Thickness of the panel/surface with the hole

// Wall thickness parameters
WALL_THICKNESS = 3;         // Main wall thickness
THIN_WALL_THICKNESS = 1.5;  // Thin base wall thickness

// Rendering quality
$fn = 60;

module grommet_pos() {
    cylinder(h = THIN_WALL_THICKNESS, r = hole_diameter / 2 + WALL_THICKNESS);

    cylinder(h = THIN_WALL_THICKNESS + panel_thickness, r = hole_diameter / 2);
}

module grommet_neg() {
    translate([0, 0, WALL_THICKNESS + THIN_WALL_THICKNESS])
        hull()
            rotate_extrude()
                translate([hole_diameter / 2 - WALL_THICKNESS * 2, 0])
                    circle(r = WALL_THICKNESS);

    translate([hole_diameter / 2 - WALL_THICKNESS - wire_diameter / 2, 0, 0])
        hull() {
            cylinder(h = THIN_WALL_THICKNESS + panel_thickness, r = wire_diameter / 2);
            translate([hole_diameter / 2, 0, 0])
                cylinder(h = THIN_WALL_THICKNESS + panel_thickness, r = wire_diameter / 2);
        }
}

difference() {
    grommet_pos();
    grommet_neg();
}
