#include <LEDs.h>
#include <DHT.h>
#include <MotorController.h>

// LED Object Initiation
LEDs OnLED(10,"Green LED");
LEDs OffLED(11,"Red LED");

// DHT 11 Module Initiation
#define DHT_DataPin 4
#define DHT_Type DHT11
DHT dht(DHT_DataPin, DHT_Type);

// Fan Object Initiation
int MasterSpeedPin = 5;
int SlaveSpeedPin = 6;
MotorController SlaveFan(7,14,255,0,"Slave Motor");
MotorController MasterFan(8,14,255,0,"Master Motor");


// Potentiometer Pin
int PotPin = A7;
int PotV = 5; // Volts
int SpeedVoltage = 255; // 8bit 0 - 255

// Temperature Settings
int TurnOnTemp = 30; // Celsius
int TurnOnPot = 1; // Volts

// Delay Parameters
int tDelay = 500;

void setup(){
  Serial.begin(9600);               // Starting the serial for debugging and console outputs 
  dht.begin();                      // Tells the DHT module to start measuring humidity and temperature
  analogWrite(MasterSpeedPin, 255);       // Set the fan speed voltage to 5v.
  analogWrite(SlaveSpeedPin, 255);
  MasterFan.initMotor();                  // Initiatalise motor(s) to check it works
  SlaveFan.initMotor();

}

void loop() {
  delay(tDelay);
  float tempC = dht.readTemperature();            // Reads temperature from DHT module
  float Humidity = dht.readHumidity();            // Reads humidity from DHT module
  float PotV = 5.0*analogRead(PotPin)/1024.;
  
  Serial.println();

  SpeedVoltage = 255.0*round(10*PotV/5.0)/10;

  if(PotV > TurnOnPot){
    analogWrite(MasterSpeedPin, SpeedVoltage);
    analogWrite(SlaveSpeedPin, SpeedVoltage);
    if (isnan(Humidity) || isnan(tempC)){
      Serial.println(" | Failed to read from DHT11 sensor!");
      OnLED.BlinkLED();
      OffLED.BlinkLED();
    } 
    else{
      OnLED.LEDOn(1);
      OffLED.LEDOff();
      if(tempC > TurnOnTemp){
        MasterFan.MotorForward();
        SlaveFan.MotorForward();
      }
      else{
        MasterFan.MotorOff();
        SlaveFan.MotorOff();
      }
    }
  }
  else{
    analogWrite(MasterSpeedPin, 0);
    analogWrite(SlaveSpeedPin, 0);
    OffLED.LEDOn(1);
    OnLED.LEDOff();
  }

  Serial.print("Fan Speed: ");
  Serial.print(100*SpeedVoltage/255.0);
  Serial.print("%");

  Serial.print("  |  "); 

  Serial.print("Fan State: ");
  Serial.print(MasterFan.getMotorState());

  Serial.print("  |  "); 

  Serial.print(" | DHT11# Humidity: ");
  Serial.print(Humidity);
  Serial.print("%");

  Serial.print("  |  "); 

  Serial.print("Temperature: ");
  Serial.print(tempC);
  Serial.print("°C ");
}
