/*
  MotorController.h - Library for creating and controlling 2 Motors through a L298N motor drive controller.
  Created by Sam Dicker on 09.08.2024
*/

#ifndef MotorController_h
#define MotorController_h

#include "Arduino.h"

class MotorController{
    private:
      int PosPin;
      int NegPin;
      int MotorState;
      int MotorSpeed;
      int RampTime;
      String Name;

    public:
      MotorController(int PosPin = 15, int NegPin = 16, int MotorSpeed = 255, int RampTime = 0, String Name = "Unnamed Motor");

      // Begin
      void initMotor();

      // Set Parameters
      void setPosPin(int);
      void setNegPin(int);
      void setMotorState(int);
      void setMotorSpeed(int);
      void setRampTime(int);
      void setName(String);

      // Get Parameters
      int getPosPin();
      int getNegPin();
      int getMotorState();
      int getMotorSpeed();
      int getRampTime();
      String getName();

      // Class Functions
      void MotorForward();
      void MotorBackward();
      void MotorOff();
};

#endif