/*******************************************************************************
  Cylinder Storage Case

  Original credit to goes to konejavihannes and their design:
    https://www.thingiverse.com/thing:5226549

  This file is for the parametrized creation of the Cylinder Storage Lid

******************************************************************************/

use <cylinder_storage_modules.scad>

//Cylinder Diameter
cylinder_diameter = 12;

//Cylinder Height
cylinder_height = 44;

//Column Count
col_count = 4;

//Wall Thickness
wall_thickness = 0.2;

//Curve Detail
curve_detail = 50;

//Lid Tolerance
lid_tolerance = 1.2;

//Debug
debug = false;

$fn = curve_detail;

cylinder_storage_lid(cylinder_diameter, cylinder_height, col_count, wall_thickness, lid_tolerance);

if (debug){
    translate([0, 0,cylinder_height/2]){
        debug_refrerence_shapes(cylinder_diameter, cylinder_height, col_count, wall_thickness);
    }
    color("blue"){
        translate([0,cylinder_diameter*2 ,cylinder_height/2]){
            cylinder(d=cylinder_diameter, h=cylinder_height, center=true);
        }
    }
}