// length of the shortest bridge
min_bridge_length = 10;

// length of the longest bridge
max_bridge_length = 100;

// difference between subsequent bridges
bridge_increment = 20;

// width of each bridge
bridge_width = 8;

// distance between each pilar
bridge_delta = 1;

// height of the supporting plate
support_height = 1;

// support offset around the pillars
support_offset = 1;

// distance between bridge and support/build plate
bridge_z = 3;

// height of the bridging block
bridge_height = 2;

// depth of each pilar
pilar_depth = 5;

// ignore
numBridges = ceil((max_bridge_length - min_bridge_length) / bridge_increment) + 1;
// ignore
$fn = 50;

module pilars_start()
{
    for (i=[0:numBridges-1])
    {
        translate([i * (bridge_width + bridge_delta), 0, support_height])
        {
            cube([bridge_width, pilar_depth, bridge_z]);
        }
    }
}

module pilars_end()
{
    for (i=[0:numBridges-1])
    {
        translate([i * (bridge_width + bridge_delta), 0, support_height])
        {
            actual_bridge_length = min_bridge_length + i * bridge_increment;
            translate([0, actual_bridge_length + pilar_depth])
            {
                cube([bridge_width, pilar_depth, bridge_z]);
            }
        }
    }
}

module bridges() 
{
    union()
    {
        pilars_start();
        pilars_end();
    }
    
    for (i=[0:numBridges-1])
    {
        actual_bridge_length = min_bridge_length + i * bridge_increment;
        translate([i * (bridge_width + bridge_delta), 0, support_height + bridge_z])
        {
            cube([bridge_width, actual_bridge_length + pilar_depth * 2, bridge_height]);
        }
    }
}

if(support_height > 0)
{
    linear_extrude(height=support_height)
    {
        offset(support_offset)
        {
            hull()
            {
                projection()
                {
                    pilars_start();
                }
            }
            
            hull()
            {
                projection()
                {
                    pilars_end();
                }
            }
        }
    }
}

bridges();