// An Olight update to the clasic ceramic christmas tree
A=20;
$fa=.5;
$fs=.5;


/*
    Creating a new base for a ceramic christmas tree that incorporates the
    Olight sphere as the ilumination element 
    The goal is to incorperate elements that shine the light inside the tree
    and onto the base as well
    
    part value is set to the following values
    0, this is the complete base as it would look after assembly
    1, a combination of the show base and tree trunk
    2, the tree and Olight sphere mount assembly positioned for printing
    3, the tree trunk ready for printing in brown
    4, the base of the unit for printing in white
*/

FestiveBase(part=4);
module FestiveBase(part=0)
{
    $fn=90;
    module shape(t=1)
    {
        if(t==1){
            rotate([15,5,0])cylinder(d=5,1);
        }
    }
    *shape(1);

    *difference(){
        for(i=[0:5:360]){
            single_rand = rands(0,10,1)[0];
            //echo(single_rand/10);
            rotate([0,0,i])scale([rands(0,10,1)[0]*.8,rands(0,10,1)[0]*.8,rands(0,10,1)[0]*.2])shape(1);
        }
        translate([0,0,-8])cylinder(d=60,8);
        
    }
    module ringaround(angle, radius) {
       for (a = [0 : angle: 360]){
         rotate([0,0,a])translate([ radius, 0, 0 ]) children(0);
       }
    }
    module Base()
    {
        scale([.6,.6,.7]){
            ringaround(24, 85){ rotate([0,15,0])scale([1,1,.2])sphere(25);}
            translate([0,0,12])rotate([0,0,12])ringaround(24, 53){ rotate([0,15,0])scale([1,1,.2])sphere(25);}
            translate([0,0,17])ringaround(15,20){rotate([0,-8,0])cylinder(38,12,8);}
            translate([0,0,-8])cylinder(d=218,2);
        }
    }
    module Mount()
    {
        difference(){
            cylinder(d=74,2);
            for(i=[0:1:359/A])rotate([0,0,i*A])translate([35,0,-1])scale([2,.6,1])wedge(T=1);
            for(i=[0:1:359/A])rotate([0,0,i*A])translate([24,0,-.2])scale([2.5,1,1])cylinder(d=6.5,3);
        }
    }
    module Holder()
    {
        translate([0,0,-54])scale([1,1,1.4])difference(){
            translate([0,0,28.5])VentTop();
            translate([0,0,24])cylinder(d=85,15);
        }
    }
    if(part==0){
        Base();
        translate([0,0,38])Mount();
        translate([0,0,38])Holder();
    }else if(part==1){
        Base();
    }else if(part==2){
        Mount();
        Holder();
    }else if(part==3){
        translate([0,0,-13.75])intersection(){
                Base();
                translate([0,0,13.75])cylinder(d=38,24.24); 
        }
    }else if(part==4){
        translate([0,0,5.60])
        intersection(){
            Base();
            translate([0,0,-5.95])cylinder(d=186,20);
        }
    }
}


// The top that holds the Olight sphere and the tree
// depending upon the bottom opening of the ceramic tree this may need 
// a diameter adjustment to fit the hole in the tree bottom
module VentTop()
{
    difference(){        
        union(){
            cylinder(d=80,1.5);
            translate([0,0,1.5])cylinder(40,65/2,45/2);
            translate([0,0,1])cylinder(d=65,10.5);
        }
        translate([0,0,1.4])cylinder(40.5,62/2,42/2);
        translate([0,0,-.2])cylinder(d=50,3);
        for(i=[0:1:359/A])rotate([0,0,i*A])translate([35,0,-1])scale([1,.9,1])wedge();
            

    }
}

//This is the cutout portion that makes the slots in the VentTop
module wedge(T=0)
{
    module shape(t=0)
    {
        if(t==0){
            translate([0,-2.5,0])rotate([0,0,-10])cube([12,6,.1],true);
            translate([0,2.5,0])rotate([0,0,10])cube([12,6,.1],true);
            translate([4,0,0])cube([5,6,.2],true);
        }else{
            translate([0,-2.5,0])rotate([0,0,0])cube([12,6,.1],true);
            translate([0,2.5,0])rotate([0,0,0])cube([12,6,.1],true);
            translate([4,0,0])cube([5,4,.2],true);
        }
    }
    
    hull(){
        shape(T);
        translate([0,0,15])shape();
        translate([-11,0,36])cube([7,1.5,.1],true);
    }
}
    

