/*

 from the thingiverse submission

This is a third attempt to make an attractive ornament by reducing the number of
triangles in an stl file.  See thing:7204113 - Simple Bird Ornaments and
thing:7210391 - Simple Rabbit Ornaments.

It's a remix of thing 3004519 "Long Haired Terrier" a highly detailed
model. The STL file for the terrier contains nearly 100,000 triangles.

The earlier attempts at making attractive ornaments perhaps carried simplification
too far.  The original STL file in this attempt was simplified to an STL file
with 150 triangles, 77 vertices, and 225 edges, "terrier_ascii.stl".
Its relation to the original STL file is apparent.

 The ornament was pierced by a tapered hollow cylinder which can
hold a thin wire to serve as a hanger making "terrier_holed.stl".  "terrier_edged.stl"
is a similar version where the edges of the triangles are decorated with cylinders.

"terrier_original_holed.stl" is a copy of the original file which includes a tapered
hollow cylinder so that it can be hung as an ornament for comparison.


   The calls below create the 4 stl submitted to thingiverse - Note that terrier.stl
   was downloaded from thing:3004519 and needs to be in the same directory
   with the scad code when running module hole_terrier_orig().


   remove the // and execute the calls one at a time to
   create the stl files




   Two other modules which might be of interest -


    wire_frame(edges,points,rb,fc);
    spheres(points,rb,fc);

   use the sets of vertices and triangles included at the end of the code
   to run them



 PCM  November 2025

*/

 // polyhedron(cords,triangles);       //  makes terrier_ascii.stl
 // hole();                           //   makrs terrier_holed.stl
 //  edge_hole();                     //   makes terrier_edged.stl
 // hole_terrier_orig();              // makes  terrier_orig_holed.stl

module wire_frame(edges,points,rb,fc)
{

/* edges -  list of bonds - to make cylinders for
   points - list of coordinates - that edges points to
   rb = radius of cylinders - fc - $fn for cylinders
*/

for (i = [0:len(edges)-1])
{
pp = points[edges[i][0]];
qq = points[edges[i][1]];
tx = (qq[0] + pp[0])/2;
ty = (qq[1] + pp[1])/2;
tz = (qq[2] + pp[2])/2;
ax = qq[0] - pp[0] ;
ay = qq[1] - pp[1];
az = qq[2] - pp[2];
translate(v=[tx,ty,tz])
rotate(a = [-acos(az/sqrt(ax*ax+ay*ay+az*az)), 0, -atan2(ax, ay)])
cylinder(r=rb,h=sqrt(ax*ax+ay*ay+az*az),center=true,$fn=fc);
}
}

module spheres(points,rb,fc)
{
// rb = radius of spheres - fc - $fn for spheres
 for (i = [0:len(points) - 1])
{
 pp = points[i];
 tx = pp[0];
 ty = pp[1];
 tz = pp[2];
 translate(v=[tx,ty,tz])
 sphere(r=rb,$fn=fc);
 }
}



module hole()
{
 // union()
 difference()
{
polyhedron(cords,triangles);
 // change the x and y translations to position the cylinder
translate([-5,9,5])
tubes();
 }}




module hole_terrier_orig()
{
 // union()
  difference()
{
import("terrier.stl");
 // change the x and y translations to position the cylinder
translate([0,8,3])
tubes();
 }}



module edge_hole()
{
 // union()
 difference()
{
 union()
{
polyhedron(cords,triangles);
// wire_frame(bonds_no_base,cords,1,8);
wire_frame(bonds,cords,0.6,8);
// spheres(cords,1.25,8);
}
union()
{
 // change the x and y translations to position the cylinder
// translate([17,15,-2])
translate([-5,9,5])
tubes();
translate([15,1,-1])
 rotate([0,0,-30])
cube([110,65,2],center=true);
 }}}



module tubes()
{
    union()
    {
 color("red")
cylinder(r=1,h=75,$fn=12);
color("yellow")
cylinder(r=1.33,h=40,$fn=12);
color("green")
cylinder(r=1.66,h=35,$fn=12);
color("blue")
cylinder(r=2,h=30,$fn=12);
    }
}



  cords = [
 [ -0.934604,-9.024701,11.769280    ],  [ -1.382419,22.754786,0.345218     ],
 [ -10.661551,34.848614,28.034178   ],  [ -12.264639,2.257183,40.144344    ],
 [ -12.915610,-1.687484,16.708096   ],  [ -13.030404,37.784542,5.436217    ],
 [ -14.637569,14.358021,7.405025    ],  [ -16.699852,14.262410,-0.002827   ],
 [ -16.939468,28.022320,40.544956   ],  [ -18.041620,19.281696,44.495945   ],
 [ -19.679028,34.925629,20.894543   ],  [ -20.075996,27.840858,-0.010208   ],
 [ -21.560638,22.153301,6.823984    ],  [ -23.393671,22.156868,56.172047   ],
 [ -23.494587,3.784180,11.762189    ],  [ -24.431519,1.373823,0.060350     ],
 [ -25.723074,24.580940,28.619484   ],  [ -26.675615,27.590397,48.953957   ],
 [ -28.341377,14.685362,36.387794   ],  [ -28.867435,6.530092,22.965273    ],
 [ -3.392873,31.365713,29.293348    ],  [ -31.312922,18.494743,24.513762   ],
 [ -33.789902,10.594287,0.154129    ],  [ -4.125052,29.299128,10.589334    ],
 [ -4.802019,-9.119134,32.362404    ],  [ -6.093691,18.411293,9.468335     ],
 [ -6.955307,38.681023,-0.010982    ],  [ 1.502760,21.392012,36.983730     ],
 [ 10.297702,-7.888359,7.110605     ],  [ 11.364575,-23.753387,-0.000417   ],
 [ 12.110124,0.802610,53.697922     ],  [ 12.401622,-22.407068,58.145885   ],
 [ 13.831980,2.237685,70.431763     ],  [ 14.503985,-18.949144,76.653847   ],
 [ 15.810512,-24.066830,7.679002    ],  [ 15.888916,-10.369883,0.000541    ],
 [ 16.833551,15.873436,32.844444    ],  [ 17.300924,-21.383024,37.309017   ],
 [ 17.307713,-25.039732,24.074270   ],  [ 17.562967,-0.792029,78.397263    ],
 [ 2.738760,9.019988,7.113696,      ],  [ 20.567842,-30.154760,66.539909   ],
 [ 21.857273,-19.731216,71.405472   ],  [ 22.496115,11.683615,8.058683     ],
 [ 22.723909,2.928734,4.889866      ],  [ 22.865335,-27.602215,55.645210   ],
 [ 24.253698,5.832225,48.346424     ],  [ 25.633881,-21.103409,50.682350   ],
 [ 26.007078,-19.352535,10.231408   ],  [ 27.983707,5.076239,70.773727     ],
 [ 28.128466,-23.210375,0.002891    ],  [ 29.255983,-11.233716,2.946377    ],
 [ 29.303143,-8.026019,78.292244    ],  [ 30.056736,8.319990,-0.014933     ],
 [ 30.288376,10.266156,26.404411    ],  [ 31.049500,-23.104176,75.737679   ],
 [ 32.548470,3.175681,51.543579     ],  [ 32.601162,-18.405846,34.271374   ],
 [ 32.861984,-25.697422,59.759644   ],  [ 33.905979,-22.029278,45.457981   ],
 [ 35.291821,-1.752555,37.621765    ],  [ 38.040180,-3.124985,23.022978    ],
 [ 38.183010,-10.239448,0.048969    ],  [ 38.248238,-11.049560,40.897602   ],
 [ 38.821297,-7.658334,73.409782    ],  [ 39.124294,1.100809,11.738339     ],
 [ 39.263245,-4.630311,57.574772    ],  [ 39.474865,-14.809043,64.824394   ],
 [ 40.645142,-6.675875,86.708023    ],  [ 44.587044,0.022191,0.119058      ],
 [ 5.661411,0.505534,46.083164      ],  [ 6.134416,-16.382784,31.989248    ],
 [ 7.830833,0.919119,84.508499      ],  [ 8.478395,-17.169024,6.853674     ],
 [ 9.407959,-9.456302,69.145241     ],  [ 9.571865,19.661757,18.919277     ],
 [ 9.953366,-15.766092,50.767902    ],
    ];


  triangles = [
 [   5 ,   2 , 10 ],   [   5 ,  20 ,  2 ],   [  26 ,  23 ,  5 ],
 [  54 ,  46 , 36 ],   [  65 ,  43 , 53 ],   [  54 ,  43 , 65 ],
 [  40 ,  28 , 44 ],   [  28 ,  51 , 44 ],   [  44 ,  51 , 53 ],
 [  44 ,  53 , 43 ],   [  53 ,  69 , 65 ],   [  54 ,  65 , 61 ],
 [  46 ,  60 , 56 ],   [  54 ,  60 , 46 ],   [  60 ,  54 , 61 ],
 [  28 ,  35 , 51 ],   [   1 ,  23 , 26 ],   [  44 ,  43 , 40 ],
 [  25 ,  75 , 23 ],   [  25 ,  40 , 75 ],   [  36 ,  27 , 75 ],
 [  40 ,  43 , 75 ],   [  20 ,   5 , 23 ],   [  27 ,   8 , 20 ],
 [  27 ,  20 , 23 ],   [  54 ,  36 , 43 ],   [  75 ,  43 , 36 ],
 [  27 ,  23 , 75 ],   [  39 ,  49 , 52 ],   [  27 ,  70 ,  8 ],
 [  39 ,  52 , 33 ],   [  68 ,  52 , 49 ],   [  27 ,  36 , 70 ],
 [  32 ,  39 , 72 ],   [  49 ,  46 , 56 ],   [  70 ,  46 , 30 ],
 [  32 ,  30 , 46 ],   [  32 ,  49 , 39 ],   [  70 ,  36 , 46 ],
 [  32 ,  46 , 49 ],   [  72 ,  74 , 32 ],   [  30 ,  32 , 74 ],
 [  72 ,  39 , 74 ],   [  64 ,  49 , 56 ],   [  64 ,  56 , 66 ],
 [  64 ,  68 , 49 ],   [  60 ,  66 , 56 ],   [  33 ,  74 , 39 ],
 [  69 ,  62 , 65 ],   [  50 ,  48 , 51 ],   [  65 ,  62 , 51 ],
 [  50 ,  51 , 35 ],   [  59 ,  63 , 57 ],   [  51 ,  57 , 61 ],
 [  65 ,  51 , 61 ],   [  57 ,  60 , 61 ],   [  63 ,  60 , 57 ],
 [  48 ,  38 , 37 ],   [  37 ,  57 , 48 ],   [  57 ,  51 , 48 ],
 [  66 ,  59 , 67 ],   [  66 ,  60 , 63 ],   [  67 ,  64 , 66 ],
 [  59 ,  66 , 63 ],   [  42 ,  55 , 58 ],   [  42 ,  58 , 41 ],
 [  52 ,  64 , 55 ],   [  47 ,  57 , 37 ],   [  52 ,  68 , 64 ],
 [  47 ,  45 , 58 ],   [  59 ,  57 , 47 ],   [  58 ,  59 , 47 ],
 [  33 ,  52 , 42 ],   [  42 ,  52 , 55 ],   [  64 ,  67 , 55 ],
 [  59 ,  58 , 67 ],   [  58 ,  55 , 67 ],   [  20 ,   8 ,  2 ],
 [  16 ,  10 ,  8 ],   [  16 ,  12 , 10 ],   [  18 ,  16 ,  8 ],
 [  10 ,  12 , 11 ],   [  18 ,  17 , 13 ],   [  21 ,  18 , 19 ],
 [  12 ,  21 , 22 ],   [  18 ,  21 , 16 ],   [   6 ,  11 , 12 ],
 [   8 ,  17 , 18 ],   [   5 ,  10 , 11 ],   [   8 ,  10 ,  2 ],
 [   5 ,  11 , 26 ],   [  12 ,  16 , 21 ],   [  22 ,   7 , 12 ],
 [  17 ,   9 , 13 ],   [  17 ,   8 ,  9 ],   [  18 ,  13 ,  9 ],
 [  28 ,   4 ,  0 ],   [   0 ,  73 , 28 ],   [   0 ,   4 , 24 ],
 [  73 ,  29 , 35 ],   [  35 ,  28 , 73 ],   [  73 ,   0 , 71 ],
 [  71 ,   0 , 24 ],   [   3 ,  70 , 24 ],   [  71 ,  24 , 70 ],
 [  25 ,  23 ,  1 ],   [   3 ,  14 , 19 ],   [   6 ,  15 , 14 ],
 [  15 ,  22 , 14 ],   [   4 ,  14 ,  3 ],   [   4 ,   3 , 24 ],
 [  25 ,   4 , 40 ],   [  40 ,   4 , 28 ],   [  19 ,  18 ,  3 ],
 [  18 ,   9 ,  3 ],   [   4 ,  25 ,  6 ],   [  14 ,   4 ,  6 ],
 [  22 ,  21 , 14 ],   [  14 ,  21 , 19 ],   [   6 ,  25 ,  1 ],
 [   6 ,   1 , 11 ],   [  12 ,   7 ,  6 ],   [   6 ,   7 , 15 ],
 [  74 ,  33 , 31 ],   [  74 ,  31 , 76 ],   [  76 ,  71 , 70 ],
 [  74 ,  76 , 30 ],   [  76 ,  70 , 30 ],   [  71 ,  76 , 37 ],
 [  70 ,   9 ,  8 ],   [  70 ,   3 ,  9 ],   [  31 ,  41 , 45 ],
 [  45 ,  41 , 58 ],   [  31 ,  47 , 76 ],   [  45 ,  47 , 31 ],
 [  47 ,  37 , 76 ],   [  33 ,  42 , 31 ],   [  38 ,  34 , 73 ],
 [  73 ,  34 , 29 ],   [  34 ,  48 , 50 ],   [  73 ,  71 , 38 ],
 [  38 ,  71 , 37 ],   [  34 ,  38 , 48 ],   [  41 ,  31 , 42 ],
 [   1 ,  26 , 11 ],   [  15 ,   7 , 22 ],   [  53 ,  62 , 69 ],
 [  35 ,  29 , 50 ],   [  53 ,  51 , 62 ],   [  29 ,  34 , 50 ],
  ];




  bonds = [
 [   0 ,   4 ],  [   0 ,  24 ],  [   0 ,  28 ],  [   0 ,  71 ],
 [   0 ,  73 ],  [   1 ,   6 ],  [   1 ,  11 ],  [   1 ,  23 ],
 [   1 ,  25 ],  [   1 ,  26 ],  [   2 ,   5 ],  [   2 ,   8 ],
 [   2 ,  10 ],  [   2 ,  20 ],  [   3 ,   4 ],  [   3 ,   9 ],
 [   3 ,  14 ],  [   3 ,  18 ],  [   3 ,  19 ],  [   3 ,  24 ],
 [   3 ,  70 ],  [   4 ,   6 ],  [   4 ,  14 ],  [   4 ,  24 ],
 [   4 ,  25 ],  [   4 ,  28 ],  [   4 ,  40 ],  [   5 ,  10 ],
 [   5 ,  11 ],  [   5 ,  20 ],  [   5 ,  23 ],  [   5 ,  26 ],
 [   6 ,   7 ],  [   6 ,  11 ],  [   6 ,  12 ],  [   6 ,  14 ],
 [   6 ,  15 ],  [   6 ,  25 ],  [   7 ,  12 ],  [   7 ,  15 ],
 [   7 ,  22 ],  [   8 ,   9 ],  [   8 ,  10 ],  [   8 ,  16 ],
 [   8 ,  17 ],  [   8 ,  18 ],  [   8 ,  20 ],  [   8 ,  27 ],
 [   8 ,  70 ],  [   9 ,  13 ],  [   9 ,  17 ],  [   9 ,  18 ],
 [   9 ,  70 ],  [  10 ,  11 ],  [  10 ,  12 ],  [  10 ,  16 ],
 [  11 ,  12 ],  [  11 ,  26 ],  [  12 ,  16 ],  [  12 ,  21 ],
 [  12 ,  22 ],  [  13 ,  17 ],  [  13 ,  18 ],  [  14 ,  15 ],
 [  14 ,  19 ],  [  14 ,  21 ],  [  14 ,  22 ],  [  15 ,  22 ],
 [  16 ,  18 ],  [  16 ,  21 ],  [  17 ,  18 ],  [  18 ,  19 ],
 [  18 ,  21 ],  [  19 ,  21 ],  [  20 ,  23 ],  [  20 ,  27 ],
 [  21 ,  22 ],  [  23 ,  25 ],  [  23 ,  26 ],  [  23 ,  27 ],
 [  23 ,  75 ],  [  24 ,  70 ],  [  24 ,  71 ],  [  25 ,  40 ],
 [  25 ,  75 ],  [  27 ,  36 ],  [  27 ,  70 ],  [  27 ,  75 ],
 [  28 ,  35 ],  [  28 ,  40 ],  [  28 ,  44 ],  [  28 ,  51 ],
 [  28 ,  73 ],  [  29 ,  34 ],  [  29 ,  35 ],  [  29 ,  50 ],
 [  29 ,  73 ],  [  30 ,  32 ],  [  30 ,  46 ],  [  30 ,  70 ],
 [  30 ,  74 ],  [  30 ,  76 ],  [  31 ,  33 ],  [  31 ,  41 ],
 [  31 ,  42 ],  [  31 ,  45 ],  [  31 ,  47 ],  [  31 ,  74 ],
 [  31 ,  76 ],  [  32 ,  39 ],  [  32 ,  46 ],  [  32 ,  49 ],
 [  32 ,  72 ],  [  32 ,  74 ],  [  33 ,  39 ],  [  33 ,  42 ],
 [  33 ,  52 ],  [  33 ,  74 ],  [  34 ,  38 ],  [  34 ,  48 ],
 [  34 ,  50 ],  [  34 ,  73 ],  [  35 ,  50 ],  [  35 ,  51 ],
 [  35 ,  73 ],  [  36 ,  43 ],  [  36 ,  46 ],  [  36 ,  54 ],
 [  36 ,  70 ],  [  36 ,  75 ],  [  37 ,  38 ],  [  37 ,  47 ],
 [  37 ,  48 ],  [  37 ,  57 ],  [  37 ,  71 ],  [  37 ,  76 ],
 [  38 ,  48 ],  [  38 ,  71 ],  [  38 ,  73 ],  [  39 ,  49 ],
 [  39 ,  52 ],  [  39 ,  72 ],  [  39 ,  74 ],  [  40 ,  43 ],
 [  40 ,  44 ],  [  40 ,  75 ],  [  41 ,  42 ],  [  41 ,  45 ],
 [  41 ,  58 ],  [  42 ,  52 ],  [  42 ,  55 ],  [  42 ,  58 ],
 [  43 ,  44 ],  [  43 ,  53 ],  [  43 ,  54 ],  [  43 ,  65 ],
 [  43 ,  75 ],  [  44 ,  51 ],  [  44 ,  53 ],  [  45 ,  47 ],
 [  45 ,  58 ],  [  46 ,  49 ],  [  46 ,  54 ],  [  46 ,  56 ],
 [  46 ,  60 ],  [  46 ,  70 ],  [  47 ,  57 ],  [  47 ,  58 ],
 [  47 ,  59 ],  [  47 ,  76 ],  [  48 ,  50 ],  [  48 ,  51 ],
 [  48 ,  57 ],  [  49 ,  52 ],  [  49 ,  56 ],  [  49 ,  64 ],
 [  49 ,  68 ],  [  50 ,  51 ],  [  51 ,  53 ],  [  51 ,  57 ],
 [  51 ,  61 ],  [  51 ,  62 ],  [  51 ,  65 ],  [  52 ,  55 ],
 [  52 ,  64 ],  [  52 ,  68 ],  [  53 ,  62 ],  [  53 ,  65 ],
 [  53 ,  69 ],  [  54 ,  60 ],  [  54 ,  61 ],  [  54 ,  65 ],
 [  55 ,  58 ],  [  55 ,  64 ],  [  55 ,  67 ],  [  56 ,  60 ],
 [  56 ,  64 ],  [  56 ,  66 ],  [  57 ,  59 ],  [  57 ,  60 ],
 [  57 ,  61 ],  [  57 ,  63 ],  [  58 ,  59 ],  [  58 ,  67 ],
 [  59 ,  63 ],  [  59 ,  66 ],  [  59 ,  67 ],  [  60 ,  61 ],
 [  60 ,  63 ],  [  60 ,  66 ],  [  61 ,  65 ],  [  62 ,  65 ],
 [  62 ,  69 ],  [  63 ,  66 ],  [  64 ,  66 ],  [  64 ,  67 ],
 [  64 ,  68 ],  [  65 ,  69 ],  [  66 ,  67 ],  [  70 ,  71 ],
 [  70 ,  76 ],  [  71 ,  73 ],  [  71 ,  76 ],  [  72 ,  74 ],
 [  74 ,  76 ],    ];
