
#include <IRremote.h>
#include <Servo.h> // Bibliothek zum Ansteuern von Servos

#define irPin 3

int steer = 90; // Servo in die Mitte stellen
int Power = 104; // Motor aus
int Leerlauf = 104; //Motor aus
int Lenkmitte = 109;
int maxLinks = 72; //maximaler Lenkeinschlag nach links
int maxRechts = 128; //maximaler Lenkeinschlag nach rechts

IRrecv irrecv(irPin);
decode_results results;
Servo servoblau; // Lenkservo
Servo Power_C; // Antriebsservo
 
void setup() {
   
  Serial.begin(9600);
  irrecv.enableIRIn();
  servoblau.attach(4); // Servos initialisieren
  Power_C.attach(5);
  Power_C.write (104);
}
 
void loop() {
  
   if (irrecv.decode(&results)) {
      Serial.println(results.value);
      
      switch (results.value) {
        
         case 16722135:            // button 2 FORDWARD
            forward();
            break;

         case 16750695:            // button 4 LEFT
            left();
            break;
               
         case 16718055:            // button 5 STOP
            Stop();
            break;

         case 16734375:            // button 6 RIGHT
            right();
            break;
 
         case 16713975:            // button 8 BACK
            back();
            break;
 
         case 16746615:            // button gelb Rückwärts links
            left_back();
            break;

         case 16730295:            // button purpur Rückwärts rechts
            right_back();
            break;

         case 16752735:
            Leerlauf == Leerlauf++;
            Stop();
            break;

         case 16720095:
            Leerlauf == Leerlauf--;
            Stop();
            break;

         case 16716015:
            Lenkmitte == Lenkmitte++;
            Stop();
            break;

         case 16748655:
            Lenkmitte == Lenkmitte--;
            Stop();
            break;
         
         }      
   irrecv.resume();
   }
}

void forward()
{
  //Motor ansteuern
  Power_C.write(0);
  delay (15);
  //Lenkservo ansteuern
  servoblau.write(109);
  
}

void back()
{
  //Motor ansteuern
  Power_C.write(180);
  delay (15);
  //Lenkservo ansteuern
  servoblau.write(109);

}

void left()
{
  //Motor ansteuern
  Power_C.write(0);
  delay (15);
  //Lenkservo ansteuern
  servoblau.write(maxLinks);

}

void right()
{
  //Motor ansteuern
  Power_C.write(0);
  delay (15);
  //Lenkservo ansteuern
  servoblau.write(maxRechts);

} 

void left_back()
{
  //Motor ansteuern
  Power_C.write(180);
  delay (15);
  //Lenkservo ansteuern
  servoblau.write(maxLinks);

}

void right_back()
{
  //Motor ansteuern
  Power_C.write(180);
  delay (15);
  //Lenkservo ansteuern
  servoblau.write(maxRechts);

}

void Stop()
{
  //Motor ansteuern
  Power_C.write(Leerlauf);
  //Lenkservo ansteuern
  //servoblau.write(105);

}
