
module dilate(r) {
    minkowski() {
        children();
        sphere(r);
    }
}

module dilate2d(r) {
    minkowski() {
        children();
        circle(r);
    }
}

module erode(r) {
    module hull_enlarged() {
        minkowski() {
            children();
            cube(1, center=true);
        }
    }
    difference() {
        children();
        dilate(r) {
            difference() {
                hull_enlarged() children();
                children();
            }
        }
    }
}

module erode2d(r) {
    module hull_enlarged() {
        minkowski() {
            children();
            square(1, center=true);
        }
    }
    difference() {
        children();
        dilate2d(r) {
            difference() {
                hull_enlarged() children();
                children();
            }
        }
    }
}
