# Weights in Gramm
Engel60 =	4.81
Engel80 =	8.58
Arm3 = 	4.90
Arm2 =	2.79
Arm1 =	1.49


a2l = 140
a3l = 217.9

a2ratio = .44373
l1 = a2ratio * (2 * Engel60 + Arm1) + 0.5 * a2ratio * (a2ratio * Arm2)
r1 = (1-a2ratio) * Engel80 + 0.5 * (1-a2ratio) * (1-a2ratio) * Arm2

print(l1, r1, a2l*a2ratio, a2l*(1-a2ratio))

a3ratio = .34037

l2 = a3ratio * (2 * Engel60 + Engel80 + Arm1 + Arm2) + 0.5 * a3ratio * (a3ratio * Arm3)
r2 = (1-a3ratio) * (2 * Engel60 + Arm1) + 0.5 * (1-a3ratio) * (1-a3ratio) * Arm2

print(l2, r2, a3l*a3ratio, a3l*(1-a3ratio))

# Transform the equation so it has the quadratic form ax2+bx+c=0ax2+bx+c=0 by bringing all terms to one side: l2−r2=0l2−r2=0.
# Coefficients for a3ratio^2, a3ratio, and constant term after rearranging (l2 - r2 = 0)
a = 0.5 * Arm3 - 0.5 * Arm2  # coefficient of a3ratio^2 (from both sides expansion)
b = (2*Engel60+Arm1) + 2*0.5*Arm2 + (2*Engel60+Engel80+Arm1+Arm2)	# coefficient of a3ratio
c = -(2*Engel60+Arm1) - 0.5*Arm2	# constant term when rearranged

# Using numpy.roots to find roots of a3ratio:
import numpy as np
coeff = [a, b, c]
print("\t", coeff)
roots = np.roots(coeff)
print("\tRoots for a3ratio:", roots)

