// Laster cutter/engraver coin jig
// xtool F1 plate holes are M3 on 25mm centers
// xtool F1 Ultra plate holes are M4 on 35mm centers

/* [Plate] */
plate_thickness = 2.5;

// ignored for oneCoinOnly
gap_x = 10;
// ignored for oneCoinOnly
gap_y = 10;


// extra space on plate edges, ignored for oneCoinOnly
pad_x = 0;
// extra space on plate edges, ignored for oneCoinOnly
pad_y = 0;

bottom_plate = false;
oneCoinOnly = true;

/* [Coins] */
coin_diameter = 40;
coin_slop = .18;
bevel_bottom = true;

// ignored for oneCoinOnly
num_coins_x = 3;
// ignored for oneCoinOnly
num_coins_y = 3;

alignment_ticks = true;

finger_grip = true;

/* [Mounting Holes] */
hole_diameter = 4;
hole_slop = .22;

hole_spacing = 35;

// ignored for oneCoinOnly
hole_offset_x = 0;
// ignored for oneCoinOnly
hole_offset_y = 0;

$fn=720;

hull = true;

/* [Hidden] */
plate_x = num_coins_x * (coin_diameter + gap_x) + 2 * pad_x;
plate_y = num_coins_y * (coin_diameter + gap_y) + 2 * pad_y;

tick_w = .8;

if (oneCoinOnly) {
  oneCoinOnly();
 } else {
  multiCoin();
 }

module oneCoinOnly() {
  if(bottom_plate) {
    translate([coin_diameter/2 + hole_spacing, coin_diameter/2 + hole_spacing, -plate_thickness]) {
      difference() {
        if(hull) {
          //hull() {  // we don't actually hull() here, because in this case it can only increase the amount of plastic used.
          cylinder(r=(hole_spacing >= 35 ? .71 : .74)*coin_diameter, h= plate_thickness - .01);

          translate([0, hole_spacing, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);

          translate([0, -hole_spacing, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);

          translate([-hole_spacing, 0, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);

          translate([hole_spacing, 0, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);
          //}
        } else {
          cylinder(r=hole_spacing + 1.5*hole_diameter, h= plate_thickness + .001);
        }

        translate([-coin_diameter/2 - hole_spacing, -coin_diameter/2 - hole_spacing, bottom_plate ? -plate_thickness -.2 : 0])
          linear_extrude(h = plate_thickness + (bottom_plate ? plate_thickness + .21: 0)) {
          mountingHolesOneCoin();
        }
      }
    }
  }
  translate([coin_diameter/2 + hole_spacing, coin_diameter/2 + hole_spacing, 0]) {
    difference() {
      if(hull) {
        hull() {
          cylinder(r=(hole_spacing >= 35 ?.71 : .74)*coin_diameter, h= plate_thickness - .01);

          translate([0, hole_spacing, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);
          translate([0, -hole_spacing, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);
          translate([-hole_spacing, 0, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);
          translate([hole_spacing, 0, 0])
            cylinder(d=2*hole_diameter, h=plate_thickness - .01);
        }
      } else {
        cylinder(r=hole_spacing + 1.5*hole_diameter, h= plate_thickness - .01);
      }

      translate([-coin_diameter/2 + (hole_spacing < 35 ? 6 : 14.4), coin_diameter/2 + (hole_spacing < 35 ? 1 : 4),
                 plate_thickness -.5]) {
        linear_extrude(h=1) {
          text("TOP", size = (hole_spacing < 35 ? 3 : 4));
        }
      }
      cylinder(d2=coin_diameter + coin_slop, d1=coin_diameter + coin_slop + (bevel_bottom ? coin_slop : 0),
               h = plate_thickness + .01);

      if(alignment_ticks) {
        // top
        translate([-tick_w/2, coin_diameter/2 - tick_w/2])
          cube([tick_w, tick_w*2, plate_thickness + .01]);
        // bot
        translate([-tick_w/2, -coin_diameter/2 - 2*tick_w])
          cube([tick_w, tick_w*2, plate_thickness + .01]);
        // left
        translate([coin_diameter/2 - tick_w/2, tick_w/2])
          cube([2*tick_w, tick_w, plate_thickness + .01]);
        // right
        translate([-coin_diameter/2 - 2*tick_w, tick_w/2])
          cube([2*tick_w, tick_w, plate_thickness + .01]);
      }

      if(finger_grip) {
        hull() {
          cylinder(d=24, h= 4);
          translate([coin_diameter/2*.65, -coin_diameter/2 * .65, 0])
            cylinder(d1=15, d2=20, h= 4);
        }
      }

      translate([-coin_diameter/2 - hole_spacing, -coin_diameter/2 - hole_spacing, bottom_plate ? -plate_thickness -.2 : 0])
        linear_extrude(h = plate_thickness + (bottom_plate ? plate_thickness + .2: 0)) {
        mountingHolesOneCoin();
      }
    }
  }
}


module multiCoin() {
  if(bottom_plate) {
    translate([0, 0, -plate_thickness]) {
      difference() {
        cube([plate_x, plate_y, plate_thickness + .001]);
        mountingHoles();
      }
    }
  }

  difference() {
    cube([plate_x, plate_y, plate_thickness]);
    for(i = [0:1:num_coins_x ]) {
      for(j = [0:num_coins_y ]) {
        translate([(gap_x + coin_diameter)/2 + i * (coin_diameter + gap_x) + pad_x,
                   (gap_y + coin_diameter)/2 + j * (coin_diameter + gap_y) + pad_y, -.01]) {
          cylinder(d=coin_diameter + coin_slop, plate_thickness+ .03);
          if(alignment_ticks) {
            linear_extrude(h = plate_thickness + .01) {
              // top
              translate([-tick_w/2, coin_diameter/2 - tick_w/2])
                square([tick_w, 2]);

              // bot
              translate([-tick_w/2, -coin_diameter/2 - 2*tick_w])
                square([tick_w, 2]);
            
              // left
              translate([coin_diameter/2 - tick_w/2, tick_w/2])
                square([2, tick_w]);

              // right
              translate([-coin_diameter/2 - 2*tick_w, tick_w/2])
                square([2, tick_w]);
            }
          }
          if(finger_grip) {
            hull() {
              cylinder(d=24, h= 4);
              translate([coin_diameter/2*.65, -coin_diameter/2 * .65, 0])
                cylinder(d1=15, d2=20, h= 4);
            }
          }
        }
      }         
    }

    mountingHoles();
  }
}

module mountingHoles() {
  for(i = [gap_x + hole_offset_x:hole_spacing:plate_x]) {
    for(j = [gap_y + hole_offset_y:hole_spacing:plate_y]) {
      translate([i, j, -.01]) {
        cylinder(d=hole_diameter + hole_slop, h=plate_thickness + .02);
      }
    }
  }
}

module mountingHolesOneCoin() {
  for(i = [coin_diameter/2:hole_spacing:hole_spacing * 3 + coin_diameter/2 - .01]) {
    for(j = [coin_diameter/2:hole_spacing:hole_spacing * 3 + coin_diameter/2 - .01]) {
      translate([i, j]) {
        circle(d=hole_diameter + hole_slop);
      }
    }
  }
}
