/*
 * Wire Cutter Rig (WIRC) 
 * For more details visit: http://www.oomlout.com/serb 
 * 
 * Behaviour: 
 *
 * Wiring: 
 *
 * License: This work is licenced under the Creative Commons 
 *          Attribution-Share Alike 3.0 Unported License. To 
 *          view a copy of this licence, visit 
 *          http://creativecommons.org/licenses/by-sa/3.0/ 
 *          or send a letter to Creative Commons, 171 Second 
 *          Street, Suite 300, San Francisco, California 94105, 
 *          USA.
 *         
*/ 
 
#include <Servo.h>

//Distance Variables
float cutterToSnipper = 64;
float stripLength = 7;
float pullLength = 2;

int globalDelay = 100;
int bigDelay = 100;

//Switch variables
#define GOSWITCH 7
#define CUTTERSWITCH 12
#define SNIPPERSWITCH 11

//Relay Variables
#define ONSNIPPER 2
#define DIRECTIONSNIPPER 3

#define FORWARD HIGH
#define BACKWARD LOW

#define OPEN HIGH
#define CLOSE LOW


#define ON HIGH
#define OFF LOW

//Servo variables

#define KNIFEPIN 10
#define ROTATEPIN 9

#define OPENANGLE 10
#define CLOSEDANGLE 1
#define PULLANGLE 2

#define ONEROTATIONCUTTER 6500


#define SNIPPERSAFETYTIME 2000
#define SNIPPEROPENTIME 800
#define SNIPPEREXTRATIME 0


#define FORWARD 180
#define STOPPED 90
#define BACKWARD 0

Servo knifeServo; 
Servo rotateServo; 

//Stepper Motor Variables
#define STATEFORWARD 1
#define STATEREVERSE 0
 
#define WIREDIR 19
#define WIRESTEP 18

#define STICKERDIR 17
#define STICKERSTEP 16

int stepsPerRevWire = 400;
float wirePerRev = 88;
float wirePerStep;

int stepsPerRevSticker = 400;
float stickerPerRev = 31.4;
float stickerPerStep;

int stickerDelayTime = 500;
int wireDelayTime = 2500;

int pulseTime = 25;


//Button input Variables
#define NUMBER1A 14
#define NUMBER1B 14
#define NUMBER1C 14

#define NUMBER2A 14
#define NUMBER2B 14
#define NUMBER2C 14

#define BUTTADVANCE 14
#define STICKERADVANCE 14



//Gets everything up and running
void setup()                  
{
  knifeServo.attach(KNIFEPIN);
  rotateServo.attach(ROTATEPIN);
   
  wirePerStep = wirePerRev / (float)stepsPerRevWire;
  stickerPerStep = stickerPerRev / (float)stepsPerRevSticker;  
  Serial.begin(9600);                //Starts the serial port

  pinMode(WIRESTEP, OUTPUT);
  pinMode(WIREDIR, OUTPUT);
 
  pinMode(STICKERSTEP, OUTPUT);
  pinMode(STICKERDIR, OUTPUT);
 
  pinMode(ONSNIPPER, OUTPUT);
  pinMode(DIRECTIONSNIPPER, OUTPUT);
 
  pinMode(GOSWITCH, INPUT);  digitalWrite(GOSWITCH, HIGH);
  pinMode(CUTTERSWITCH, INPUT);  digitalWrite(CUTTERSWITCH, HIGH);
  pinMode(SNIPPERSWITCH, INPUT);  digitalWrite(SNIPPERSWITCH, HIGH);  
  
  pinMode(STICKERADVANCE, INPUT);  digitalWrite(STICKERADVANCE, HIGH);
  pinMode(BUTTADVANCE, INPUT);  digitalWrite(BUTTADVANCE, HIGH);
  
  pinMode(NUMBER1A, INPUT);  digitalWrite(NUMBER1A, HIGH);
  pinMode(NUMBER1B, INPUT);  digitalWrite(NUMBER1B, HIGH);
  pinMode(NUMBER1C, INPUT);  digitalWrite(NUMBER1C, HIGH);
        
  pinMode(NUMBER2A, INPUT);  digitalWrite(NUMBER2A, HIGH);
  pinMode(NUMBER2B, INPUT);  digitalWrite(NUMBER2B, HIGH);
  pinMode(NUMBER2C, INPUT);  digitalWrite(NUMBER2C, HIGH);


  primeSnipper();
  delay(bigDelay);
  primeCutter();
  delay(bigDelay);
  primeMachine();
  delay(bigDelay);
}

boolean run = false;

//The main program loop
void loop()                     
{
  while(!digitalRead(GOSWITCH) && !run){
    digitalWrite(14, HIGH);
  }
  run = true;
   makePiece(60);
  delay(bigDelay);
}

void primeMachine(){
 retractWire(cutterToSnipper);
}

void makePiece(int length){
  Serial.print("MAKING PIECE OF LENGTH ");
  Serial.print(length);
  Serial.println(" mm"); 
  advanceWire(stripLength);
  delay(globalDelay);
  cut();
  delay(globalDelay);
  advanceWire(length-(stripLength * 2));
  delay(globalDelay);
  cut();
  advanceWire(stripLength);
  delay(globalDelay);
  advanceWire(cutterToSnipper);
  snipWire();
  
  retractWire(cutterToSnipper);
}

void makePieceSpecial(int length){
  Serial.print("MAKING PIECE OF LENGTH ");
  Serial.print(length);
  Serial.println(" mm"); 
  advanceWire(stripLength);
  delay(globalDelay);

  closeKnife();
  rotateCutter(FORWARD, 2);
  delay(globalDelay);
  
  pullKnife();
  delay(globalDelay);
  retractWire(pullLength);
  delay(globalDelay);
   
  advanceWire(pullLength);
  delay(globalDelay);
 
  rotateCutter(BACKWARD, 2);
  delay(globalDelay);
  openKnife();
  delay(globalDelay);
  
  advanceWire(pullLength);
  delay(globalDelay);
  
  advanceWire(length-(stripLength * 2));
  delay(globalDelay);
  cut();
  advanceWire(stripLength);
  delay(globalDelay);
  advanceWire(cutterToSnipper+3);
  snipWire();
  
  retractWire(cutterToSnipper);
}



void cut(){
  Serial.println("CUT");
  closeKnife();
  rotateCutter(FORWARD, 2);
  delay(globalDelay);

  rotateCutter(BACKWARD, 2);
  delay(globalDelay);
  openKnife();

}

void cutAndPull(){
  Serial.println("CUT AND PULL");
  closeKnife();
  rotateCutter(FORWARD, 2);
  pullKnife();
  retractWire(pullLength);
  delay(globalDelay * 5);
  openKnife();
  delay(globalDelay * 5);
  advanceWireForCut();
  rotateCutter(BACKWARD, 2);  
}


void advanceWireForCut(){
  
 advanceWire(cutterToSnipper - stripLength);
 Serial.println("WIREADVANCED FOR SNIP");
 delay(globalDelay*5);
 
 retractWire(cutterToSnipper - stripLength); 
 delay(globalDelay);
}

void openKnife(){
    Serial.println("KNIFE OPEN");
 knifeServo.write(OPENANGLE);
}

void closeKnife(){
    Serial.println("KNIFECLOSED");
   knifeServo.write(CLOSEDANGLE);
}

void pullKnife(){
    Serial.println("KNIFE PULL");
   knifeServo.write(PULLANGLE);
}

void stopRotation(){
    rotateServo.write(90);;
}

void primeSnipper(){
  Serial.println("Snipper Priming...");
  closeSnipper();
  openSnipper();
}

void snipWire(){
  Serial.println("SNIPPING WIRE");
  closeSnipper();
  delay(globalDelay);
  openSnipper();
  delay(globalDelay);
}

void closeSnipper(){
    Serial.println("CLOSING SNIPPER");
    long elapsedTime = millis();
    while(digitalRead(SNIPPERSWITCH) && (millis() - elapsedTime) < SNIPPERSAFETYTIME){
    digitalWrite(DIRECTIONSNIPPER, CLOSE);
    digitalWrite(ONSNIPPER, ON);
  }    
    delay(SNIPPEREXTRATIME);
    digitalWrite(ONSNIPPER, OFF);
}



void openSnipper(){
    Serial.println("OPENING SNIPPER");  
    digitalWrite(DIRECTIONSNIPPER, OPEN);
    digitalWrite(ONSNIPPER, ON);
    delay(SNIPPEROPENTIME);
    digitalWrite(ONSNIPPER, OFF);
}


void primeCutter(){
  Serial.println("PRIMING CUTTER...");
  openKnife();
  long elapsedTime = millis();
  while(digitalRead(CUTTERSWITCH) && (millis() - elapsedTime) < ONEROTATIONCUTTER){
    rotateServo.write(FORWARD);
  }
  rotateServo.write(STOPPED);

}

void rotateCutter(int direc, int rotations){
 for(int i = 0; i < rotations; i++){  
    rotateServo.write(direc);
      delay(1000);
      long elapsedTime = millis();
    while(digitalRead(CUTTERSWITCH) && (millis() - elapsedTime) < ONEROTATIONCUTTER){
      rotateServo.write(direc);
    }    
      rotateServo.write(STOPPED);
  }
}

int getWireLength(){
  int number1 = (4 - digitalRead(NUMBER1C) * 4) + (2 - digitalRead(NUMBER1B) * 2) + (1 - digitalRead(NUMBER1A));
  int number2 = (4 - digitalRead(NUMBER2C) * 4) + (2 - digitalRead(NUMBER2B) * 2) + (1 - digitalRead(NUMBER2A));
  return (number2 * 10) + number1;
  
}

void advanceSticker(int length){
  float steps = (float)length / stickerPerStep;
  moveMotor(STICKERSTEP, STICKERDIR, STATEFORWARD, steps, stickerDelayTime);  
}


void moveWire(int direc, int length){
 if(direc = FORWARD){advanceWire(length);} 
  if(direc = BACKWARD){retractWire(length);}
}

void advanceWire(int length){
  float steps = (float)length / wirePerStep;
  Serial.println(steps, DEC);
  moveMotor(WIRESTEP, WIREDIR, STATEFORWARD, steps, wireDelayTime);  
}

void retractWire(int length){
  float steps = (float)length / wirePerStep;
  Serial.println(steps, DEC);
  moveMotor(WIRESTEP, WIREDIR, STATEREVERSE, steps, wireDelayTime);  
}


void moveMotor(int stepPin, int directionPin, int moveDirection, int steps, int delayTime){
   digitalWrite(directionPin, moveDirection); 
   for(int i = 0; i < steps; i++){
      pulsePin(stepPin, pulseTime);
      delayMicroseconds(delayTime);
   }   
}


void pulsePin(int pin, int time){
  digitalWrite(pin, HIGH);
  delayMicroseconds(time);
  digitalWrite(pin, LOW);
}


//TESTING ROUTINES
void testKnifeAngles(){
 for(int i = 0; i < 180; i++){
  knifeServo.write(i);
  Serial.println(i);
  delay(500);
  
 } 
}
