package BABO;
import java.awt.Container;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;

import javax.swing.JFrame;

public class BaBoFrame extends JFrame implements WindowListener {
	
	private static final long serialVersionUID = 28169340453480657L;

	private static int DEFAULT_FPS = 3;

	private BaBoPanel ivGamePanel;

	public BaBoFrame(ArrayList<Tile> tiles) {
		this(((long) 1000.0 / DEFAULT_FPS) * 1000000L, tiles);
	}
	
	public BaBoFrame(long period, ArrayList<Tile> tiles) {
		super("DefaultGameFramework");
		
		Container c = getContentPane();
		ivGamePanel = new BaBoPanel(null,period, tiles);
		c.add(ivGamePanel, "Center");

		addWindowListener(this);
		pack();
		setResizable(false);
		setVisible(true);
		setLocationRelativeTo(null);
	}

	public void windowActivated(WindowEvent e) {
		ivGamePanel.resumeGame();
	}

	public void windowDeactivated(WindowEvent e) {
		ivGamePanel.pauseGame();
	}

	public void windowDeiconified(WindowEvent e) {
		ivGamePanel.resumeGame();
	}

	public void windowIconified(WindowEvent e) {
		ivGamePanel.pauseGame();
	}

	public void windowClosing(WindowEvent e) {
		ivGamePanel.stopGame();
	}

	public void windowClosed(WindowEvent e) {
	}

	public void windowOpened(WindowEvent e) {
	}

	public static void main(String args[]) {
		long period = (long) 1000.0 / DEFAULT_FPS;
		// System.out.println("fps: " + DEFAULT_FPS + "; period: " + period + "
		// ms");
		new BaBoFrame(period * 1000000L, null); // ms --> nanosecs
	}

}
