package BABO;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import javax.swing.JPanel;

import BABO.ranking.Ranker;

public class BaBoPanel extends JPanel implements Runnable {

	private static final long serialVersionUID = -856649514333186819L;
	private static final int cvPANEL_WIDTH = 1000;
	private static final int cvPANEL_HEIGHT = 1000;

	private static final int cvNO_DELAYS_PER_YIELD = 16;
	private static final int cvMAX_FRAME_SKIPS = 5;

	private Thread ivAnimator; // the thread that performs the animation
	private volatile boolean isRunning = false; // used to stop the animation
																							// thread
	private volatile boolean isPaused = false;

	private long ivPeriod; // period between drawing in _nanosecs_

	private long ivGameStartTime; // when the game started
	private int ivTimeSpentInGame;

	// used at game termination
	private volatile boolean isGameOver = false;
	private int ivScore = 0;

	// off-screen rendering
	private Graphics ivGraphics;
	private Image ivImage = null;

	private Font ivDefaultFont;
	private FontMetrics ivDefaultFontMetrics;

	private int zoomX = -1;
	private int zoomY = -1;
	private Image ivResizeImage = null;

	private TileManager ivTileManager = new TileManager();

	public BaBoPanel(Ranker ranker, long period, ArrayList<Tile> tiles) {
		this.ivPeriod = period;

		ivTileManager.setRanker(ranker);
		ivTileManager.setStartPosition(500, 500);
		ivTileManager.setTiles(tiles);

		setDoubleBuffered(false);
		setBackground(Color.white);
		setPreferredSize(new Dimension(cvPANEL_WIDTH, cvPANEL_HEIGHT));

		setFocusable(true);
		requestFocus(); // the JPanel now has focus, so receives key events

		addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				processKey(e);
			}
		});

		ivDefaultFont = new Font("SansSerif", Font.BOLD, 24);
		ivDefaultFontMetrics = this.getFontMetrics(ivDefaultFont);

	}

	private void processKey(KeyEvent e) {
		int keyCode = e.getKeyCode();

		if ((keyCode == KeyEvent.VK_ESCAPE) || (keyCode == KeyEvent.VK_Q) || (keyCode == KeyEvent.VK_END) || ((keyCode == KeyEvent.VK_C) && e.isControlDown()))
			isRunning = false;

		if (keyCode == KeyEvent.VK_H) {
			isPaused = !isPaused;
		}

		// game-play keys
		if (!isPaused && !isGameOver) {
			// move the sprite and ribbons based on the arrow key pressed
			if (keyCode == KeyEvent.VK_LEFT) {
				// TODO
			} else if (keyCode == KeyEvent.VK_RIGHT) {

			} else if (keyCode == KeyEvent.VK_UP) {

			} else if (keyCode == KeyEvent.VK_DOWN) {

			}
		}
	} // end of processKey()

	public void addNotify() {
		super.addNotify();
		startGame();
	}

	private void startGame() {
		if (ivAnimator == null || !isRunning) {
			ivAnimator = new Thread(this);
			ivAnimator.start();
		}

	}

	public void resumeGame() {
		isPaused = false;
	}

	public void pauseGame() {
		isPaused = true;
	}

	public void stopGame() {
		isRunning = false;
	}
	
	public void run() {
		long beforeTime, afterTime, timeDiff, sleepTime;
		long overSleepTime = 0L;
		int noDelays = 0;
		long excess = 0L;

		ivGameStartTime = System.nanoTime();
		beforeTime = ivGameStartTime;

		isRunning = true;

		while (isRunning) {

			if (!isPaused)
				isPaused = ivTileManager.isStopped();

			gameUpdate();
			gameRender();
			paintScreen();

			afterTime = System.nanoTime();
			timeDiff = afterTime - beforeTime;
			sleepTime = (ivPeriod - timeDiff) - overSleepTime;

			if (sleepTime > 0) {
				try {
					Thread.sleep(sleepTime / 1000000L); // nano -> ms
				} catch (InterruptedException ex) {
				}
				overSleepTime = (System.nanoTime() - afterTime) - sleepTime;
			} else {
				excess -= sleepTime;
				overSleepTime = 0L;

				if (++noDelays >= cvNO_DELAYS_PER_YIELD) {
					Thread.yield();
					noDelays = 0;
				}
			}

			beforeTime = System.nanoTime();

			int skips = 0;
			while ((excess > ivPeriod) && (skips < cvMAX_FRAME_SKIPS)) {
				excess -= ivPeriod;
				gameUpdate(); // update state but don't render
				skips++;
			}
		}
		// System.exit(0);
	}

	boolean b = true;

	private void gameUpdate() {
		if (!isPaused && !isGameOver) {
//			long t1 = System.nanoTime();
			ivTileManager.update();
//			long t2 = System.nanoTime();
//			System.out.println((t2-t1)/1000000);
		}
	}

	private void gameRender() {
		if (ivImage == null) {
			ivImage = createImage(cvPANEL_WIDTH, cvPANEL_HEIGHT);
			if (ivImage == null) {
				System.out.println("dbImage is null");
				return;
			} else
				ivGraphics = ivImage.getGraphics();
		}


		// draw a white background
		ivGraphics.setColor(Color.white);
		ivGraphics.fillRect(0, 0, cvPANEL_WIDTH, cvPANEL_HEIGHT);

		// draw the game elements: order is important
		ivTileManager.draw(ivGraphics);

		if (isGameOver)
			gameOverMessage(ivGraphics);

		// if (isPaused)
		// TODO pause
		
		if(zoomX != -1 && zoomY != -1)
			ivResizeImage = createResizedCopy(ivImage, zoomX, zoomY, true);
	}

	public static BufferedImage createResizedCopy(Image originalImage, int scaledWidth, int scaledHeight, boolean preserveAlpha) {
		
		
		int imageType = preserveAlpha ? BufferedImage.TYPE_INT_RGB : BufferedImage.TYPE_INT_ARGB;
		BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, imageType);
		Graphics2D g = scaledBI.createGraphics();
		
		g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
		g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		
		if (preserveAlpha) {
			g.setComposite(AlphaComposite.Src);
		}
		g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
		g.dispose();
		return scaledBI;
	}

	private void gameOverMessage(Graphics g) {
		String msg = "Game Over. Your score: " + ivScore;

		int x = (cvPANEL_WIDTH - ivDefaultFontMetrics.stringWidth(msg)) / 2;
		int y = (cvPANEL_HEIGHT - ivDefaultFontMetrics.getHeight()) / 2;
		g.setColor(Color.black);
		g.setFont(ivDefaultFont);
		g.drawString(msg, x, y);
	}

	private void paintScreen() {
		Graphics g;
		try {
			g = this.getGraphics();
			if ((g != null) && (ivImage != null)) {
				if(ivResizeImage != null){
					g.drawImage(ivResizeImage, 0, 0, null);
				}else{
					g.drawImage(ivImage, 0, 0, null);
				}
			}
			// Sync the display on some systems.
			// (on Linux, this fixes event queue problems)
			Toolkit.getDefaultToolkit().sync();
			g.dispose();
		} catch (Exception e) {
			System.out.println("Graphics context error: " + e);
		}
	}

	public void setZoom(int x, int y) {
		zoomX = x;
		zoomY = y;
		setPreferredSize(new Dimension(x, y));
		setSize(x, y);
		setMaximumSize(new Dimension(x, y));
		setMinimumSize(new Dimension(x, y));
	}

}
