package BABO;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Clip {

	private int ivID_1 = -1;
	private int ivID_2 = -1;

	private Point2D ivPosition_1 = null;
	private Point2D ivPosition_2 = null;

	private Point2D ivPosition_3 = null;
	private Point2D ivPosition_4 = null;
	
	public Clip(IDLineWrapper wrap){
		ivID_1 = wrap.getId1();
		ivID_2 = wrap.getId2();
		ivPosition_1 = wrap.getPosition_1();
		ivPosition_2 = wrap.getPosition_2();
		init();
	}
	
	public Clip(int id1,int id2, Point2D pos1, Point2D pos2){
		ivID_1 = id1;
		ivID_2 = id2;
		ivPosition_1 = pos1;
		ivPosition_2 = pos2;
		init();
	}
	
	public Clip(Clip clip) {
		ivID_1 = clip.ivID_1;
		ivID_2 = clip.ivID_2;
		ivPosition_1 = clip.ivPosition_1;
		ivPosition_2 = clip.ivPosition_2;
		ivPosition_3 = clip.ivPosition_3;
		ivPosition_4 = clip.ivPosition_4;
	}

	public void newPoints(Point2D pos1, Point2D pos2){
		ivPosition_1 = pos1;
		ivPosition_2 = pos2;
		init();
		
	}
	
	private void init() {
		calcPositions(true);
	}
	
	public void switchSide() {
		calcPositions(false);
	}

	private void calcPositions(boolean upleft){
		double xB = ivPosition_1.getX() > ivPosition_2.getX() ? ivPosition_1.getX() : ivPosition_2.getX();
		double xL = ivPosition_1.getX() < ivPosition_2.getX() ? ivPosition_1.getX() : ivPosition_2.getX();
		double yB = ivPosition_1.getY() > ivPosition_2.getY() ? ivPosition_1.getY() : ivPosition_2.getY();
		double yL = ivPosition_1.getY() < ivPosition_2.getY() ? ivPosition_1.getY() : ivPosition_2.getY();
		
		if(xB == xL){
			double newx = upleft ? xB - 10 : xB + 10;
			double y3 = ivPosition_2.getY() == yL ? ivPosition_2.getY() + 10 : ivPosition_2.getY() - 10;
			double y4 = ivPosition_1.getY() == yL ? ivPosition_1.getY() + 10 : ivPosition_1.getY() - 10;
			
			ivPosition_3 = new Point2D.Double(newx, y3);
			ivPosition_4 = new Point2D.Double(newx, y4);
		}else{
			double newy = upleft ? yB - 10 : yB + 10;
			double x3 = ivPosition_2.getX() == xL ? ivPosition_2.getX() + 10 : ivPosition_2.getX() - 10;
			double x4 = ivPosition_1.getX() == xL ? ivPosition_1.getX() + 10 : ivPosition_1.getX() - 10;

			ivPosition_3 = new Point2D.Double(x3, newy);
			ivPosition_4 = new Point2D.Double(x4, newy);
		}
		
	}


	public void draw(Graphics2D g) {
//		g.draw(new Line2D.Double(ivPosition_1, ivPosition_2));//Dotted Line drawn from Tile
		g.draw(new Line2D.Double(ivPosition_2, ivPosition_3));
		g.draw(new Line2D.Double(ivPosition_3, ivPosition_4));
		g.draw(new Line2D.Double(ivPosition_4, ivPosition_1));
		
	}

	public boolean hassameIDs(IDLineWrapper lineWrapper) {
		
		if((ivID_1 == lineWrapper.getId1() && ivID_2 == lineWrapper.getId2()) 
				|| (ivID_2 == lineWrapper.getId1() && ivID_1 == lineWrapper.getId2())){
			return true;
		}
		return false;
	}

	public Polygon getRectangle() {
		int[] x = new int[]{(int)ivPosition_1.getX(), (int)ivPosition_2.getX(), (int)ivPosition_3.getX(), (int)ivPosition_4.getX()};
		int[] y = new int[]{(int)ivPosition_1.getY(), (int)ivPosition_2.getY(), (int)ivPosition_3.getY(), (int)ivPosition_4.getY()};
		return new Polygon(x,y,4);
	}

	public void translate(int x, int y) {
		ivPosition_1 = new Point2D.Double(ivPosition_1.getX() + x, ivPosition_1.getY() + y);
		ivPosition_2 = new Point2D.Double(ivPosition_2.getX() + x, ivPosition_2.getY() + y);
		ivPosition_3 = new Point2D.Double(ivPosition_3.getX() + x, ivPosition_3.getY() + y);
		ivPosition_4 = new Point2D.Double(ivPosition_4.getX() + x, ivPosition_4.getY() + y);
		
	}
	
	
	
}
