package BABO;

import java.awt.BasicStroke;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Random;

import javax.vecmath.Point3d;

/**
 * Pltchen mit 4 Ecken.
 * 
 * 
 * @author synchron
 * 
 */
public class Tile {

	public static final int cvWidth = 70;

	public TileManager manager = null;

	public static final int cvDir_OL_OR = 0;
	public static final int cvDir_OR_UR = 1;
	public static final int cvDir_UR_UL = 2;
	public static final int cvDir_UL_OL = 3;

	public static final int cvLinestyle_solid = 0;
	public static final int cvLinestyle_dotted = 1;
	public static final int cvLinestyle_empty = 2;
	public static final int cvLinestyle_solid2 = 3;

	public static int cvMaxtrys = 16;

	private int ivCorner_1_ID = -1;
	private int ivCorner_2_ID = -1;
	private int ivCorner_3_ID = -1;
	private int ivCorner_4_ID = -1;

	private Point2D ivCorner_1_point = null;
	private Point2D ivCorner_2_point = null;
	private Point2D ivCorner_3_point = null;
	private Point2D ivCorner_4_point = null;

	private Point3d ivCorner_1_3d_point = null;
	private Point3d ivCorner_2_3d_point = null;
	private Point3d ivCorner_3_3d_point = null;
	private Point3d ivCorner_4_3d_point = null;

	private int ivLine_1_2_style = 0;
	private int ivLine_2_3_style = 0;
	private int ivLine_3_4_style = 0;
	private int ivLine_4_1_style = 0;

	private int ivID = -1;

	private int ivRandomFirstFixID = -1;
	private int ivRandomSecondFixID = -1;

	public Tile(int id, int corner1, Point3d corner_1_3d_point, int corner2, Point3d corner_2_3d_point, int corner3, Point3d corner_3_3d_point, int corner4, Point3d corner_4_3d_point) {

		ivID = id;

		ivCorner_1_ID = corner1;
		ivCorner_2_ID = corner2;
		ivCorner_3_ID = corner3;
		ivCorner_4_ID = corner4;

		ivCorner_1_3d_point = corner_1_3d_point;
		ivCorner_2_3d_point = corner_2_3d_point;
		ivCorner_3_3d_point = corner_3_3d_point;
		ivCorner_4_3d_point = corner_4_3d_point;

		setRandomFixpoints();

	}

	public Tile(Tile tile) {
		ivCorner_1_ID = tile.ivCorner_1_ID;
		ivCorner_2_ID = tile.ivCorner_2_ID;
		ivCorner_3_ID = tile.ivCorner_3_ID;
		ivCorner_4_ID = tile.ivCorner_4_ID;

		ivCorner_1_point = tile.ivCorner_1_point;
		ivCorner_2_point = tile.ivCorner_2_point;
		ivCorner_3_point = tile.ivCorner_3_point;
		ivCorner_4_point = tile.ivCorner_4_point;

		ivCorner_1_3d_point = tile.ivCorner_1_3d_point;
		ivCorner_2_3d_point = tile.ivCorner_2_3d_point;
		ivCorner_3_3d_point = tile.ivCorner_3_3d_point;
		ivCorner_4_3d_point = tile.ivCorner_4_3d_point;

		ivLine_1_2_style = tile.ivLine_1_2_style;
		ivLine_2_3_style = tile.ivLine_2_3_style;
		ivLine_3_4_style = tile.ivLine_3_4_style;
		ivLine_4_1_style = tile.ivLine_4_1_style;

		ivID = tile.ivID;

		ivRandomFirstFixID = tile.ivRandomFirstFixID;
		ivRandomSecondFixID = tile.ivRandomSecondFixID;
	}

	public void setManager(TileManager m) {
		manager = m;
	}

	public int getID() {
		return ivID;
	}

	private int randCounter = 0;

	public void setRandomFixpoints() {

		randCounter++;

		if (randCounter < 9) {

			if (randCounter == 5) {
				int fid = ivCorner_1_ID;
				int sid = ivCorner_2_ID;
				ivCorner_1_ID = ivCorner_4_ID;
				ivCorner_2_ID = ivCorner_3_ID;
				ivCorner_3_ID = sid;
				ivCorner_4_ID = fid;
			}

			Random rand = new Random();
			int r = rand.nextInt(4);
			switch (r) {
			case 0:
				ivRandomFirstFixID = ivCorner_1_ID;
				ivRandomSecondFixID = ivCorner_2_ID;
				break;
			case 1:
				ivRandomFirstFixID = ivCorner_2_ID;
				ivRandomSecondFixID = ivCorner_3_ID;
				break;
			case 2:
				ivRandomFirstFixID = ivCorner_3_ID;
				ivRandomSecondFixID = ivCorner_4_ID;
				break;
			case 3:
				ivRandomFirstFixID = ivCorner_4_ID;
				ivRandomSecondFixID = ivCorner_1_ID;
				break;
			default:
				break;
			}
		} else {

			if (randCounter == 13) {
				int fid = ivCorner_1_ID;
				int sid = ivCorner_2_ID;
				ivCorner_1_ID = ivCorner_4_ID;
				ivCorner_2_ID = ivCorner_3_ID;
				ivCorner_3_ID = sid;
				ivCorner_4_ID = fid;
			}

			switch (randCounter) {
			case 9:
			case 13:
				ivRandomFirstFixID = ivCorner_1_ID;
				ivRandomSecondFixID = ivCorner_2_ID;
				break;
			case 10:
			case 14:
				ivRandomFirstFixID = ivCorner_2_ID;
				ivRandomSecondFixID = ivCorner_3_ID;
				break;
			case 11:
			case 15:
				ivRandomFirstFixID = ivCorner_3_ID;
				ivRandomSecondFixID = ivCorner_4_ID;
				break;
			case 12:
			case 16:
				ivRandomFirstFixID = ivCorner_4_ID;
				ivRandomSecondFixID = ivCorner_1_ID;
				break;
			default:
				break;
			}
		}

	}

	public Tile init() {
		return init(null);
	}

	public Tile init(Point2D start) {
		if (start != null) {
			ivCorner_1_point = start;
			ivCorner_2_point = new Point2D.Double(ivCorner_1_point.getX() + cvWidth, ivCorner_1_point.getY());
			ivCorner_3_point = new Point2D.Double(ivCorner_1_point.getX() + cvWidth, ivCorner_1_point.getY() + cvWidth);
			ivCorner_4_point = new Point2D.Double(ivCorner_1_point.getX(), ivCorner_1_point.getY() + cvWidth);
			return null;

		} else {
			Line2D.Double line = manager.getPositions(ivRandomFirstFixID, ivRandomSecondFixID);

			if (line == null) {
				return this;
			}

			Point2D.Double f1 = new Point2D.Double(line.x1, line.y1);
			Point2D.Double f2 = new Point2D.Double(line.x2, line.y2);

			// public static final int cvDir_OL_OR = 0;
			// public static final int cvDir_OR_UR = 1;
			// public static final int cvDir_UR_UL = 2;
			// public static final int cvDir_UL_OL = 3;

			int dir = -1;
			if (f1.getX() - f2.getX() == 0) {
				if (f1.getY() > f2.getY())
					dir = cvDir_UL_OL;
				else
					dir = cvDir_OR_UR;
			} else if (f1.getY() - f2.getY() == 0) {
				if (f1.getX() > f2.getX())
					dir = cvDir_OL_OR;
				else
					dir = cvDir_UR_UL;
			}

			if (ivRandomFirstFixID == ivCorner_1_ID) {
				ivCorner_1_point = f1;
				ivCorner_2_point = f2;

				if (dir == cvDir_UL_OL) {
					ivCorner_3_point = new Point2D.Double(f2.getX() + cvWidth, f2.getY());
					ivCorner_4_point = new Point2D.Double(f1.getX() + cvWidth, f1.getY());
				} else if (dir == cvDir_OL_OR) {
					ivCorner_3_point = new Point2D.Double(f2.getX(), f2.getY() - cvWidth);
					ivCorner_4_point = new Point2D.Double(f1.getX(), f1.getY() - cvWidth);
				} else if (dir == cvDir_OR_UR) {
					ivCorner_3_point = new Point2D.Double(f2.getX() - cvWidth, f2.getY());
					ivCorner_4_point = new Point2D.Double(f1.getX() - cvWidth, f1.getY());
				} else if (dir == cvDir_UR_UL) {
					ivCorner_3_point = new Point2D.Double(f2.getX(), f2.getY() + cvWidth);
					ivCorner_4_point = new Point2D.Double(f1.getX(), f1.getY() + cvWidth);
				}
				return null;
			} else if (ivRandomFirstFixID == ivCorner_2_ID) {
				ivCorner_2_point = f1;
				ivCorner_3_point = f2;

				if (dir == cvDir_UL_OL) {
					ivCorner_4_point = new Point2D.Double(f2.getX() + cvWidth, f2.getY());
					ivCorner_1_point = new Point2D.Double(f1.getX() + cvWidth, f1.getY());
				} else if (dir == cvDir_OL_OR) {
					ivCorner_4_point = new Point2D.Double(f2.getX(), f2.getY() - cvWidth);
					ivCorner_1_point = new Point2D.Double(f1.getX(), f1.getY() - cvWidth);
				} else if (dir == cvDir_OR_UR) {
					ivCorner_4_point = new Point2D.Double(f2.getX() - cvWidth, f2.getY());
					ivCorner_1_point = new Point2D.Double(f1.getX() - cvWidth, f1.getY());
				} else if (dir == cvDir_UR_UL) {
					ivCorner_4_point = new Point2D.Double(f2.getX(), f2.getY() + cvWidth);
					ivCorner_1_point = new Point2D.Double(f1.getX(), f1.getY() + cvWidth);
				}
				return null;
			} else if (ivRandomFirstFixID == ivCorner_3_ID) {
				ivCorner_3_point = f1;
				ivCorner_4_point = f2;

				if (dir == cvDir_UL_OL) {
					ivCorner_1_point = new Point2D.Double(f2.getX() + cvWidth, f2.getY());
					ivCorner_2_point = new Point2D.Double(f1.getX() + cvWidth, f1.getY());
				} else if (dir == cvDir_OL_OR) {
					ivCorner_1_point = new Point2D.Double(f2.getX(), f2.getY() - cvWidth);
					ivCorner_2_point = new Point2D.Double(f1.getX(), f1.getY() - cvWidth);
				} else if (dir == cvDir_OR_UR) {
					ivCorner_1_point = new Point2D.Double(f2.getX() - cvWidth, f2.getY());
					ivCorner_2_point = new Point2D.Double(f1.getX() - cvWidth, f1.getY());
				} else if (dir == cvDir_UR_UL) {
					ivCorner_1_point = new Point2D.Double(f2.getX(), f2.getY() + cvWidth);
					ivCorner_2_point = new Point2D.Double(f1.getX(), f1.getY() + cvWidth);
				}
				return null;
			} else if (ivRandomFirstFixID == ivCorner_4_ID) {
				ivCorner_4_point = f1;
				ivCorner_1_point = f2;

				if (dir == cvDir_UL_OL) {
					ivCorner_2_point = new Point2D.Double(f2.getX() + cvWidth, f2.getY());
					ivCorner_3_point = new Point2D.Double(f1.getX() + cvWidth, f1.getY());
				} else if (dir == cvDir_OL_OR) {
					ivCorner_2_point = new Point2D.Double(f2.getX(), f2.getY() - cvWidth);
					ivCorner_3_point = new Point2D.Double(f1.getX(), f1.getY() - cvWidth);
				} else if (dir == cvDir_OR_UR) {
					ivCorner_2_point = new Point2D.Double(f2.getX() - cvWidth, f2.getY());
					ivCorner_3_point = new Point2D.Double(f1.getX() - cvWidth, f1.getY());
				} else if (dir == cvDir_UR_UL) {
					ivCorner_2_point = new Point2D.Double(f2.getX(), f2.getY() + cvWidth);
					ivCorner_3_point = new Point2D.Double(f1.getX(), f1.getY() + cvWidth);
				}
				return null;
			}

			// System.out.println("XXXXX " + ivID);
			// System.out.println(ivRandomFirstFixID + " : " + ivRandomSecondFixID);
			// System.out.println(line.x1 + " : " + line.y1 + " : " + line.x2 + " : "
			// + line.y2);

		}
		return this;
	}

	public void draw(Graphics2D g) {

		Stroke s = g.getStroke();
		Stroke stroke = new BasicStroke(1.0f, BasicStroke.CAP_SQUARE, BasicStroke.JOIN_ROUND, 15.0f, new float[] { 10.8f, 10.4f }, 12.0f);
		
		if (ivCorner_1_point != null && ivCorner_2_point != null && ivCorner_3_point != null && ivCorner_4_point != null) {

			if (ivLine_1_2_style == cvLinestyle_dotted) {
				g.setStroke(stroke);
				g.draw(new Line2D.Double(ivCorner_1_point, ivCorner_2_point));
				g.setStroke(s);
			} else if (ivLine_1_2_style == cvLinestyle_solid || ivLine_1_2_style == cvLinestyle_solid2) {
				g.draw(new Line2D.Double(ivCorner_1_point, ivCorner_2_point));
			}

			if (ivLine_2_3_style == cvLinestyle_dotted) {
				g.setStroke(stroke);
				g.draw(new Line2D.Double(ivCorner_2_point, ivCorner_3_point));
				g.setStroke(s);
			} else if (ivLine_2_3_style == cvLinestyle_solid || ivLine_2_3_style == cvLinestyle_solid2) {
				g.draw(new Line2D.Double(ivCorner_2_point, ivCorner_3_point));
			}

			if (ivLine_3_4_style == cvLinestyle_dotted) {
				g.setStroke(stroke);
				g.draw(new Line2D.Double(ivCorner_3_point, ivCorner_4_point));
				g.setStroke(s);
			} else if (ivLine_3_4_style == cvLinestyle_solid || ivLine_3_4_style == cvLinestyle_solid2) {
				g.draw(new Line2D.Double(ivCorner_3_point, ivCorner_4_point));
			}

			if (ivLine_4_1_style == cvLinestyle_dotted) {
				g.setStroke(stroke);
				g.draw(new Line2D.Double(ivCorner_4_point, ivCorner_1_point));
				g.setStroke(s);
			} else if (ivLine_4_1_style == cvLinestyle_solid || ivLine_4_1_style == cvLinestyle_solid2) {
				g.draw(new Line2D.Double(ivCorner_4_point, ivCorner_1_point));
			}

		}
	}

	public void print() {
		System.out.println("Tile: " + ivID + " : " + ivCorner_1_point + " " + ivCorner_2_point + " " + ivCorner_3_point + " " + ivCorner_4_point + " ");
	}

	@Override
	public boolean equals(Object o) {
		if (o instanceof Tile) {
			if (((Tile) o).ivID == ivID)
				return true;
		}
		return false;
	}

	public boolean hassamePoints(Tile t2) {

		if (ivCorner_1_point == null || t2.ivCorner_1_point == null)
			return true;

		String s = ";" + ivCorner_1_point.getX() + "_" + ivCorner_1_point.getY() + ";" + ivCorner_2_point.getX() + "_" + ivCorner_2_point.getY() + ";" + ivCorner_3_point.getX() + "_" + ivCorner_3_point.getY() + ";" + ivCorner_4_point.getX() + "_" + ivCorner_4_point.getY() + ";";

		if (s.contains(";" + t2.ivCorner_1_point.getX() + "_" + t2.ivCorner_1_point.getY() + ";") && s.contains(";" + t2.ivCorner_2_point.getX() + "_" + t2.ivCorner_2_point.getY() + ";") && s.contains(";" + t2.ivCorner_3_point.getX() + "_" + t2.ivCorner_3_point.getY() + ";") && s.contains(";" + t2.ivCorner_4_point.getX() + "_" + t2.ivCorner_4_point.getY() + ";"))
			return true;

		return false;
	}

	public void clear(boolean randclear) {
		ivCorner_1_point = null;
		ivCorner_2_point = null;
		ivCorner_3_point = null;
		ivCorner_4_point = null;

		ivLine_1_2_style = cvLinestyle_solid;
		ivLine_2_3_style = cvLinestyle_solid;
		ivLine_3_4_style = cvLinestyle_solid;
		ivLine_4_1_style = cvLinestyle_solid;

		setRandomFixpoints();

		if (randclear)
			randCounter = 0;

	}

	public boolean canRandom() {
		return randCounter < cvMaxtrys;
	}

	public boolean hassamePoints(int id, Point2D p2) {
		if(id == -1 || p2 == null)
			return false;
		
		String s = ";" + ivCorner_1_ID + "_" + ivCorner_1_point.getX() + "_" + ivCorner_1_point.getY() + ";" + ivCorner_2_ID + "_" + ivCorner_2_point.getX() + "_" + ivCorner_2_point.getY() + ";" + ivCorner_3_ID + "_" + ivCorner_3_point.getX() + "_" + ivCorner_3_point.getY() + ";" + ivCorner_4_ID + "_" + ivCorner_4_point.getX() + "_" + ivCorner_4_point.getY() + ";";

		if (s.contains(";" + id + "_" + p2.getX() + "_" + p2.getY() + ";"))
			return true;
		return false;
	}

	@Override
	public String toString() {
		return "Tile: ID: " + ivID + "Cornerid's: " + ivCorner_1_ID + ";" + ivCorner_2_ID + ";" + ivCorner_3_ID + ";" + ivCorner_4_ID + ";";
	}

	public boolean hassameIDs(Tile t2) {

		String s = ";" + ivCorner_1_ID + ";" + ivCorner_2_ID + ";" + ivCorner_3_ID + ";" + ivCorner_4_ID + ";";

		if (s.contains(";" + t2.ivCorner_1_ID + ";") && s.contains(";" + t2.ivCorner_2_ID + ";") && s.contains(";" + t2.ivCorner_3_ID + ";") && s.contains(";" + t2.ivCorner_4_ID + ";"))
			return true;

		return false;
	}

	public boolean hasIDs(int id1, int id2) {
		String s = ";" + ivCorner_1_ID + ";" + ivCorner_2_ID + ";" + ivCorner_3_ID + ";" + ivCorner_4_ID + ";";

		if (s.contains(";" + id1 + ";") && s.contains(";" + id2 + ";"))
			return true;

		return false;
	}

	public Point2D getPoint(int id) {
		if (ivCorner_1_ID == id) {
			return ivCorner_1_point;
		} else if (ivCorner_2_ID == id) {
			return ivCorner_2_point;
		} else if (ivCorner_3_ID == id) {
			return ivCorner_3_point;
		} else if (ivCorner_4_ID == id) {
			return ivCorner_4_point;
		}
		return null;
	}

	public void setLineStates(Tile t2) {
		if (t2.equals(this))
			return;

		String s = ";" + t2.ivCorner_1_point.getX() + "_" + t2.ivCorner_1_point.getY() + ";" + t2.ivCorner_2_point.getX() + "_" + t2.ivCorner_2_point.getY() + ";" + t2.ivCorner_3_point.getX() + "_" + t2.ivCorner_3_point.getY() + ";" + t2.ivCorner_4_point.getX() + "_" + t2.ivCorner_4_point.getY() + ";";

		if (ivLine_1_2_style == 0 && s.contains(";" + ivCorner_1_point.getX() + "_" + ivCorner_1_point.getY() + ";") && s.contains(";" + ivCorner_2_point.getX() + "_" + ivCorner_2_point.getY() + ";")) {
			if (hasCut(t2, ivCorner_1_point, ivCorner_1_ID, ivCorner_2_point, ivCorner_2_ID)) {
				ivLine_1_2_style = cvLinestyle_solid2;
				t2.setLineStyle(ivCorner_1_point, ivCorner_2_point, cvLinestyle_empty);
			} else if (hasBreak(t2)) {
				ivLine_1_2_style = cvLinestyle_dotted;
				t2.setLineStyle(ivCorner_1_point, ivCorner_2_point, cvLinestyle_empty);
			} else {
				ivLine_1_2_style = cvLinestyle_empty;
				t2.setLineStyle(ivCorner_1_point, ivCorner_2_point, cvLinestyle_empty);
			}
		}

		if (ivLine_2_3_style == 0 && s.contains(";" + ivCorner_2_point.getX() + "_" + ivCorner_2_point.getY() + ";") && s.contains(";" + ivCorner_3_point.getX() + "_" + ivCorner_3_point.getY() + ";")) {
			if (hasCut(t2, ivCorner_2_point, ivCorner_2_ID, ivCorner_3_point, ivCorner_3_ID)) {
				ivLine_2_3_style = cvLinestyle_solid2;
				t2.setLineStyle(ivCorner_2_point, ivCorner_3_point, cvLinestyle_empty);
			} else if (hasBreak(t2)) {
				ivLine_2_3_style = cvLinestyle_dotted;
				t2.setLineStyle(ivCorner_2_point, ivCorner_3_point, cvLinestyle_empty);
			} else {
				ivLine_2_3_style = cvLinestyle_empty;
				t2.setLineStyle(ivCorner_2_point, ivCorner_3_point, cvLinestyle_empty);
			}
		}

		if (ivLine_3_4_style == 0 && s.contains(";" + ivCorner_3_point.getX() + "_" + ivCorner_3_point.getY() + ";") && s.contains(";" + ivCorner_4_point.getX() + "_" + ivCorner_4_point.getY() + ";")) {
			if (hasCut(t2, ivCorner_3_point, ivCorner_3_ID, ivCorner_4_point, ivCorner_4_ID)) {
				ivLine_3_4_style = cvLinestyle_solid2;
				t2.setLineStyle(ivCorner_3_point, ivCorner_4_point, cvLinestyle_empty);
			} else if (hasBreak(t2)) {
				ivLine_3_4_style = cvLinestyle_dotted;
				t2.setLineStyle(ivCorner_3_point, ivCorner_4_point, cvLinestyle_empty);
			} else {
				ivLine_3_4_style = cvLinestyle_empty;
				t2.setLineStyle(ivCorner_3_point, ivCorner_4_point, cvLinestyle_empty);
			}
		}

		if (ivLine_4_1_style == 0 && s.contains(";" + ivCorner_4_point.getX() + "_" + ivCorner_4_point.getY() + ";") && s.contains(";" + ivCorner_1_point.getX() + "_" + ivCorner_1_point.getY() + ";")) {
			if (hasCut(t2, ivCorner_4_point, ivCorner_4_ID, ivCorner_1_point, ivCorner_1_ID)) {
				ivLine_4_1_style = cvLinestyle_solid2;
				t2.setLineStyle(ivCorner_4_point, ivCorner_1_point, cvLinestyle_empty);
			} else if (hasBreak(t2)) {
				ivLine_4_1_style = cvLinestyle_dotted;
				t2.setLineStyle(ivCorner_4_point, ivCorner_1_point, cvLinestyle_empty);
			} else {
				ivLine_4_1_style = cvLinestyle_empty;
				t2.setLineStyle(ivCorner_4_point, ivCorner_1_point, cvLinestyle_empty);
			}
		}
	}

	private void setLineStyle(Point2D p1, Point2D p2, int style) {

		String s = null;

		if (p1.equals(ivCorner_1_point)) {
			s = "1_";
		} else if (p1.equals(ivCorner_2_point)) {
			s = "2_";
		} else if (p1.equals(ivCorner_3_point)) {
			s = "3_";
		} else if (p1.equals(ivCorner_4_point)) {
			s = "4_";
		}

		if (p2.equals(ivCorner_1_point)) {
			s += "1";
		} else if (p2.equals(ivCorner_2_point)) {
			s += "2";
		} else if (p2.equals(ivCorner_3_point)) {
			s += "3";
		} else if (p2.equals(ivCorner_4_point)) {
			s += "4";
		}

		if (ivLine_1_2_style == 0 && ("1_2".equals(s) || "2_1".equals(s))) {
			ivLine_1_2_style = style;
		} else if (ivLine_2_3_style == 0 && ("2_3".equals(s) || "3_2".equals(s))) {
			ivLine_2_3_style = style;
		} else if (ivLine_3_4_style == 0 && ("3_4".equals(s) || "4_3".equals(s))) {
			ivLine_3_4_style = style;
		} else if (ivLine_4_1_style == 0 && ("4_1".equals(s) || "1_4".equals(s))) {
			ivLine_4_1_style = style;
		}

	}

	public boolean hasBreak(Tile t2) {
		
		int direction1 = ivCorner_1_3d_point.getX() == ivCorner_3_3d_point.getX() ? 1 : 0;
		if (direction1 == 0)
			direction1 = ivCorner_1_3d_point.getY() == ivCorner_3_3d_point.getY() ? 2 : 0;
		if (direction1 == 0)
			direction1 = ivCorner_1_3d_point.getZ() == ivCorner_3_3d_point.getZ() ? 3 : 0;

		int direction2 = t2.ivCorner_1_3d_point.getX() == t2.ivCorner_3_3d_point.getX() ? 1 : 0;
		if (direction2 == 0)
			direction2 = t2.ivCorner_1_3d_point.getY() == t2.ivCorner_3_3d_point.getY() ? 2 : 0;
		if (direction2 == 0)
			direction2 = t2.ivCorner_1_3d_point.getZ() == t2.ivCorner_3_3d_point.getZ() ? 3 : 0;

		if (direction1 == direction2)
			return false;
		return true;
	}

	private boolean hasCut(Tile t2, Point2D corner1, int cornerid1, Point2D corner2, int cornerid2) {
		int cid1 = t2.getCornerID(corner1);
		int cid2 = t2.getCornerID(corner2);

		if ((cid1 == cornerid1 && cid2 == cornerid2) || (cid2 == cornerid1 && cid1 == cornerid2))
			return false;
		return true;
	}

	private int getCornerID(Point2D corner) {
		if (ivCorner_1_point.equals(corner))
			return ivCorner_1_ID;
		if (ivCorner_2_point.equals(corner))
			return ivCorner_2_ID;
		if (ivCorner_3_point.equals(corner))
			return ivCorner_3_ID;
		if (ivCorner_4_point.equals(corner))
			return ivCorner_4_ID;
		return 0;
	}

	public ArrayList<IDLineWrapper> getSolidLines() {
		ArrayList<IDLineWrapper> ret = new ArrayList<IDLineWrapper>();
		if (ivLine_1_2_style == cvLinestyle_solid || ivLine_1_2_style == cvLinestyle_solid2)
			ret.add(new IDLineWrapper(ivCorner_1_ID, ivCorner_2_ID, ivCorner_1_point, ivCorner_2_point));

		if (ivLine_2_3_style == cvLinestyle_solid || ivLine_2_3_style == cvLinestyle_solid2)
			ret.add(new IDLineWrapper(ivCorner_2_ID, ivCorner_3_ID, ivCorner_2_point, ivCorner_3_point));

		if (ivLine_3_4_style == cvLinestyle_solid || ivLine_3_4_style == cvLinestyle_solid2)
			ret.add(new IDLineWrapper(ivCorner_3_ID, ivCorner_4_ID, ivCorner_3_point, ivCorner_4_point));

		if (ivLine_4_1_style == cvLinestyle_solid || ivLine_4_1_style == cvLinestyle_solid2)
			ret.add(new IDLineWrapper(ivCorner_4_ID, ivCorner_1_ID, ivCorner_4_point, ivCorner_1_point));

		return ret;
	}

	public ArrayList<IDLineWrapper> getDottedLines() {
		ArrayList<IDLineWrapper> ret = new ArrayList<IDLineWrapper>();
		if (ivLine_1_2_style == cvLinestyle_dotted)
			ret.add(new IDLineWrapper(ivCorner_1_ID, ivCorner_2_ID, ivCorner_1_point, ivCorner_2_point));

		if (ivLine_2_3_style == cvLinestyle_dotted)
			ret.add(new IDLineWrapper(ivCorner_2_ID, ivCorner_3_ID, ivCorner_2_point, ivCorner_3_point));

		if (ivLine_3_4_style == cvLinestyle_dotted)
			ret.add(new IDLineWrapper(ivCorner_3_ID, ivCorner_4_ID, ivCorner_3_point, ivCorner_4_point));

		if (ivLine_4_1_style == cvLinestyle_dotted)
			ret.add(new IDLineWrapper(ivCorner_4_ID, ivCorner_1_ID, ivCorner_4_point, ivCorner_1_point));
		return ret;
	}

	public Rectangle2D.Double getRectangle() {
		double xL = ivCorner_1_point.getX() < ivCorner_3_point.getX() ? ivCorner_1_point.getX() : ivCorner_3_point.getX();
		double yL = ivCorner_1_point.getY() < ivCorner_3_point.getY() ? ivCorner_1_point.getY() : ivCorner_3_point.getY();

		return new Rectangle2D.Double(xL, yL, cvWidth, cvWidth);
	}

	public double getBigX() {
		return ivCorner_1_point.getX() > ivCorner_3_point.getX() ? ivCorner_1_point.getX() : ivCorner_3_point.getX();
	}

	public double getLowX() {
		return ivCorner_1_point.getX() < ivCorner_3_point.getX() ? ivCorner_1_point.getX() : ivCorner_3_point.getX();
	}

	public double getBigY() {
		return ivCorner_1_point.getY() > ivCorner_3_point.getY() ? ivCorner_1_point.getY() : ivCorner_3_point.getY();
	}

	public double getLowY() {
		return ivCorner_1_point.getY() < ivCorner_3_point.getY() ? ivCorner_1_point.getY() : ivCorner_3_point.getY();
	}

	public void translate(int x, int y) {
		ivCorner_1_point = new Point2D.Double(ivCorner_1_point.getX() + x, ivCorner_1_point.getY() + y);
		ivCorner_2_point = new Point2D.Double(ivCorner_2_point.getX() + x, ivCorner_2_point.getY() + y);
		ivCorner_3_point = new Point2D.Double(ivCorner_3_point.getX() + x, ivCorner_3_point.getY() + y);
		ivCorner_4_point = new Point2D.Double(ivCorner_4_point.getX() + x, ivCorner_4_point.getY() + y);

	}

	public void setDotted(int id1, int id2) {
		if((id1 == ivCorner_1_ID && id2 == ivCorner_2_ID) || (id2 == ivCorner_1_ID && id1 == ivCorner_2_ID)){
			ivLine_1_2_style = cvLinestyle_dotted;
		}else if((id1 == ivCorner_2_ID && id2 == ivCorner_3_ID) || (id2 == ivCorner_2_ID && id1 == ivCorner_3_ID)){
			ivLine_2_3_style = cvLinestyle_dotted;
		}else if((id1 == ivCorner_3_ID && id2 == ivCorner_4_ID) || (id2 == ivCorner_3_ID && id1 == ivCorner_4_ID)){
			ivLine_3_4_style = cvLinestyle_dotted;
		}else if((id1 == ivCorner_4_ID && id2 == ivCorner_1_ID) || (id2 == ivCorner_4_ID && id1 == ivCorner_1_ID)){
			ivLine_4_1_style = cvLinestyle_dotted;
		}
	}

	public int getFixID1() {
		return ivRandomFirstFixID;
	}

	public Point2D getFixPoint1() {
		if(ivRandomFirstFixID == ivCorner_1_ID)
			return ivCorner_1_point;
		if(ivRandomFirstFixID == ivCorner_2_ID)
			return ivCorner_2_point;
		if(ivRandomFirstFixID == ivCorner_3_ID)
			return ivCorner_3_point;
		if(ivRandomFirstFixID == ivCorner_4_ID)
			return ivCorner_4_point;
		return null;
	}

	public int getFixID2() {
		return ivRandomSecondFixID;
	}

	public Point2D getFixPoint2() {
		if(ivRandomSecondFixID == ivCorner_1_ID)
			return ivCorner_1_point;
		if(ivRandomSecondFixID == ivCorner_2_ID)
			return ivCorner_2_point;
		if(ivRandomSecondFixID == ivCorner_3_ID)
			return ivCorner_3_point;
		if(ivRandomSecondFixID == ivCorner_4_ID)
			return ivCorner_4_point;
		return null;
	}

	public IDPoint[] getPoints() {

		double xB = ivCorner_1_point.getX() > ivCorner_3_point.getX() ? ivCorner_1_point.getX() : ivCorner_3_point.getX();
		double xL = ivCorner_1_point.getX() < ivCorner_3_point.getX() ? ivCorner_1_point.getX() : ivCorner_3_point.getX();
		double yB = ivCorner_1_point.getY() > ivCorner_3_point.getY() ? ivCorner_1_point.getY() : ivCorner_3_point.getY();
		double yL = ivCorner_1_point.getY() < ivCorner_3_point.getY() ? ivCorner_1_point.getY() : ivCorner_3_point.getY();

			double xp = (xB - xL) / 2;
			double yp = (yB - yL) / 2;

			
			int stringh = 12;
			int stringw = String.valueOf(ivCorner_1_ID).length() * 10;

				double x = ivCorner_1_point.getX() == xB ? ivCorner_1_point.getX() - stringw : ivCorner_1_point.getX() + 2;
				double y = ivCorner_1_point.getY() == yL ? ivCorner_1_point.getY() + stringh : ivCorner_1_point.getY() - 2;
				IDPoint p1 = new IDPoint(ivCorner_1_ID, ivCorner_1_point, x, y);
				

				stringw = String.valueOf(ivCorner_2_ID).length() * 10;
				x = ivCorner_2_point.getX() == xB ? ivCorner_2_point.getX() - stringw : ivCorner_2_point.getX() + 2;
				y = ivCorner_2_point.getY() == yL ? ivCorner_2_point.getY() + stringh : ivCorner_2_point.getY() - 2;
				IDPoint p2 = new IDPoint(ivCorner_2_ID, ivCorner_2_point, x, y);
				
				
				stringw = String.valueOf(ivCorner_3_ID).length() * 10;
				x = ivCorner_3_point.getX() == xB ? ivCorner_3_point.getX() - stringw : ivCorner_3_point.getX() + 2;
				y = ivCorner_3_point.getY() == yL ? ivCorner_3_point.getY() + stringh : ivCorner_3_point.getY() - 2;
				IDPoint p3 = new IDPoint(ivCorner_3_ID, ivCorner_3_point, x, y);
				
				
				stringw = String.valueOf(ivCorner_4_ID).length() * 10;
				x = ivCorner_4_point.getX() == xB ? ivCorner_4_point.getX() - stringw : ivCorner_4_point.getX() + 2;
				y = ivCorner_4_point.getY() == yL ? ivCorner_4_point.getY() + stringh : ivCorner_4_point.getY() - 2;
				IDPoint p4 = new IDPoint(ivCorner_4_ID, ivCorner_4_point, x, y);
				return new IDPoint[]{p1,p2,p3,p4};
		
	}

	
	
}
